/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides data for a specific usage metric and the corresponding quota for an Amazon Macie account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageByAccount implements SdkPojo, Serializable, ToCopyableBuilder<UsageByAccount.Builder, UsageByAccount> {
    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currency").getter(getter(UsageByAccount::currencyAsString)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()).build();

    private static final SdkField<String> ESTIMATED_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("estimatedCost").getter(getter(UsageByAccount::estimatedCost)).setter(setter(Builder::estimatedCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCost").build()).build();

    private static final SdkField<ServiceLimit> SERVICE_LIMIT_FIELD = SdkField.<ServiceLimit> builder(MarshallingType.SDK_POJO)
            .memberName("serviceLimit").getter(getter(UsageByAccount::serviceLimit)).setter(setter(Builder::serviceLimit))
            .constructor(ServiceLimit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceLimit").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(UsageByAccount::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_FIELD,
            ESTIMATED_COST_FIELD, SERVICE_LIMIT_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("currency", CURRENCY_FIELD);
                    put("estimatedCost", ESTIMATED_COST_FIELD);
                    put("serviceLimit", SERVICE_LIMIT_FIELD);
                    put("type", TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String currency;

    private final String estimatedCost;

    private final ServiceLimit serviceLimit;

    private final String type;

    private UsageByAccount(BuilderImpl builder) {
        this.currency = builder.currency;
        this.estimatedCost = builder.estimatedCost;
        this.serviceLimit = builder.serviceLimit;
        this.type = builder.type;
    }

    /**
     * <p>
     * The type of currency that the value for the metric (estimatedCost) is reported in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link Currency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The type of currency that the value for the metric (estimatedCost) is reported in.
     * @see Currency
     */
    public final Currency currency() {
        return Currency.fromValue(currency);
    }

    /**
     * <p>
     * The type of currency that the value for the metric (estimatedCost) is reported in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link Currency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The type of currency that the value for the metric (estimatedCost) is reported in.
     * @see Currency
     */
    public final String currencyAsString() {
        return currency;
    }

    /**
     * <p>
     * The estimated value for the metric.
     * </p>
     * 
     * @return The estimated value for the metric.
     */
    public final String estimatedCost() {
        return estimatedCost;
    }

    /**
     * <p>
     * The current value for the quota that corresponds to the metric specified by the type field.
     * </p>
     * 
     * @return The current value for the quota that corresponds to the metric specified by the type field.
     */
    public final ServiceLimit serviceLimit() {
        return serviceLimit;
    }

    /**
     * <p>
     * The name of the metric. Possible values are: AUTOMATED_OBJECT_MONITORING, to monitor S3 objects for automated
     * sensitive data discovery; AUTOMATED_SENSITIVE_DATA_DISCOVERY, to analyze S3 objects for automated sensitive data
     * discovery; DATA_INVENTORY_EVALUATION, to monitor S3 buckets; and, SENSITIVE_DATA_DISCOVERY, to run classification
     * jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The name of the metric. Possible values are: AUTOMATED_OBJECT_MONITORING, to monitor S3 objects for
     *         automated sensitive data discovery; AUTOMATED_SENSITIVE_DATA_DISCOVERY, to analyze S3 objects for
     *         automated sensitive data discovery; DATA_INVENTORY_EVALUATION, to monitor S3 buckets; and,
     *         SENSITIVE_DATA_DISCOVERY, to run classification jobs.
     * @see UsageType
     */
    public final UsageType type() {
        return UsageType.fromValue(type);
    }

    /**
     * <p>
     * The name of the metric. Possible values are: AUTOMATED_OBJECT_MONITORING, to monitor S3 objects for automated
     * sensitive data discovery; AUTOMATED_SENSITIVE_DATA_DISCOVERY, to analyze S3 objects for automated sensitive data
     * discovery; DATA_INVENTORY_EVALUATION, to monitor S3 buckets; and, SENSITIVE_DATA_DISCOVERY, to run classification
     * jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The name of the metric. Possible values are: AUTOMATED_OBJECT_MONITORING, to monitor S3 objects for
     *         automated sensitive data discovery; AUTOMATED_SENSITIVE_DATA_DISCOVERY, to analyze S3 objects for
     *         automated sensitive data discovery; DATA_INVENTORY_EVALUATION, to monitor S3 buckets; and,
     *         SENSITIVE_DATA_DISCOVERY, to run classification jobs.
     * @see UsageType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCost());
        hashCode = 31 * hashCode + Objects.hashCode(serviceLimit());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageByAccount)) {
            return false;
        }
        UsageByAccount other = (UsageByAccount) obj;
        return Objects.equals(currencyAsString(), other.currencyAsString())
                && Objects.equals(estimatedCost(), other.estimatedCost()) && Objects.equals(serviceLimit(), other.serviceLimit())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageByAccount").add("Currency", currencyAsString()).add("EstimatedCost", estimatedCost())
                .add("ServiceLimit", serviceLimit()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "currency":
            return Optional.ofNullable(clazz.cast(currencyAsString()));
        case "estimatedCost":
            return Optional.ofNullable(clazz.cast(estimatedCost()));
        case "serviceLimit":
            return Optional.ofNullable(clazz.cast(serviceLimit()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UsageByAccount, T> g) {
        return obj -> g.apply((UsageByAccount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageByAccount> {
        /**
         * <p>
         * The type of currency that the value for the metric (estimatedCost) is reported in.
         * </p>
         * 
         * @param currency
         *        The type of currency that the value for the metric (estimatedCost) is reported in.
         * @see Currency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Currency
         */
        Builder currency(String currency);

        /**
         * <p>
         * The type of currency that the value for the metric (estimatedCost) is reported in.
         * </p>
         * 
         * @param currency
         *        The type of currency that the value for the metric (estimatedCost) is reported in.
         * @see Currency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Currency
         */
        Builder currency(Currency currency);

        /**
         * <p>
         * The estimated value for the metric.
         * </p>
         * 
         * @param estimatedCost
         *        The estimated value for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCost(String estimatedCost);

        /**
         * <p>
         * The current value for the quota that corresponds to the metric specified by the type field.
         * </p>
         * 
         * @param serviceLimit
         *        The current value for the quota that corresponds to the metric specified by the type field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceLimit(ServiceLimit serviceLimit);

        /**
         * <p>
         * The current value for the quota that corresponds to the metric specified by the type field.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceLimit.Builder} avoiding the need
         * to create one manually via {@link ServiceLimit#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceLimit.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceLimit(ServiceLimit)}.
         * 
         * @param serviceLimit
         *        a consumer that will call methods on {@link ServiceLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceLimit(ServiceLimit)
         */
        default Builder serviceLimit(Consumer<ServiceLimit.Builder> serviceLimit) {
            return serviceLimit(ServiceLimit.builder().applyMutation(serviceLimit).build());
        }

        /**
         * <p>
         * The name of the metric. Possible values are: AUTOMATED_OBJECT_MONITORING, to monitor S3 objects for automated
         * sensitive data discovery; AUTOMATED_SENSITIVE_DATA_DISCOVERY, to analyze S3 objects for automated sensitive
         * data discovery; DATA_INVENTORY_EVALUATION, to monitor S3 buckets; and, SENSITIVE_DATA_DISCOVERY, to run
         * classification jobs.
         * </p>
         * 
         * @param type
         *        The name of the metric. Possible values are: AUTOMATED_OBJECT_MONITORING, to monitor S3 objects for
         *        automated sensitive data discovery; AUTOMATED_SENSITIVE_DATA_DISCOVERY, to analyze S3 objects for
         *        automated sensitive data discovery; DATA_INVENTORY_EVALUATION, to monitor S3 buckets; and,
         *        SENSITIVE_DATA_DISCOVERY, to run classification jobs.
         * @see UsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageType
         */
        Builder type(String type);

        /**
         * <p>
         * The name of the metric. Possible values are: AUTOMATED_OBJECT_MONITORING, to monitor S3 objects for automated
         * sensitive data discovery; AUTOMATED_SENSITIVE_DATA_DISCOVERY, to analyze S3 objects for automated sensitive
         * data discovery; DATA_INVENTORY_EVALUATION, to monitor S3 buckets; and, SENSITIVE_DATA_DISCOVERY, to run
         * classification jobs.
         * </p>
         * 
         * @param type
         *        The name of the metric. Possible values are: AUTOMATED_OBJECT_MONITORING, to monitor S3 objects for
         *        automated sensitive data discovery; AUTOMATED_SENSITIVE_DATA_DISCOVERY, to analyze S3 objects for
         *        automated sensitive data discovery; DATA_INVENTORY_EVALUATION, to monitor S3 buckets; and,
         *        SENSITIVE_DATA_DISCOVERY, to run classification jobs.
         * @see UsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageType
         */
        Builder type(UsageType type);
    }

    static final class BuilderImpl implements Builder {
        private String currency;

        private String estimatedCost;

        private ServiceLimit serviceLimit;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageByAccount model) {
            currency(model.currency);
            estimatedCost(model.estimatedCost);
            serviceLimit(model.serviceLimit);
            type(model.type);
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(Currency currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final String getEstimatedCost() {
            return estimatedCost;
        }

        public final void setEstimatedCost(String estimatedCost) {
            this.estimatedCost = estimatedCost;
        }

        @Override
        public final Builder estimatedCost(String estimatedCost) {
            this.estimatedCost = estimatedCost;
            return this;
        }

        public final ServiceLimit.Builder getServiceLimit() {
            return serviceLimit != null ? serviceLimit.toBuilder() : null;
        }

        public final void setServiceLimit(ServiceLimit.BuilderImpl serviceLimit) {
            this.serviceLimit = serviceLimit != null ? serviceLimit.build() : null;
        }

        @Override
        public final Builder serviceLimit(ServiceLimit serviceLimit) {
            this.serviceLimit = serviceLimit;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UsageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public UsageByAccount build() {
            return new UsageByAccount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
