/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the type and other characteristics of an entity that performed an action on an affected
 * resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserIdentity implements SdkPojo, Serializable, ToCopyableBuilder<UserIdentity.Builder, UserIdentity> {
    private static final SdkField<AssumedRole> ASSUMED_ROLE_FIELD = SdkField.<AssumedRole> builder(MarshallingType.SDK_POJO)
            .memberName("assumedRole").getter(getter(UserIdentity::assumedRole)).setter(setter(Builder::assumedRole))
            .constructor(AssumedRole::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assumedRole").build()).build();

    private static final SdkField<AwsAccount> AWS_ACCOUNT_FIELD = SdkField.<AwsAccount> builder(MarshallingType.SDK_POJO)
            .memberName("awsAccount").getter(getter(UserIdentity::awsAccount)).setter(setter(Builder::awsAccount))
            .constructor(AwsAccount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccount").build()).build();

    private static final SdkField<AwsService> AWS_SERVICE_FIELD = SdkField.<AwsService> builder(MarshallingType.SDK_POJO)
            .memberName("awsService").getter(getter(UserIdentity::awsService)).setter(setter(Builder::awsService))
            .constructor(AwsService::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsService").build()).build();

    private static final SdkField<FederatedUser> FEDERATED_USER_FIELD = SdkField
            .<FederatedUser> builder(MarshallingType.SDK_POJO).memberName("federatedUser")
            .getter(getter(UserIdentity::federatedUser)).setter(setter(Builder::federatedUser))
            .constructor(FederatedUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("federatedUser").build()).build();

    private static final SdkField<IamUser> IAM_USER_FIELD = SdkField.<IamUser> builder(MarshallingType.SDK_POJO)
            .memberName("iamUser").getter(getter(UserIdentity::iamUser)).setter(setter(Builder::iamUser))
            .constructor(IamUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamUser").build()).build();

    private static final SdkField<UserIdentityRoot> ROOT_FIELD = SdkField.<UserIdentityRoot> builder(MarshallingType.SDK_POJO)
            .memberName("root").getter(getter(UserIdentity::root)).setter(setter(Builder::root))
            .constructor(UserIdentityRoot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("root").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(UserIdentity::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSUMED_ROLE_FIELD,
            AWS_ACCOUNT_FIELD, AWS_SERVICE_FIELD, FEDERATED_USER_FIELD, IAM_USER_FIELD, ROOT_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("assumedRole", ASSUMED_ROLE_FIELD);
                    put("awsAccount", AWS_ACCOUNT_FIELD);
                    put("awsService", AWS_SERVICE_FIELD);
                    put("federatedUser", FEDERATED_USER_FIELD);
                    put("iamUser", IAM_USER_FIELD);
                    put("root", ROOT_FIELD);
                    put("type", TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final AssumedRole assumedRole;

    private final AwsAccount awsAccount;

    private final AwsService awsService;

    private final FederatedUser federatedUser;

    private final IamUser iamUser;

    private final UserIdentityRoot root;

    private final String type;

    private UserIdentity(BuilderImpl builder) {
        this.assumedRole = builder.assumedRole;
        this.awsAccount = builder.awsAccount;
        this.awsService = builder.awsService;
        this.federatedUser = builder.federatedUser;
        this.iamUser = builder.iamUser;
        this.root = builder.root;
        this.type = builder.type;
    }

    /**
     * <p>
     * If the action was performed with temporary security credentials that were obtained using the AssumeRole operation
     * of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.
     * </p>
     * 
     * @return If the action was performed with temporary security credentials that were obtained using the AssumeRole
     *         operation of the Security Token Service (STS) API, the identifiers, session context, and other details
     *         about the identity.
     */
    public final AssumedRole assumedRole() {
        return assumedRole;
    }

    /**
     * <p>
     * If the action was performed using the credentials for another Amazon Web Services account, the details of that
     * account.
     * </p>
     * 
     * @return If the action was performed using the credentials for another Amazon Web Services account, the details of
     *         that account.
     */
    public final AwsAccount awsAccount() {
        return awsAccount;
    }

    /**
     * <p>
     * If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name of
     * the service.
     * </p>
     * 
     * @return If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the
     *         name of the service.
     */
    public final AwsService awsService() {
        return awsService;
    }

    /**
     * <p>
     * If the action was performed with temporary security credentials that were obtained using the GetFederationToken
     * operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the
     * identity.
     * </p>
     * 
     * @return If the action was performed with temporary security credentials that were obtained using the
     *         GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context,
     *         and other details about the identity.
     */
    public final FederatedUser federatedUser() {
        return federatedUser;
    }

    /**
     * <p>
     * If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name and
     * other details about the user.
     * </p>
     * 
     * @return If the action was performed using the credentials for an Identity and Access Management (IAM) user, the
     *         name and other details about the user.
     */
    public final IamUser iamUser() {
        return iamUser;
    }

    /**
     * <p>
     * If the action was performed using the credentials for your Amazon Web Services account, the details of your
     * account.
     * </p>
     * 
     * @return If the action was performed using the credentials for your Amazon Web Services account, the details of
     *         your account.
     */
    public final UserIdentityRoot root() {
        return root;
    }

    /**
     * <p>
     * The type of entity that performed the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserIdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of entity that performed the action.
     * @see UserIdentityType
     */
    public final UserIdentityType type() {
        return UserIdentityType.fromValue(type);
    }

    /**
     * <p>
     * The type of entity that performed the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserIdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of entity that performed the action.
     * @see UserIdentityType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assumedRole());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccount());
        hashCode = 31 * hashCode + Objects.hashCode(awsService());
        hashCode = 31 * hashCode + Objects.hashCode(federatedUser());
        hashCode = 31 * hashCode + Objects.hashCode(iamUser());
        hashCode = 31 * hashCode + Objects.hashCode(root());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdentity)) {
            return false;
        }
        UserIdentity other = (UserIdentity) obj;
        return Objects.equals(assumedRole(), other.assumedRole()) && Objects.equals(awsAccount(), other.awsAccount())
                && Objects.equals(awsService(), other.awsService()) && Objects.equals(federatedUser(), other.federatedUser())
                && Objects.equals(iamUser(), other.iamUser()) && Objects.equals(root(), other.root())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserIdentity").add("AssumedRole", assumedRole()).add("AwsAccount", awsAccount())
                .add("AwsService", awsService()).add("FederatedUser", federatedUser()).add("IamUser", iamUser())
                .add("Root", root()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assumedRole":
            return Optional.ofNullable(clazz.cast(assumedRole()));
        case "awsAccount":
            return Optional.ofNullable(clazz.cast(awsAccount()));
        case "awsService":
            return Optional.ofNullable(clazz.cast(awsService()));
        case "federatedUser":
            return Optional.ofNullable(clazz.cast(federatedUser()));
        case "iamUser":
            return Optional.ofNullable(clazz.cast(iamUser()));
        case "root":
            return Optional.ofNullable(clazz.cast(root()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UserIdentity, T> g) {
        return obj -> g.apply((UserIdentity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserIdentity> {
        /**
         * <p>
         * If the action was performed with temporary security credentials that were obtained using the AssumeRole
         * operation of the Security Token Service (STS) API, the identifiers, session context, and other details about
         * the identity.
         * </p>
         * 
         * @param assumedRole
         *        If the action was performed with temporary security credentials that were obtained using the
         *        AssumeRole operation of the Security Token Service (STS) API, the identifiers, session context, and
         *        other details about the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumedRole(AssumedRole assumedRole);

        /**
         * <p>
         * If the action was performed with temporary security credentials that were obtained using the AssumeRole
         * operation of the Security Token Service (STS) API, the identifiers, session context, and other details about
         * the identity.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssumedRole.Builder} avoiding the need to
         * create one manually via {@link AssumedRole#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssumedRole.Builder#build()} is called immediately and its result
         * is passed to {@link #assumedRole(AssumedRole)}.
         * 
         * @param assumedRole
         *        a consumer that will call methods on {@link AssumedRole.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assumedRole(AssumedRole)
         */
        default Builder assumedRole(Consumer<AssumedRole.Builder> assumedRole) {
            return assumedRole(AssumedRole.builder().applyMutation(assumedRole).build());
        }

        /**
         * <p>
         * If the action was performed using the credentials for another Amazon Web Services account, the details of
         * that account.
         * </p>
         * 
         * @param awsAccount
         *        If the action was performed using the credentials for another Amazon Web Services account, the details
         *        of that account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccount(AwsAccount awsAccount);

        /**
         * <p>
         * If the action was performed using the credentials for another Amazon Web Services account, the details of
         * that account.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsAccount.Builder} avoiding the need to
         * create one manually via {@link AwsAccount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsAccount.Builder#build()} is called immediately and its result
         * is passed to {@link #awsAccount(AwsAccount)}.
         * 
         * @param awsAccount
         *        a consumer that will call methods on {@link AwsAccount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsAccount(AwsAccount)
         */
        default Builder awsAccount(Consumer<AwsAccount.Builder> awsAccount) {
            return awsAccount(AwsAccount.builder().applyMutation(awsAccount).build());
        }

        /**
         * <p>
         * If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name
         * of the service.
         * </p>
         * 
         * @param awsService
         *        If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service,
         *        the name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsService(AwsService awsService);

        /**
         * <p>
         * If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name
         * of the service.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsService.Builder} avoiding the need to
         * create one manually via {@link AwsService#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsService.Builder#build()} is called immediately and its result
         * is passed to {@link #awsService(AwsService)}.
         * 
         * @param awsService
         *        a consumer that will call methods on {@link AwsService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsService(AwsService)
         */
        default Builder awsService(Consumer<AwsService.Builder> awsService) {
            return awsService(AwsService.builder().applyMutation(awsService).build());
        }

        /**
         * <p>
         * If the action was performed with temporary security credentials that were obtained using the
         * GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context, and
         * other details about the identity.
         * </p>
         * 
         * @param federatedUser
         *        If the action was performed with temporary security credentials that were obtained using the
         *        GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session
         *        context, and other details about the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federatedUser(FederatedUser federatedUser);

        /**
         * <p>
         * If the action was performed with temporary security credentials that were obtained using the
         * GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context, and
         * other details about the identity.
         * </p>
         * This is a convenience method that creates an instance of the {@link FederatedUser.Builder} avoiding the need
         * to create one manually via {@link FederatedUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FederatedUser.Builder#build()} is called immediately and its
         * result is passed to {@link #federatedUser(FederatedUser)}.
         * 
         * @param federatedUser
         *        a consumer that will call methods on {@link FederatedUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #federatedUser(FederatedUser)
         */
        default Builder federatedUser(Consumer<FederatedUser.Builder> federatedUser) {
            return federatedUser(FederatedUser.builder().applyMutation(federatedUser).build());
        }

        /**
         * <p>
         * If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name
         * and other details about the user.
         * </p>
         * 
         * @param iamUser
         *        If the action was performed using the credentials for an Identity and Access Management (IAM) user,
         *        the name and other details about the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUser(IamUser iamUser);

        /**
         * <p>
         * If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name
         * and other details about the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamUser.Builder} avoiding the need to
         * create one manually via {@link IamUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamUser.Builder#build()} is called immediately and its result is
         * passed to {@link #iamUser(IamUser)}.
         * 
         * @param iamUser
         *        a consumer that will call methods on {@link IamUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamUser(IamUser)
         */
        default Builder iamUser(Consumer<IamUser.Builder> iamUser) {
            return iamUser(IamUser.builder().applyMutation(iamUser).build());
        }

        /**
         * <p>
         * If the action was performed using the credentials for your Amazon Web Services account, the details of your
         * account.
         * </p>
         * 
         * @param root
         *        If the action was performed using the credentials for your Amazon Web Services account, the details of
         *        your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder root(UserIdentityRoot root);

        /**
         * <p>
         * If the action was performed using the credentials for your Amazon Web Services account, the details of your
         * account.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserIdentityRoot.Builder} avoiding the
         * need to create one manually via {@link UserIdentityRoot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserIdentityRoot.Builder#build()} is called immediately and its
         * result is passed to {@link #root(UserIdentityRoot)}.
         * 
         * @param root
         *        a consumer that will call methods on {@link UserIdentityRoot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #root(UserIdentityRoot)
         */
        default Builder root(Consumer<UserIdentityRoot.Builder> root) {
            return root(UserIdentityRoot.builder().applyMutation(root).build());
        }

        /**
         * <p>
         * The type of entity that performed the action.
         * </p>
         * 
         * @param type
         *        The type of entity that performed the action.
         * @see UserIdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserIdentityType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of entity that performed the action.
         * </p>
         * 
         * @param type
         *        The type of entity that performed the action.
         * @see UserIdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserIdentityType
         */
        Builder type(UserIdentityType type);
    }

    static final class BuilderImpl implements Builder {
        private AssumedRole assumedRole;

        private AwsAccount awsAccount;

        private AwsService awsService;

        private FederatedUser federatedUser;

        private IamUser iamUser;

        private UserIdentityRoot root;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UserIdentity model) {
            assumedRole(model.assumedRole);
            awsAccount(model.awsAccount);
            awsService(model.awsService);
            federatedUser(model.federatedUser);
            iamUser(model.iamUser);
            root(model.root);
            type(model.type);
        }

        public final AssumedRole.Builder getAssumedRole() {
            return assumedRole != null ? assumedRole.toBuilder() : null;
        }

        public final void setAssumedRole(AssumedRole.BuilderImpl assumedRole) {
            this.assumedRole = assumedRole != null ? assumedRole.build() : null;
        }

        @Override
        public final Builder assumedRole(AssumedRole assumedRole) {
            this.assumedRole = assumedRole;
            return this;
        }

        public final AwsAccount.Builder getAwsAccount() {
            return awsAccount != null ? awsAccount.toBuilder() : null;
        }

        public final void setAwsAccount(AwsAccount.BuilderImpl awsAccount) {
            this.awsAccount = awsAccount != null ? awsAccount.build() : null;
        }

        @Override
        public final Builder awsAccount(AwsAccount awsAccount) {
            this.awsAccount = awsAccount;
            return this;
        }

        public final AwsService.Builder getAwsService() {
            return awsService != null ? awsService.toBuilder() : null;
        }

        public final void setAwsService(AwsService.BuilderImpl awsService) {
            this.awsService = awsService != null ? awsService.build() : null;
        }

        @Override
        public final Builder awsService(AwsService awsService) {
            this.awsService = awsService;
            return this;
        }

        public final FederatedUser.Builder getFederatedUser() {
            return federatedUser != null ? federatedUser.toBuilder() : null;
        }

        public final void setFederatedUser(FederatedUser.BuilderImpl federatedUser) {
            this.federatedUser = federatedUser != null ? federatedUser.build() : null;
        }

        @Override
        public final Builder federatedUser(FederatedUser federatedUser) {
            this.federatedUser = federatedUser;
            return this;
        }

        public final IamUser.Builder getIamUser() {
            return iamUser != null ? iamUser.toBuilder() : null;
        }

        public final void setIamUser(IamUser.BuilderImpl iamUser) {
            this.iamUser = iamUser != null ? iamUser.build() : null;
        }

        @Override
        public final Builder iamUser(IamUser iamUser) {
            this.iamUser = iamUser;
            return this;
        }

        public final UserIdentityRoot.Builder getRoot() {
            return root != null ? root.toBuilder() : null;
        }

        public final void setRoot(UserIdentityRoot.BuilderImpl root) {
            this.root = root != null ? root.build() : null;
        }

        @Override
        public final Builder root(UserIdentityRoot root) {
            this.root = root;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserIdentityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public UserIdentity build() {
            return new UserIdentity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
