/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedDataIdentifierSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedDataIdentifierSummary> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(ManagedDataIdentifierSummary.getter(ManagedDataIdentifierSummary::categoryAsString)).setter(ManagedDataIdentifierSummary.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ManagedDataIdentifierSummary.getter(ManagedDataIdentifierSummary::id)).setter(ManagedDataIdentifierSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("category", CATEGORY_FIELD);
            this.put("id", ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String category;
    private final String id;

    private ManagedDataIdentifierSummary(BuilderImpl builder) {
        this.category = builder.category;
        this.id = builder.id;
    }

    public final SensitiveDataItemCategory category() {
        return SensitiveDataItemCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedDataIdentifierSummary)) {
            return false;
        }
        ManagedDataIdentifierSummary other = (ManagedDataIdentifierSummary)obj;
        return Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedDataIdentifierSummary").add("Category", (Object)this.categoryAsString()).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ManagedDataIdentifierSummary, T> g) {
        return obj -> g.apply((ManagedDataIdentifierSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedDataIdentifierSummary model) {
            this.category(model.category);
            this.id(model.id);
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(SensitiveDataItemCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public ManagedDataIdentifierSummary build() {
            return new ManagedDataIdentifierSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedDataIdentifierSummary> {
        public Builder category(String var1);

        public Builder category(SensitiveDataItemCategory var1);

        public Builder id(String var1);
    }
}

