/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the number of S3 buckets that are or aren't shared with other Amazon Web Services
 * accounts, Amazon CloudFront origin access identities (OAIs), or CloudFront origin access controls (OACs). In this
 * data, an <i>Amazon Macie organization</i> is defined as a set of Macie accounts that are centrally managed as a group
 * of related accounts through Organizations or by Macie invitation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketCountBySharedAccessType implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketCountBySharedAccessType.Builder, BucketCountBySharedAccessType> {
    private static final SdkField<Long> EXTERNAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("external")
            .getter(getter(BucketCountBySharedAccessType::external)).setter(setter(Builder::external))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("external").build()).build();

    private static final SdkField<Long> INTERNAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("internal")
            .getter(getter(BucketCountBySharedAccessType::internal)).setter(setter(Builder::internal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("internal").build()).build();

    private static final SdkField<Long> NOT_SHARED_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("notShared")
            .getter(getter(BucketCountBySharedAccessType::notShared)).setter(setter(Builder::notShared))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notShared").build()).build();

    private static final SdkField<Long> UNKNOWN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("unknown")
            .getter(getter(BucketCountBySharedAccessType::unknown)).setter(setter(Builder::unknown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknown").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_FIELD,
            INTERNAL_FIELD, NOT_SHARED_FIELD, UNKNOWN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("external", EXTERNAL_FIELD);
                    put("internal", INTERNAL_FIELD);
                    put("notShared", NOT_SHARED_FIELD);
                    put("unknown", UNKNOWN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Long external;

    private final Long internal;

    private final Long notShared;

    private final Long unknown;

    private BucketCountBySharedAccessType(BuilderImpl builder) {
        this.external = builder.external;
        this.internal = builder.internal;
        this.notShared = builder.notShared;
        this.unknown = builder.unknown;
    }

    /**
     * <p>
     * The total number of buckets that are shared with one or more of the following or any combination of the
     * following: an Amazon CloudFront OAI, a CloudFront OAC, or an Amazon Web Services account that isn't in the same
     * Amazon Macie organization.
     * </p>
     * 
     * @return The total number of buckets that are shared with one or more of the following or any combination of the
     *         following: an Amazon CloudFront OAI, a CloudFront OAC, or an Amazon Web Services account that isn't in
     *         the same Amazon Macie organization.
     */
    public final Long external() {
        return external;
    }

    /**
     * <p>
     * The total number of buckets that are shared with one or more Amazon Web Services accounts in the same Amazon
     * Macie organization. These buckets aren't shared with Amazon CloudFront OAIs or OACs.
     * </p>
     * 
     * @return The total number of buckets that are shared with one or more Amazon Web Services accounts in the same
     *         Amazon Macie organization. These buckets aren't shared with Amazon CloudFront OAIs or OACs.
     */
    public final Long internal() {
        return internal;
    }

    /**
     * <p>
     * The total number of buckets that aren't shared with other Amazon Web Services accounts, Amazon CloudFront OAIs,
     * or CloudFront OACs.
     * </p>
     * 
     * @return The total number of buckets that aren't shared with other Amazon Web Services accounts, Amazon CloudFront
     *         OAIs, or CloudFront OACs.
     */
    public final Long notShared() {
        return notShared;
    }

    /**
     * <p>
     * The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for. Macie can't
     * determine whether these buckets are shared with other Amazon Web Services accounts, Amazon CloudFront OAIs, or
     * CloudFront OACs.
     * </p>
     * 
     * @return The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for. Macie
     *         can't determine whether these buckets are shared with other Amazon Web Services accounts, Amazon
     *         CloudFront OAIs, or CloudFront OACs.
     */
    public final Long unknown() {
        return unknown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(external());
        hashCode = 31 * hashCode + Objects.hashCode(internal());
        hashCode = 31 * hashCode + Objects.hashCode(notShared());
        hashCode = 31 * hashCode + Objects.hashCode(unknown());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketCountBySharedAccessType)) {
            return false;
        }
        BucketCountBySharedAccessType other = (BucketCountBySharedAccessType) obj;
        return Objects.equals(external(), other.external()) && Objects.equals(internal(), other.internal())
                && Objects.equals(notShared(), other.notShared()) && Objects.equals(unknown(), other.unknown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketCountBySharedAccessType").add("External", external()).add("Internal", internal())
                .add("NotShared", notShared()).add("Unknown", unknown()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "external":
            return Optional.ofNullable(clazz.cast(external()));
        case "internal":
            return Optional.ofNullable(clazz.cast(internal()));
        case "notShared":
            return Optional.ofNullable(clazz.cast(notShared()));
        case "unknown":
            return Optional.ofNullable(clazz.cast(unknown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BucketCountBySharedAccessType, T> g) {
        return obj -> g.apply((BucketCountBySharedAccessType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketCountBySharedAccessType> {
        /**
         * <p>
         * The total number of buckets that are shared with one or more of the following or any combination of the
         * following: an Amazon CloudFront OAI, a CloudFront OAC, or an Amazon Web Services account that isn't in the
         * same Amazon Macie organization.
         * </p>
         * 
         * @param external
         *        The total number of buckets that are shared with one or more of the following or any combination of
         *        the following: an Amazon CloudFront OAI, a CloudFront OAC, or an Amazon Web Services account that
         *        isn't in the same Amazon Macie organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder external(Long external);

        /**
         * <p>
         * The total number of buckets that are shared with one or more Amazon Web Services accounts in the same Amazon
         * Macie organization. These buckets aren't shared with Amazon CloudFront OAIs or OACs.
         * </p>
         * 
         * @param internal
         *        The total number of buckets that are shared with one or more Amazon Web Services accounts in the same
         *        Amazon Macie organization. These buckets aren't shared with Amazon CloudFront OAIs or OACs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internal(Long internal);

        /**
         * <p>
         * The total number of buckets that aren't shared with other Amazon Web Services accounts, Amazon CloudFront
         * OAIs, or CloudFront OACs.
         * </p>
         * 
         * @param notShared
         *        The total number of buckets that aren't shared with other Amazon Web Services accounts, Amazon
         *        CloudFront OAIs, or CloudFront OACs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notShared(Long notShared);

        /**
         * <p>
         * The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for. Macie can't
         * determine whether these buckets are shared with other Amazon Web Services accounts, Amazon CloudFront OAIs,
         * or CloudFront OACs.
         * </p>
         * 
         * @param unknown
         *        The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for.
         *        Macie can't determine whether these buckets are shared with other Amazon Web Services accounts, Amazon
         *        CloudFront OAIs, or CloudFront OACs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknown(Long unknown);
    }

    static final class BuilderImpl implements Builder {
        private Long external;

        private Long internal;

        private Long notShared;

        private Long unknown;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketCountBySharedAccessType model) {
            external(model.external);
            internal(model.internal);
            notShared(model.notShared);
            unknown(model.unknown);
        }

        public final Long getExternal() {
            return external;
        }

        public final void setExternal(Long external) {
            this.external = external;
        }

        @Override
        public final Builder external(Long external) {
            this.external = external;
            return this;
        }

        public final Long getInternal() {
            return internal;
        }

        public final void setInternal(Long internal) {
            this.internal = internal;
        }

        @Override
        public final Builder internal(Long internal) {
            this.internal = internal;
            return this;
        }

        public final Long getNotShared() {
            return notShared;
        }

        public final void setNotShared(Long notShared) {
            this.notShared = notShared;
        }

        @Override
        public final Builder notShared(Long notShared) {
            this.notShared = notShared;
            return this;
        }

        public final Long getUnknown() {
            return unknown;
        }

        public final void setUnknown(Long unknown) {
            this.unknown = unknown;
        }

        @Override
        public final Builder unknown(Long unknown) {
            this.unknown = unknown;
            return this;
        }

        @Override
        public BucketCountBySharedAccessType build() {
            return new BucketCountBySharedAccessType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
