/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies one or more property- and tag-based conditions that define criteria for including or excluding S3 buckets
 * from a classification job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CriteriaBlockForJob implements SdkPojo, Serializable,
        ToCopyableBuilder<CriteriaBlockForJob.Builder, CriteriaBlockForJob> {
    private static final SdkField<List<CriteriaForJob>> AND_FIELD = SdkField
            .<List<CriteriaForJob>> builder(MarshallingType.LIST)
            .memberName("and")
            .getter(getter(CriteriaBlockForJob::and))
            .setter(setter(Builder::and))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("and").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CriteriaForJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(CriteriaForJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("and", AND_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<CriteriaForJob> and;

    private CriteriaBlockForJob(BuilderImpl builder) {
        this.and = builder.and;
    }

    /**
     * For responses, this returns true if the service returned a value for the And property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAnd() {
        return and != null && !(and instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of conditions, one for each condition that determines which buckets to include or exclude from the job.
     * If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnd} method.
     * </p>
     * 
     * @return An array of conditions, one for each condition that determines which buckets to include or exclude from
     *         the job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.
     */
    public final List<CriteriaForJob> and() {
        return and;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAnd() ? and() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CriteriaBlockForJob)) {
            return false;
        }
        CriteriaBlockForJob other = (CriteriaBlockForJob) obj;
        return hasAnd() == other.hasAnd() && Objects.equals(and(), other.and());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CriteriaBlockForJob").add("And", hasAnd() ? and() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "and":
            return Optional.ofNullable(clazz.cast(and()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CriteriaBlockForJob, T> g) {
        return obj -> g.apply((CriteriaBlockForJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CriteriaBlockForJob> {
        /**
         * <p>
         * An array of conditions, one for each condition that determines which buckets to include or exclude from the
         * job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.
         * </p>
         * 
         * @param and
         *        An array of conditions, one for each condition that determines which buckets to include or exclude
         *        from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the
         *        conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(Collection<CriteriaForJob> and);

        /**
         * <p>
         * An array of conditions, one for each condition that determines which buckets to include or exclude from the
         * job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.
         * </p>
         * 
         * @param and
         *        An array of conditions, one for each condition that determines which buckets to include or exclude
         *        from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the
         *        conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(CriteriaForJob... and);

        /**
         * <p>
         * An array of conditions, one for each condition that determines which buckets to include or exclude from the
         * job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.CriteriaForJob.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.macie2.model.CriteriaForJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.CriteriaForJob.Builder#build()} is called immediately and
         * its result is passed to {@link #and(List<CriteriaForJob>)}.
         * 
         * @param and
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.CriteriaForJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(java.util.Collection<CriteriaForJob>)
         */
        Builder and(Consumer<CriteriaForJob.Builder>... and);
    }

    static final class BuilderImpl implements Builder {
        private List<CriteriaForJob> and = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CriteriaBlockForJob model) {
            and(model.and);
        }

        public final List<CriteriaForJob.Builder> getAnd() {
            List<CriteriaForJob.Builder> result = ___listOfCriteriaForJobCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnd(Collection<CriteriaForJob.BuilderImpl> and) {
            this.and = ___listOfCriteriaForJobCopier.copyFromBuilder(and);
        }

        @Override
        public final Builder and(Collection<CriteriaForJob> and) {
            this.and = ___listOfCriteriaForJobCopier.copy(and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(CriteriaForJob... and) {
            and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<CriteriaForJob.Builder>... and) {
            and(Stream.of(and).map(c -> CriteriaForJob.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CriteriaBlockForJob build() {
            return new CriteriaBlockForJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
