/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutomatedDiscoveryConfigurationResponse extends Macie2Response implements
        ToCopyableBuilder<GetAutomatedDiscoveryConfigurationResponse.Builder, GetAutomatedDiscoveryConfigurationResponse> {
    private static final SdkField<String> AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("autoEnableOrganizationMembers")
            .getter(getter(GetAutomatedDiscoveryConfigurationResponse::autoEnableOrganizationMembersAsString))
            .setter(setter(Builder::autoEnableOrganizationMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnableOrganizationMembers")
                    .build()).build();

    private static final SdkField<String> CLASSIFICATION_SCOPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("classificationScopeId")
            .getter(getter(GetAutomatedDiscoveryConfigurationResponse::classificationScopeId))
            .setter(setter(Builder::classificationScopeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classificationScopeId").build())
            .build();

    private static final SdkField<Instant> DISABLED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("disabledAt")
            .getter(getter(GetAutomatedDiscoveryConfigurationResponse::disabledAt))
            .setter(setter(Builder::disabledAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disabledAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> FIRST_ENABLED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstEnabledAt")
            .getter(getter(GetAutomatedDiscoveryConfigurationResponse::firstEnabledAt))
            .setter(setter(Builder::firstEnabledAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstEnabledAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetAutomatedDiscoveryConfigurationResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SENSITIVITY_INSPECTION_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("sensitivityInspectionTemplateId")
            .getter(getter(GetAutomatedDiscoveryConfigurationResponse::sensitivityInspectionTemplateId))
            .setter(setter(Builder::sensitivityInspectionTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitivityInspectionTemplateId")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetAutomatedDiscoveryConfigurationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD, CLASSIFICATION_SCOPE_ID_FIELD, DISABLED_AT_FIELD, FIRST_ENABLED_AT_FIELD,
            LAST_UPDATED_AT_FIELD, SENSITIVITY_INSPECTION_TEMPLATE_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("autoEnableOrganizationMembers", AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD);
                    put("classificationScopeId", CLASSIFICATION_SCOPE_ID_FIELD);
                    put("disabledAt", DISABLED_AT_FIELD);
                    put("firstEnabledAt", FIRST_ENABLED_AT_FIELD);
                    put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
                    put("sensitivityInspectionTemplateId", SENSITIVITY_INSPECTION_TEMPLATE_ID_FIELD);
                    put("status", STATUS_FIELD);
                }
            });

    private final String autoEnableOrganizationMembers;

    private final String classificationScopeId;

    private final Instant disabledAt;

    private final Instant firstEnabledAt;

    private final Instant lastUpdatedAt;

    private final String sensitivityInspectionTemplateId;

    private final String status;

    private GetAutomatedDiscoveryConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnableOrganizationMembers = builder.autoEnableOrganizationMembers;
        this.classificationScopeId = builder.classificationScopeId;
        this.disabledAt = builder.disabledAt;
        this.firstEnabledAt = builder.firstEnabledAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.sensitivityInspectionTemplateId = builder.sensitivityInspectionTemplateId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Specifies whether automated sensitive data discovery is enabled automatically for accounts in the organization.
     * Possible values are: ALL, enable it for all existing accounts and new member accounts; NEW, enable it only for
     * new member accounts; and, NONE, don't enable it for any accounts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoEnableOrganizationMembers} will return {@link AutoEnableMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoEnableOrganizationMembersAsString}.
     * </p>
     * 
     * @return Specifies whether automated sensitive data discovery is enabled automatically for accounts in the
     *         organization. Possible values are: ALL, enable it for all existing accounts and new member accounts; NEW,
     *         enable it only for new member accounts; and, NONE, don't enable it for any accounts.
     * @see AutoEnableMode
     */
    public final AutoEnableMode autoEnableOrganizationMembers() {
        return AutoEnableMode.fromValue(autoEnableOrganizationMembers);
    }

    /**
     * <p>
     * Specifies whether automated sensitive data discovery is enabled automatically for accounts in the organization.
     * Possible values are: ALL, enable it for all existing accounts and new member accounts; NEW, enable it only for
     * new member accounts; and, NONE, don't enable it for any accounts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoEnableOrganizationMembers} will return {@link AutoEnableMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoEnableOrganizationMembersAsString}.
     * </p>
     * 
     * @return Specifies whether automated sensitive data discovery is enabled automatically for accounts in the
     *         organization. Possible values are: ALL, enable it for all existing accounts and new member accounts; NEW,
     *         enable it only for new member accounts; and, NONE, don't enable it for any accounts.
     * @see AutoEnableMode
     */
    public final String autoEnableOrganizationMembersAsString() {
        return autoEnableOrganizationMembers;
    }

    /**
     * <p>
     * The unique identifier for the classification scope that's used when performing automated sensitive data
     * discovery. The classification scope specifies S3 buckets to exclude from analyses.
     * </p>
     * 
     * @return The unique identifier for the classification scope that's used when performing automated sensitive data
     *         discovery. The classification scope specifies S3 buckets to exclude from analyses.
     */
    public final String classificationScopeId() {
        return classificationScopeId;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when automated sensitive data discovery was most recently
     * disabled. This value is null if automated sensitive data discovery is currently enabled.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when automated sensitive data discovery was most
     *         recently disabled. This value is null if automated sensitive data discovery is currently enabled.
     */
    public final Instant disabledAt() {
        return disabledAt;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when automated sensitive data discovery was initially
     * enabled. This value is null if automated sensitive data discovery has never been enabled.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when automated sensitive data discovery was
     *         initially enabled. This value is null if automated sensitive data discovery has never been enabled.
     */
    public final Instant firstEnabledAt() {
        return firstEnabledAt;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the configuration settings or status of automated
     * sensitive data discovery was most recently changed.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the configuration settings or status of
     *         automated sensitive data discovery was most recently changed.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The unique identifier for the sensitivity inspection template that's used when performing automated sensitive
     * data discovery. The template specifies which allow lists, custom data identifiers, and managed data identifiers
     * to use when analyzing data.
     * </p>
     * 
     * @return The unique identifier for the sensitivity inspection template that's used when performing automated
     *         sensitive data discovery. The template specifies which allow lists, custom data identifiers, and managed
     *         data identifiers to use when analyzing data.
     */
    public final String sensitivityInspectionTemplateId() {
        return sensitivityInspectionTemplateId;
    }

    /**
     * <p>
     * The current status of automated sensitive data discovery for the organization or account. Possible values are:
     * ENABLED, use the specified settings to perform automated sensitive data discovery activities; and, DISABLED,
     * don't perform automated sensitive data discovery activities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutomatedDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of automated sensitive data discovery for the organization or account. Possible values
     *         are: ENABLED, use the specified settings to perform automated sensitive data discovery activities; and,
     *         DISABLED, don't perform automated sensitive data discovery activities.
     * @see AutomatedDiscoveryStatus
     */
    public final AutomatedDiscoveryStatus status() {
        return AutomatedDiscoveryStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of automated sensitive data discovery for the organization or account. Possible values are:
     * ENABLED, use the specified settings to perform automated sensitive data discovery activities; and, DISABLED,
     * don't perform automated sensitive data discovery activities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutomatedDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of automated sensitive data discovery for the organization or account. Possible values
     *         are: ENABLED, use the specified settings to perform automated sensitive data discovery activities; and,
     *         DISABLED, don't perform automated sensitive data discovery activities.
     * @see AutomatedDiscoveryStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoEnableOrganizationMembersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(classificationScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(disabledAt());
        hashCode = 31 * hashCode + Objects.hashCode(firstEnabledAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(sensitivityInspectionTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutomatedDiscoveryConfigurationResponse)) {
            return false;
        }
        GetAutomatedDiscoveryConfigurationResponse other = (GetAutomatedDiscoveryConfigurationResponse) obj;
        return Objects.equals(autoEnableOrganizationMembersAsString(), other.autoEnableOrganizationMembersAsString())
                && Objects.equals(classificationScopeId(), other.classificationScopeId())
                && Objects.equals(disabledAt(), other.disabledAt()) && Objects.equals(firstEnabledAt(), other.firstEnabledAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(sensitivityInspectionTemplateId(), other.sensitivityInspectionTemplateId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAutomatedDiscoveryConfigurationResponse")
                .add("AutoEnableOrganizationMembers", autoEnableOrganizationMembersAsString())
                .add("ClassificationScopeId", classificationScopeId()).add("DisabledAt", disabledAt())
                .add("FirstEnabledAt", firstEnabledAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("SensitivityInspectionTemplateId", sensitivityInspectionTemplateId()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoEnableOrganizationMembers":
            return Optional.ofNullable(clazz.cast(autoEnableOrganizationMembersAsString()));
        case "classificationScopeId":
            return Optional.ofNullable(clazz.cast(classificationScopeId()));
        case "disabledAt":
            return Optional.ofNullable(clazz.cast(disabledAt()));
        case "firstEnabledAt":
            return Optional.ofNullable(clazz.cast(firstEnabledAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "sensitivityInspectionTemplateId":
            return Optional.ofNullable(clazz.cast(sensitivityInspectionTemplateId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAutomatedDiscoveryConfigurationResponse, T> g) {
        return obj -> g.apply((GetAutomatedDiscoveryConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAutomatedDiscoveryConfigurationResponse> {
        /**
         * <p>
         * Specifies whether automated sensitive data discovery is enabled automatically for accounts in the
         * organization. Possible values are: ALL, enable it for all existing accounts and new member accounts; NEW,
         * enable it only for new member accounts; and, NONE, don't enable it for any accounts.
         * </p>
         * 
         * @param autoEnableOrganizationMembers
         *        Specifies whether automated sensitive data discovery is enabled automatically for accounts in the
         *        organization. Possible values are: ALL, enable it for all existing accounts and new member accounts;
         *        NEW, enable it only for new member accounts; and, NONE, don't enable it for any accounts.
         * @see AutoEnableMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoEnableMode
         */
        Builder autoEnableOrganizationMembers(String autoEnableOrganizationMembers);

        /**
         * <p>
         * Specifies whether automated sensitive data discovery is enabled automatically for accounts in the
         * organization. Possible values are: ALL, enable it for all existing accounts and new member accounts; NEW,
         * enable it only for new member accounts; and, NONE, don't enable it for any accounts.
         * </p>
         * 
         * @param autoEnableOrganizationMembers
         *        Specifies whether automated sensitive data discovery is enabled automatically for accounts in the
         *        organization. Possible values are: ALL, enable it for all existing accounts and new member accounts;
         *        NEW, enable it only for new member accounts; and, NONE, don't enable it for any accounts.
         * @see AutoEnableMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoEnableMode
         */
        Builder autoEnableOrganizationMembers(AutoEnableMode autoEnableOrganizationMembers);

        /**
         * <p>
         * The unique identifier for the classification scope that's used when performing automated sensitive data
         * discovery. The classification scope specifies S3 buckets to exclude from analyses.
         * </p>
         * 
         * @param classificationScopeId
         *        The unique identifier for the classification scope that's used when performing automated sensitive
         *        data discovery. The classification scope specifies S3 buckets to exclude from analyses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classificationScopeId(String classificationScopeId);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when automated sensitive data discovery was most
         * recently disabled. This value is null if automated sensitive data discovery is currently enabled.
         * </p>
         * 
         * @param disabledAt
         *        The date and time, in UTC and extended ISO 8601 format, when automated sensitive data discovery was
         *        most recently disabled. This value is null if automated sensitive data discovery is currently enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledAt(Instant disabledAt);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when automated sensitive data discovery was initially
         * enabled. This value is null if automated sensitive data discovery has never been enabled.
         * </p>
         * 
         * @param firstEnabledAt
         *        The date and time, in UTC and extended ISO 8601 format, when automated sensitive data discovery was
         *        initially enabled. This value is null if automated sensitive data discovery has never been enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstEnabledAt(Instant firstEnabledAt);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the configuration settings or status of
         * automated sensitive data discovery was most recently changed.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time, in UTC and extended ISO 8601 format, when the configuration settings or status of
         *        automated sensitive data discovery was most recently changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The unique identifier for the sensitivity inspection template that's used when performing automated sensitive
         * data discovery. The template specifies which allow lists, custom data identifiers, and managed data
         * identifiers to use when analyzing data.
         * </p>
         * 
         * @param sensitivityInspectionTemplateId
         *        The unique identifier for the sensitivity inspection template that's used when performing automated
         *        sensitive data discovery. The template specifies which allow lists, custom data identifiers, and
         *        managed data identifiers to use when analyzing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitivityInspectionTemplateId(String sensitivityInspectionTemplateId);

        /**
         * <p>
         * The current status of automated sensitive data discovery for the organization or account. Possible values
         * are: ENABLED, use the specified settings to perform automated sensitive data discovery activities; and,
         * DISABLED, don't perform automated sensitive data discovery activities.
         * </p>
         * 
         * @param status
         *        The current status of automated sensitive data discovery for the organization or account. Possible
         *        values are: ENABLED, use the specified settings to perform automated sensitive data discovery
         *        activities; and, DISABLED, don't perform automated sensitive data discovery activities.
         * @see AutomatedDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedDiscoveryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of automated sensitive data discovery for the organization or account. Possible values
         * are: ENABLED, use the specified settings to perform automated sensitive data discovery activities; and,
         * DISABLED, don't perform automated sensitive data discovery activities.
         * </p>
         * 
         * @param status
         *        The current status of automated sensitive data discovery for the organization or account. Possible
         *        values are: ENABLED, use the specified settings to perform automated sensitive data discovery
         *        activities; and, DISABLED, don't perform automated sensitive data discovery activities.
         * @see AutomatedDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedDiscoveryStatus
         */
        Builder status(AutomatedDiscoveryStatus status);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String autoEnableOrganizationMembers;

        private String classificationScopeId;

        private Instant disabledAt;

        private Instant firstEnabledAt;

        private Instant lastUpdatedAt;

        private String sensitivityInspectionTemplateId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutomatedDiscoveryConfigurationResponse model) {
            super(model);
            autoEnableOrganizationMembers(model.autoEnableOrganizationMembers);
            classificationScopeId(model.classificationScopeId);
            disabledAt(model.disabledAt);
            firstEnabledAt(model.firstEnabledAt);
            lastUpdatedAt(model.lastUpdatedAt);
            sensitivityInspectionTemplateId(model.sensitivityInspectionTemplateId);
            status(model.status);
        }

        public final String getAutoEnableOrganizationMembers() {
            return autoEnableOrganizationMembers;
        }

        public final void setAutoEnableOrganizationMembers(String autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers = autoEnableOrganizationMembers;
        }

        @Override
        public final Builder autoEnableOrganizationMembers(String autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers = autoEnableOrganizationMembers;
            return this;
        }

        @Override
        public final Builder autoEnableOrganizationMembers(AutoEnableMode autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers(autoEnableOrganizationMembers == null ? null : autoEnableOrganizationMembers
                    .toString());
            return this;
        }

        public final String getClassificationScopeId() {
            return classificationScopeId;
        }

        public final void setClassificationScopeId(String classificationScopeId) {
            this.classificationScopeId = classificationScopeId;
        }

        @Override
        public final Builder classificationScopeId(String classificationScopeId) {
            this.classificationScopeId = classificationScopeId;
            return this;
        }

        public final Instant getDisabledAt() {
            return disabledAt;
        }

        public final void setDisabledAt(Instant disabledAt) {
            this.disabledAt = disabledAt;
        }

        @Override
        public final Builder disabledAt(Instant disabledAt) {
            this.disabledAt = disabledAt;
            return this;
        }

        public final Instant getFirstEnabledAt() {
            return firstEnabledAt;
        }

        public final void setFirstEnabledAt(Instant firstEnabledAt) {
            this.firstEnabledAt = firstEnabledAt;
        }

        @Override
        public final Builder firstEnabledAt(Instant firstEnabledAt) {
            this.firstEnabledAt = firstEnabledAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getSensitivityInspectionTemplateId() {
            return sensitivityInspectionTemplateId;
        }

        public final void setSensitivityInspectionTemplateId(String sensitivityInspectionTemplateId) {
            this.sensitivityInspectionTemplateId = sensitivityInspectionTemplateId;
        }

        @Override
        public final Builder sensitivityInspectionTemplateId(String sensitivityInspectionTemplateId) {
            this.sensitivityInspectionTemplateId = sensitivityInspectionTemplateId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutomatedDiscoveryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetAutomatedDiscoveryConfigurationResponse build() {
            return new GetAutomatedDiscoveryConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
