/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a current quota for an Amazon Macie account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLimit implements SdkPojo, Serializable, ToCopyableBuilder<ServiceLimit.Builder, ServiceLimit> {
    private static final SdkField<Boolean> IS_SERVICE_LIMITED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isServiceLimited").getter(getter(ServiceLimit::isServiceLimited))
            .setter(setter(Builder::isServiceLimited))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isServiceLimited").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(ServiceLimit::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<Long> VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("value")
            .getter(getter(ServiceLimit::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_SERVICE_LIMITED_FIELD,
            UNIT_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("isServiceLimited", IS_SERVICE_LIMITED_FIELD);
                    put("unit", UNIT_FIELD);
                    put("value", VALUE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Boolean isServiceLimited;

    private final String unit;

    private final Long value;

    private ServiceLimit(BuilderImpl builder) {
        this.isServiceLimited = builder.isServiceLimited;
        this.unit = builder.unit;
        this.value = builder.value;
    }

    /**
     * <p>
     * Specifies whether the account has met the quota that corresponds to the metric specified by the
     * UsageByAccount.type field in the response.
     * </p>
     * 
     * @return Specifies whether the account has met the quota that corresponds to the metric specified by the
     *         UsageByAccount.type field in the response.
     */
    public final Boolean isServiceLimited() {
        return isServiceLimited;
    }

    /**
     * <p>
     * The unit of measurement for the value specified by the value field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link Unit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of measurement for the value specified by the value field.
     * @see Unit
     */
    public final Unit unit() {
        return Unit.fromValue(unit);
    }

    /**
     * <p>
     * The unit of measurement for the value specified by the value field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link Unit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of measurement for the value specified by the value field.
     * @see Unit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * The value for the metric specified by the UsageByAccount.type field in the response.
     * </p>
     * 
     * @return The value for the metric specified by the UsageByAccount.type field in the response.
     */
    public final Long value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isServiceLimited());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLimit)) {
            return false;
        }
        ServiceLimit other = (ServiceLimit) obj;
        return Objects.equals(isServiceLimited(), other.isServiceLimited())
                && Objects.equals(unitAsString(), other.unitAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceLimit").add("IsServiceLimited", isServiceLimited()).add("Unit", unitAsString())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isServiceLimited":
            return Optional.ofNullable(clazz.cast(isServiceLimited()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLimit, T> g) {
        return obj -> g.apply((ServiceLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLimit> {
        /**
         * <p>
         * Specifies whether the account has met the quota that corresponds to the metric specified by the
         * UsageByAccount.type field in the response.
         * </p>
         * 
         * @param isServiceLimited
         *        Specifies whether the account has met the quota that corresponds to the metric specified by the
         *        UsageByAccount.type field in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isServiceLimited(Boolean isServiceLimited);

        /**
         * <p>
         * The unit of measurement for the value specified by the value field.
         * </p>
         * 
         * @param unit
         *        The unit of measurement for the value specified by the value field.
         * @see Unit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Unit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit of measurement for the value specified by the value field.
         * </p>
         * 
         * @param unit
         *        The unit of measurement for the value specified by the value field.
         * @see Unit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Unit
         */
        Builder unit(Unit unit);

        /**
         * <p>
         * The value for the metric specified by the UsageByAccount.type field in the response.
         * </p>
         * 
         * @param value
         *        The value for the metric specified by the UsageByAccount.type field in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Long value);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isServiceLimited;

        private String unit;

        private Long value;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLimit model) {
            isServiceLimited(model.isServiceLimited);
            unit(model.unit);
            value(model.value);
        }

        public final Boolean getIsServiceLimited() {
            return isServiceLimited;
        }

        public final void setIsServiceLimited(Boolean isServiceLimited) {
            this.isServiceLimited = isServiceLimited;
        }

        @Override
        public final Builder isServiceLimited(Boolean isServiceLimited) {
            this.isServiceLimited = isServiceLimited;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(Unit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Long getValue() {
            return value;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        @Override
        public ServiceLimit build() {
            return new ServiceLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
