/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a tag-based condition that determines whether an S3 bucket is included or excluded from a classification
 * job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagCriterionForJob implements SdkPojo, Serializable,
        ToCopyableBuilder<TagCriterionForJob.Builder, TagCriterionForJob> {
    private static final SdkField<String> COMPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("comparator").getter(getter(TagCriterionForJob::comparatorAsString)).setter(setter(Builder::comparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparator").build()).build();

    private static final SdkField<List<TagCriterionPairForJob>> TAG_VALUES_FIELD = SdkField
            .<List<TagCriterionPairForJob>> builder(MarshallingType.LIST)
            .memberName("tagValues")
            .getter(getter(TagCriterionForJob::tagValues))
            .setter(setter(Builder::tagValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagCriterionPairForJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagCriterionPairForJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARATOR_FIELD,
            TAG_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("comparator", COMPARATOR_FIELD);
                    put("tagValues", TAG_VALUES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String comparator;

    private final List<TagCriterionPairForJob> tagValues;

    private TagCriterionForJob(BuilderImpl builder) {
        this.comparator = builder.comparator;
        this.tagValues = builder.tagValues;
    }

    /**
     * <p>
     * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparator} will
     * return {@link JobComparator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #comparatorAsString}.
     * </p>
     * 
     * @return The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
     * @see JobComparator
     */
    public final JobComparator comparator() {
        return JobComparator.fromValue(comparator);
    }

    /**
     * <p>
     * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparator} will
     * return {@link JobComparator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #comparatorAsString}.
     * </p>
     * 
     * @return The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
     * @see JobComparator
     */
    public final String comparatorAsString() {
        return comparator;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagValues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagValues() {
        return tagValues != null && !(tagValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys, tag values, or tag key and value pairs to use in the condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagValues} method.
     * </p>
     * 
     * @return The tag keys, tag values, or tag key and value pairs to use in the condition.
     */
    public final List<TagCriterionPairForJob> tagValues() {
        return tagValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagValues() ? tagValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagCriterionForJob)) {
            return false;
        }
        TagCriterionForJob other = (TagCriterionForJob) obj;
        return Objects.equals(comparatorAsString(), other.comparatorAsString()) && hasTagValues() == other.hasTagValues()
                && Objects.equals(tagValues(), other.tagValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TagCriterionForJob").add("Comparator", comparatorAsString())
                .add("TagValues", hasTagValues() ? tagValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comparator":
            return Optional.ofNullable(clazz.cast(comparatorAsString()));
        case "tagValues":
            return Optional.ofNullable(clazz.cast(tagValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TagCriterionForJob, T> g) {
        return obj -> g.apply((TagCriterionForJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagCriterionForJob> {
        /**
         * <p>
         * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
         * </p>
         * 
         * @param comparator
         *        The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
         * @see JobComparator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobComparator
         */
        Builder comparator(String comparator);

        /**
         * <p>
         * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
         * </p>
         * 
         * @param comparator
         *        The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
         * @see JobComparator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobComparator
         */
        Builder comparator(JobComparator comparator);

        /**
         * <p>
         * The tag keys, tag values, or tag key and value pairs to use in the condition.
         * </p>
         * 
         * @param tagValues
         *        The tag keys, tag values, or tag key and value pairs to use in the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(Collection<TagCriterionPairForJob> tagValues);

        /**
         * <p>
         * The tag keys, tag values, or tag key and value pairs to use in the condition.
         * </p>
         * 
         * @param tagValues
         *        The tag keys, tag values, or tag key and value pairs to use in the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(TagCriterionPairForJob... tagValues);

        /**
         * <p>
         * The tag keys, tag values, or tag key and value pairs to use in the condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob.Builder#build()} is called
         * immediately and its result is passed to {@link #tagValues(List<TagCriterionPairForJob>)}.
         * 
         * @param tagValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.TagCriterionPairForJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagValues(java.util.Collection<TagCriterionPairForJob>)
         */
        Builder tagValues(Consumer<TagCriterionPairForJob.Builder>... tagValues);
    }

    static final class BuilderImpl implements Builder {
        private String comparator;

        private List<TagCriterionPairForJob> tagValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagCriterionForJob model) {
            comparator(model.comparator);
            tagValues(model.tagValues);
        }

        public final String getComparator() {
            return comparator;
        }

        public final void setComparator(String comparator) {
            this.comparator = comparator;
        }

        @Override
        public final Builder comparator(String comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        public final Builder comparator(JobComparator comparator) {
            this.comparator(comparator == null ? null : comparator.toString());
            return this;
        }

        public final List<TagCriterionPairForJob.Builder> getTagValues() {
            List<TagCriterionPairForJob.Builder> result = ___listOfTagCriterionPairForJobCopier.copyToBuilder(this.tagValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagValues(Collection<TagCriterionPairForJob.BuilderImpl> tagValues) {
            this.tagValues = ___listOfTagCriterionPairForJobCopier.copyFromBuilder(tagValues);
        }

        @Override
        public final Builder tagValues(Collection<TagCriterionPairForJob> tagValues) {
            this.tagValues = ___listOfTagCriterionPairForJobCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(TagCriterionPairForJob... tagValues) {
            tagValues(Arrays.asList(tagValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(Consumer<TagCriterionPairForJob.Builder>... tagValues) {
            tagValues(Stream.of(tagValues).map(c -> TagCriterionPairForJob.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TagCriterionForJob build() {
            return new TagCriterionForJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
