/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptInvitationRequest extends Macie2Request implements
        ToCopyableBuilder<AcceptInvitationRequest.Builder, AcceptInvitationRequest> {
    private static final SdkField<String> ADMINISTRATOR_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("administratorAccountId").getter(getter(AcceptInvitationRequest::administratorAccountId))
            .setter(setter(Builder::administratorAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("administratorAccountId").build())
            .build();

    private static final SdkField<String> INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invitationId").getter(getter(AcceptInvitationRequest::invitationId))
            .setter(setter(Builder::invitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitationId").build()).build();

    private static final SdkField<String> MASTER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("masterAccount").getter(getter(AcceptInvitationRequest::masterAccount))
            .setter(setter(Builder::masterAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterAccount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADMINISTRATOR_ACCOUNT_ID_FIELD, INVITATION_ID_FIELD, MASTER_ACCOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String administratorAccountId;

    private final String invitationId;

    private final String masterAccount;

    private AcceptInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.administratorAccountId = builder.administratorAccountId;
        this.invitationId = builder.invitationId;
        this.masterAccount = builder.masterAccount;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for the account that sent the invitation.
     * </p>
     * 
     * @return The Amazon Web Services account ID for the account that sent the invitation.
     */
    public final String administratorAccountId() {
        return administratorAccountId;
    }

    /**
     * <p>
     * The unique identifier for the invitation to accept.
     * </p>
     * 
     * @return The unique identifier for the invitation to accept.
     */
    public final String invitationId() {
        return invitationId;
    }

    /**
     * <p>
     * (Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has been
     * replaced by the administratorAccountId property and is retained only for backward compatibility.
     * </p>
     * 
     * @return (Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property
     *         has been replaced by the administratorAccountId property and is retained only for backward compatibility.
     */
    public final String masterAccount() {
        return masterAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(administratorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(invitationId());
        hashCode = 31 * hashCode + Objects.hashCode(masterAccount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptInvitationRequest)) {
            return false;
        }
        AcceptInvitationRequest other = (AcceptInvitationRequest) obj;
        return Objects.equals(administratorAccountId(), other.administratorAccountId())
                && Objects.equals(invitationId(), other.invitationId()) && Objects.equals(masterAccount(), other.masterAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptInvitationRequest").add("AdministratorAccountId", administratorAccountId())
                .add("InvitationId", invitationId()).add("MasterAccount", masterAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "administratorAccountId":
            return Optional.ofNullable(clazz.cast(administratorAccountId()));
        case "invitationId":
            return Optional.ofNullable(clazz.cast(invitationId()));
        case "masterAccount":
            return Optional.ofNullable(clazz.cast(masterAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("administratorAccountId", ADMINISTRATOR_ACCOUNT_ID_FIELD);
        map.put("invitationId", INVITATION_ID_FIELD);
        map.put("masterAccount", MASTER_ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptInvitationRequest, T> g) {
        return obj -> g.apply((AcceptInvitationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, AcceptInvitationRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID for the account that sent the invitation.
         * </p>
         * 
         * @param administratorAccountId
         *        The Amazon Web Services account ID for the account that sent the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administratorAccountId(String administratorAccountId);

        /**
         * <p>
         * The unique identifier for the invitation to accept.
         * </p>
         * 
         * @param invitationId
         *        The unique identifier for the invitation to accept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitationId(String invitationId);

        /**
         * <p>
         * (Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has
         * been replaced by the administratorAccountId property and is retained only for backward compatibility.
         * </p>
         * 
         * @param masterAccount
         *        (Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This
         *        property has been replaced by the administratorAccountId property and is retained only for backward
         *        compatibility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterAccount(String masterAccount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String administratorAccountId;

        private String invitationId;

        private String masterAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptInvitationRequest model) {
            super(model);
            administratorAccountId(model.administratorAccountId);
            invitationId(model.invitationId);
            masterAccount(model.masterAccount);
        }

        public final String getAdministratorAccountId() {
            return administratorAccountId;
        }

        public final void setAdministratorAccountId(String administratorAccountId) {
            this.administratorAccountId = administratorAccountId;
        }

        @Override
        public final Builder administratorAccountId(String administratorAccountId) {
            this.administratorAccountId = administratorAccountId;
            return this;
        }

        public final String getInvitationId() {
            return invitationId;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        public final String getMasterAccount() {
            return masterAccount;
        }

        public final void setMasterAccount(String masterAccount) {
            this.masterAccount = masterAccount;
        }

        @Override
        public final Builder masterAccount(String masterAccount) {
            this.masterAccount = masterAccount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptInvitationRequest build() {
            return new AcceptInvitationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
