/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a managed data identifier. For additional information, see <a
 * href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data identifiers</a>
 * in the <i>Amazon Macie User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedDataIdentifierSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedDataIdentifierSummary.Builder, ManagedDataIdentifierSummary> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(ManagedDataIdentifierSummary::categoryAsString))
            .setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ManagedDataIdentifierSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String category;

    private final String id;

    private ManagedDataIdentifierSummary(BuilderImpl builder) {
        this.category = builder.category;
        this.id = builder.id;
    }

    /**
     * <p>
     * The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials data such
     * as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data such as
     * credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance
     * identification numbers, or personally identifiable information, such as passport numbers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link SensitiveDataItemCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials
     *         data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial
     *         data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as
     *         health insurance identification numbers, or personally identifiable information, such as passport
     *         numbers.
     * @see SensitiveDataItemCategory
     */
    public final SensitiveDataItemCategory category() {
        return SensitiveDataItemCategory.fromValue(category);
    }

    /**
     * <p>
     * The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials data such
     * as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data such as
     * credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance
     * identification numbers, or personally identifiable information, such as passport numbers.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link SensitiveDataItemCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials
     *         data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial
     *         data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as
     *         health insurance identification numbers, or personally identifiable information, such as passport
     *         numbers.
     * @see SensitiveDataItemCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The unique identifier for the managed data identifier. This is a string that describes the type of sensitive data
     * that the managed data identifier detects. For example: OPENSSH_PRIVATE_KEY for OpenSSH private keys,
     * CREDIT_CARD_NUMBER for credit card numbers, or USA_PASSPORT_NUMBER for US passport numbers.
     * </p>
     * 
     * @return The unique identifier for the managed data identifier. This is a string that describes the type of
     *         sensitive data that the managed data identifier detects. For example: OPENSSH_PRIVATE_KEY for OpenSSH
     *         private keys, CREDIT_CARD_NUMBER for credit card numbers, or USA_PASSPORT_NUMBER for US passport numbers.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedDataIdentifierSummary)) {
            return false;
        }
        ManagedDataIdentifierSummary other = (ManagedDataIdentifierSummary) obj;
        return Objects.equals(categoryAsString(), other.categoryAsString()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedDataIdentifierSummary").add("Category", categoryAsString()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("category", CATEGORY_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedDataIdentifierSummary, T> g) {
        return obj -> g.apply((ManagedDataIdentifierSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedDataIdentifierSummary> {
        /**
         * <p>
         * The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials data
         * such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data
         * such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health
         * insurance identification numbers, or personally identifiable information, such as passport numbers.
         * </p>
         * 
         * @param category
         *        The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials
         *        data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for
         *        financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information,
         *        such as health insurance identification numbers, or personally identifiable information, such as
         *        passport numbers.
         * @see SensitiveDataItemCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SensitiveDataItemCategory
         */
        Builder category(String category);

        /**
         * <p>
         * The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials data
         * such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data
         * such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health
         * insurance identification numbers, or personally identifiable information, such as passport numbers.
         * </p>
         * 
         * @param category
         *        The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials
         *        data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for
         *        financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information,
         *        such as health insurance identification numbers, or personally identifiable information, such as
         *        passport numbers.
         * @see SensitiveDataItemCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SensitiveDataItemCategory
         */
        Builder category(SensitiveDataItemCategory category);

        /**
         * <p>
         * The unique identifier for the managed data identifier. This is a string that describes the type of sensitive
         * data that the managed data identifier detects. For example: OPENSSH_PRIVATE_KEY for OpenSSH private keys,
         * CREDIT_CARD_NUMBER for credit card numbers, or USA_PASSPORT_NUMBER for US passport numbers.
         * </p>
         * 
         * @param id
         *        The unique identifier for the managed data identifier. This is a string that describes the type of
         *        sensitive data that the managed data identifier detects. For example: OPENSSH_PRIVATE_KEY for OpenSSH
         *        private keys, CREDIT_CARD_NUMBER for credit card numbers, or USA_PASSPORT_NUMBER for US passport
         *        numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private String category;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedDataIdentifierSummary model) {
            category(model.category);
            id(model.id);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(SensitiveDataItemCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public ManagedDataIdentifierSummary build() {
            return new ManagedDataIdentifierSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
