/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides geographic coordinates that indicate where a specified IP address originated from.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpGeoLocation implements SdkPojo, Serializable, ToCopyableBuilder<IpGeoLocation.Builder, IpGeoLocation> {
    private static final SdkField<Double> LAT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("lat")
            .getter(getter(IpGeoLocation::lat)).setter(setter(Builder::lat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lat").build()).build();

    private static final SdkField<Double> LON_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("lon")
            .getter(getter(IpGeoLocation::lon)).setter(setter(Builder::lon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lon").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAT_FIELD, LON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double lat;

    private final Double lon;

    private IpGeoLocation(BuilderImpl builder) {
        this.lat = builder.lat;
        this.lon = builder.lon;
    }

    /**
     * <p>
     * The latitude coordinate of the location, rounded to four decimal places.
     * </p>
     * 
     * @return The latitude coordinate of the location, rounded to four decimal places.
     */
    public final Double lat() {
        return lat;
    }

    /**
     * <p>
     * The longitude coordinate of the location, rounded to four decimal places.
     * </p>
     * 
     * @return The longitude coordinate of the location, rounded to four decimal places.
     */
    public final Double lon() {
        return lon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lat());
        hashCode = 31 * hashCode + Objects.hashCode(lon());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpGeoLocation)) {
            return false;
        }
        IpGeoLocation other = (IpGeoLocation) obj;
        return Objects.equals(lat(), other.lat()) && Objects.equals(lon(), other.lon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpGeoLocation").add("Lat", lat()).add("Lon", lon()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lat":
            return Optional.ofNullable(clazz.cast(lat()));
        case "lon":
            return Optional.ofNullable(clazz.cast(lon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lat", LAT_FIELD);
        map.put("lon", LON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpGeoLocation, T> g) {
        return obj -> g.apply((IpGeoLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpGeoLocation> {
        /**
         * <p>
         * The latitude coordinate of the location, rounded to four decimal places.
         * </p>
         * 
         * @param lat
         *        The latitude coordinate of the location, rounded to four decimal places.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lat(Double lat);

        /**
         * <p>
         * The longitude coordinate of the location, rounded to four decimal places.
         * </p>
         * 
         * @param lon
         *        The longitude coordinate of the location, rounded to four decimal places.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lon(Double lon);
    }

    static final class BuilderImpl implements Builder {
        private Double lat;

        private Double lon;

        private BuilderImpl() {
        }

        private BuilderImpl(IpGeoLocation model) {
            lat(model.lat);
            lon(model.lon);
        }

        public final Double getLat() {
            return lat;
        }

        public final void setLat(Double lat) {
            this.lat = lat;
        }

        @Override
        public final Builder lat(Double lat) {
            this.lat = lat;
            return this;
        }

        public final Double getLon() {
            return lon;
        }

        public final void setLon(Double lon) {
            this.lon = lon;
        }

        @Override
        public final Builder lon(Double lon) {
            this.lon = lon;
            return this;
        }

        @Override
        public IpGeoLocation build() {
            return new IpGeoLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
