/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies criteria for sorting the results of a query for information about S3 buckets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketSortCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketSortCriteria.Builder, BucketSortCriteria> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeName").getter(getter(BucketSortCriteria::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeName").build()).build();

    private static final SdkField<String> ORDER_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("orderBy").getter(getter(BucketSortCriteria::orderByAsString)).setter(setter(Builder::orderBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            ORDER_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String orderBy;

    private BucketSortCriteria(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.orderBy = builder.orderBy;
    }

    /**
     * <p>
     * The name of the bucket property to sort the results by. This value can be one of the following properties that
     * Amazon Macie defines as bucket metadata: accountId, bucketName, classifiableObjectCount, classifiableSizeInBytes,
     * objectCount, sensitivityScore, or sizeInBytes.
     * </p>
     * 
     * @return The name of the bucket property to sort the results by. This value can be one of the following properties
     *         that Amazon Macie defines as bucket metadata: accountId, bucketName, classifiableObjectCount,
     *         classifiableSizeInBytes, objectCount, sensitivityScore, or sizeInBytes.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The sort order to apply to the results, based on the value specified by the attributeName property. Valid values
     * are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderBy} will
     * return {@link OrderBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByAsString}.
     * </p>
     * 
     * @return The sort order to apply to the results, based on the value specified by the attributeName property. Valid
     *         values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
     * @see OrderBy
     */
    public final OrderBy orderBy() {
        return OrderBy.fromValue(orderBy);
    }

    /**
     * <p>
     * The sort order to apply to the results, based on the value specified by the attributeName property. Valid values
     * are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #orderBy} will
     * return {@link OrderBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderByAsString}.
     * </p>
     * 
     * @return The sort order to apply to the results, based on the value specified by the attributeName property. Valid
     *         values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
     * @see OrderBy
     */
    public final String orderByAsString() {
        return orderBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(orderByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketSortCriteria)) {
            return false;
        }
        BucketSortCriteria other = (BucketSortCriteria) obj;
        return Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(orderByAsString(), other.orderByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketSortCriteria").add("AttributeName", attributeName()).add("OrderBy", orderByAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "orderBy":
            return Optional.ofNullable(clazz.cast(orderByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attributeName", ATTRIBUTE_NAME_FIELD);
        map.put("orderBy", ORDER_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BucketSortCriteria, T> g) {
        return obj -> g.apply((BucketSortCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketSortCriteria> {
        /**
         * <p>
         * The name of the bucket property to sort the results by. This value can be one of the following properties
         * that Amazon Macie defines as bucket metadata: accountId, bucketName, classifiableObjectCount,
         * classifiableSizeInBytes, objectCount, sensitivityScore, or sizeInBytes.
         * </p>
         * 
         * @param attributeName
         *        The name of the bucket property to sort the results by. This value can be one of the following
         *        properties that Amazon Macie defines as bucket metadata: accountId, bucketName,
         *        classifiableObjectCount, classifiableSizeInBytes, objectCount, sensitivityScore, or sizeInBytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The sort order to apply to the results, based on the value specified by the attributeName property. Valid
         * values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
         * </p>
         * 
         * @param orderBy
         *        The sort order to apply to the results, based on the value specified by the attributeName property.
         *        Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending
         *        order.
         * @see OrderBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderBy
         */
        Builder orderBy(String orderBy);

        /**
         * <p>
         * The sort order to apply to the results, based on the value specified by the attributeName property. Valid
         * values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.
         * </p>
         * 
         * @param orderBy
         *        The sort order to apply to the results, based on the value specified by the attributeName property.
         *        Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending
         *        order.
         * @see OrderBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderBy
         */
        Builder orderBy(OrderBy orderBy);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String orderBy;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketSortCriteria model) {
            attributeName(model.attributeName);
            orderBy(model.orderBy);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getOrderBy() {
            return orderBy;
        }

        public final void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public final Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public final Builder orderBy(OrderBy orderBy) {
            this.orderBy(orderBy == null ? null : orderBy.toString());
            return this;
        }

        @Override
        public BucketSortCriteria build() {
            return new BucketSortCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
