/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the registered owner of an IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpOwner implements SdkPojo, Serializable, ToCopyableBuilder<IpOwner.Builder, IpOwner> {
    private static final SdkField<String> ASN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("asn")
            .getter(getter(IpOwner::asn)).setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()).build();

    private static final SdkField<String> ASN_ORG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("asnOrg")
            .getter(getter(IpOwner::asnOrg)).setter(setter(Builder::asnOrg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asnOrg").build()).build();

    private static final SdkField<String> ISP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("isp")
            .getter(getter(IpOwner::isp)).setter(setter(Builder::isp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isp").build()).build();

    private static final SdkField<String> ORG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("org")
            .getter(getter(IpOwner::org)).setter(setter(Builder::org))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("org").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASN_FIELD, ASN_ORG_FIELD,
            ISP_FIELD, ORG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String asn;

    private final String asnOrg;

    private final String isp;

    private final String org;

    private IpOwner(BuilderImpl builder) {
        this.asn = builder.asn;
        this.asnOrg = builder.asnOrg;
        this.isp = builder.isp;
        this.org = builder.org;
    }

    /**
     * <p>
     * The autonomous system number (ASN) for the autonomous system that included the IP address.
     * </p>
     * 
     * @return The autonomous system number (ASN) for the autonomous system that included the IP address.
     */
    public final String asn() {
        return asn;
    }

    /**
     * <p>
     * The organization identifier that's associated with the autonomous system number (ASN) for the autonomous system
     * that included the IP address.
     * </p>
     * 
     * @return The organization identifier that's associated with the autonomous system number (ASN) for the autonomous
     *         system that included the IP address.
     */
    public final String asnOrg() {
        return asnOrg;
    }

    /**
     * <p>
     * The name of the internet service provider (ISP) that owned the IP address.
     * </p>
     * 
     * @return The name of the internet service provider (ISP) that owned the IP address.
     */
    public final String isp() {
        return isp;
    }

    /**
     * <p>
     * The name of the organization that owned the IP address.
     * </p>
     * 
     * @return The name of the organization that owned the IP address.
     */
    public final String org() {
        return org;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(asnOrg());
        hashCode = 31 * hashCode + Objects.hashCode(isp());
        hashCode = 31 * hashCode + Objects.hashCode(org());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpOwner)) {
            return false;
        }
        IpOwner other = (IpOwner) obj;
        return Objects.equals(asn(), other.asn()) && Objects.equals(asnOrg(), other.asnOrg())
                && Objects.equals(isp(), other.isp()) && Objects.equals(org(), other.org());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpOwner").add("Asn", asn()).add("AsnOrg", asnOrg()).add("Isp", isp()).add("Org", org()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "asnOrg":
            return Optional.ofNullable(clazz.cast(asnOrg()));
        case "isp":
            return Optional.ofNullable(clazz.cast(isp()));
        case "org":
            return Optional.ofNullable(clazz.cast(org()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("asn", ASN_FIELD);
        map.put("asnOrg", ASN_ORG_FIELD);
        map.put("isp", ISP_FIELD);
        map.put("org", ORG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpOwner, T> g) {
        return obj -> g.apply((IpOwner) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpOwner> {
        /**
         * <p>
         * The autonomous system number (ASN) for the autonomous system that included the IP address.
         * </p>
         * 
         * @param asn
         *        The autonomous system number (ASN) for the autonomous system that included the IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(String asn);

        /**
         * <p>
         * The organization identifier that's associated with the autonomous system number (ASN) for the autonomous
         * system that included the IP address.
         * </p>
         * 
         * @param asnOrg
         *        The organization identifier that's associated with the autonomous system number (ASN) for the
         *        autonomous system that included the IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asnOrg(String asnOrg);

        /**
         * <p>
         * The name of the internet service provider (ISP) that owned the IP address.
         * </p>
         * 
         * @param isp
         *        The name of the internet service provider (ISP) that owned the IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isp(String isp);

        /**
         * <p>
         * The name of the organization that owned the IP address.
         * </p>
         * 
         * @param org
         *        The name of the organization that owned the IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder org(String org);
    }

    static final class BuilderImpl implements Builder {
        private String asn;

        private String asnOrg;

        private String isp;

        private String org;

        private BuilderImpl() {
        }

        private BuilderImpl(IpOwner model) {
            asn(model.asn);
            asnOrg(model.asnOrg);
            isp(model.isp);
            org(model.org);
        }

        public final String getAsn() {
            return asn;
        }

        public final void setAsn(String asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(String asn) {
            this.asn = asn;
            return this;
        }

        public final String getAsnOrg() {
            return asnOrg;
        }

        public final void setAsnOrg(String asnOrg) {
            this.asnOrg = asnOrg;
        }

        @Override
        public final Builder asnOrg(String asnOrg) {
            this.asnOrg = asnOrg;
            return this;
        }

        public final String getIsp() {
            return isp;
        }

        public final void setIsp(String isp) {
            this.isp = isp;
        }

        @Override
        public final Builder isp(String isp) {
            this.isp = isp;
            return this;
        }

        public final String getOrg() {
            return org;
        }

        public final void setOrg(String org) {
            this.org = org;
        }

        @Override
        public final Builder org(String org) {
            this.org = org;
            return this;
        }

        @Override
        public IpOwner build() {
            return new IpOwner(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
