/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateAutomatedDiscoveryAccountsRequest extends Macie2Request implements
        ToCopyableBuilder<BatchUpdateAutomatedDiscoveryAccountsRequest.Builder, BatchUpdateAutomatedDiscoveryAccountsRequest> {
    private static final SdkField<List<AutomatedDiscoveryAccountUpdate>> ACCOUNTS_FIELD = SdkField
            .<List<AutomatedDiscoveryAccountUpdate>> builder(MarshallingType.LIST)
            .memberName("accounts")
            .getter(getter(BatchUpdateAutomatedDiscoveryAccountsRequest::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedDiscoveryAccountUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedDiscoveryAccountUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AutomatedDiscoveryAccountUpdate> accounts;

    private BatchUpdateAutomatedDiscoveryAccountsRequest(BuilderImpl builder) {
        super(builder);
        this.accounts = builder.accounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each account to change the status of automated sensitive data discovery for. Each
     * object specifies the Amazon Web Services account ID for an account and a new status for that account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccounts} method.
     * </p>
     * 
     * @return An array of objects, one for each account to change the status of automated sensitive data discovery for.
     *         Each object specifies the Amazon Web Services account ID for an account and a new status for that
     *         account.
     */
    public final List<AutomatedDiscoveryAccountUpdate> accounts() {
        return accounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateAutomatedDiscoveryAccountsRequest)) {
            return false;
        }
        BatchUpdateAutomatedDiscoveryAccountsRequest other = (BatchUpdateAutomatedDiscoveryAccountsRequest) obj;
        return hasAccounts() == other.hasAccounts() && Objects.equals(accounts(), other.accounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateAutomatedDiscoveryAccountsRequest")
                .add("Accounts", hasAccounts() ? accounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accounts", ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateAutomatedDiscoveryAccountsRequest, T> g) {
        return obj -> g.apply((BatchUpdateAutomatedDiscoveryAccountsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateAutomatedDiscoveryAccountsRequest> {
        /**
         * <p>
         * An array of objects, one for each account to change the status of automated sensitive data discovery for.
         * Each object specifies the Amazon Web Services account ID for an account and a new status for that account.
         * </p>
         * 
         * @param accounts
         *        An array of objects, one for each account to change the status of automated sensitive data discovery
         *        for. Each object specifies the Amazon Web Services account ID for an account and a new status for that
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<AutomatedDiscoveryAccountUpdate> accounts);

        /**
         * <p>
         * An array of objects, one for each account to change the status of automated sensitive data discovery for.
         * Each object specifies the Amazon Web Services account ID for an account and a new status for that account.
         * </p>
         * 
         * @param accounts
         *        An array of objects, one for each account to change the status of automated sensitive data discovery
         *        for. Each object specifies the Amazon Web Services account ID for an account and a new status for that
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(AutomatedDiscoveryAccountUpdate... accounts);

        /**
         * <p>
         * An array of objects, one for each account to change the status of automated sensitive data discovery for.
         * Each object specifies the Amazon Web Services account ID for an account and a new status for that account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdate.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdate.Builder#build()} is
         * called immediately and its result is passed to {@link #accounts(List<AutomatedDiscoveryAccountUpdate>)}.
         * 
         * @param accounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.AutomatedDiscoveryAccountUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accounts(java.util.Collection<AutomatedDiscoveryAccountUpdate>)
         */
        Builder accounts(Consumer<AutomatedDiscoveryAccountUpdate.Builder>... accounts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private List<AutomatedDiscoveryAccountUpdate> accounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateAutomatedDiscoveryAccountsRequest model) {
            super(model);
            accounts(model.accounts);
        }

        public final List<AutomatedDiscoveryAccountUpdate.Builder> getAccounts() {
            List<AutomatedDiscoveryAccountUpdate.Builder> result = ___listOfAutomatedDiscoveryAccountUpdateCopier
                    .copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<AutomatedDiscoveryAccountUpdate.BuilderImpl> accounts) {
            this.accounts = ___listOfAutomatedDiscoveryAccountUpdateCopier.copyFromBuilder(accounts);
        }

        @Override
        public final Builder accounts(Collection<AutomatedDiscoveryAccountUpdate> accounts) {
            this.accounts = ___listOfAutomatedDiscoveryAccountUpdateCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(AutomatedDiscoveryAccountUpdate... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<AutomatedDiscoveryAccountUpdate.Builder>... accounts) {
            accounts(Stream.of(accounts).map(c -> AutomatedDiscoveryAccountUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateAutomatedDiscoveryAccountsRequest build() {
            return new BatchUpdateAutomatedDiscoveryAccountsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
