/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClassificationScopesResponse extends Macie2Response implements
        ToCopyableBuilder<ListClassificationScopesResponse.Builder, ListClassificationScopesResponse> {
    private static final SdkField<List<ClassificationScopeSummary>> CLASSIFICATION_SCOPES_FIELD = SdkField
            .<List<ClassificationScopeSummary>> builder(MarshallingType.LIST)
            .memberName("classificationScopes")
            .getter(getter(ListClassificationScopesResponse::classificationScopes))
            .setter(setter(Builder::classificationScopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classificationScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClassificationScopeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClassificationScopeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListClassificationScopesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIFICATION_SCOPES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ClassificationScopeSummary> classificationScopes;

    private final String nextToken;

    private ListClassificationScopesResponse(BuilderImpl builder) {
        super(builder);
        this.classificationScopes = builder.classificationScopes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClassificationScopes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClassificationScopes() {
        return classificationScopes != null && !(classificationScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that specifies the unique identifier and name of the classification scope for the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClassificationScopes} method.
     * </p>
     * 
     * @return An array that specifies the unique identifier and name of the classification scope for the account.
     */
    public final List<ClassificationScopeSummary> classificationScopes() {
        return classificationScopes;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null if there are no additional pages.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null if there are no additional pages.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClassificationScopes() ? classificationScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClassificationScopesResponse)) {
            return false;
        }
        ListClassificationScopesResponse other = (ListClassificationScopesResponse) obj;
        return hasClassificationScopes() == other.hasClassificationScopes()
                && Objects.equals(classificationScopes(), other.classificationScopes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClassificationScopesResponse")
                .add("ClassificationScopes", hasClassificationScopes() ? classificationScopes() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "classificationScopes":
            return Optional.ofNullable(clazz.cast(classificationScopes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("classificationScopes", CLASSIFICATION_SCOPES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClassificationScopesResponse, T> g) {
        return obj -> g.apply((ListClassificationScopesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListClassificationScopesResponse> {
        /**
         * <p>
         * An array that specifies the unique identifier and name of the classification scope for the account.
         * </p>
         * 
         * @param classificationScopes
         *        An array that specifies the unique identifier and name of the classification scope for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classificationScopes(Collection<ClassificationScopeSummary> classificationScopes);

        /**
         * <p>
         * An array that specifies the unique identifier and name of the classification scope for the account.
         * </p>
         * 
         * @param classificationScopes
         *        An array that specifies the unique identifier and name of the classification scope for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classificationScopes(ClassificationScopeSummary... classificationScopes);

        /**
         * <p>
         * An array that specifies the unique identifier and name of the classification scope for the account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.ClassificationScopeSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.macie2.model.ClassificationScopeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.ClassificationScopeSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #classificationScopes(List<ClassificationScopeSummary>)}.
         * 
         * @param classificationScopes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.ClassificationScopeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classificationScopes(java.util.Collection<ClassificationScopeSummary>)
         */
        Builder classificationScopes(Consumer<ClassificationScopeSummary.Builder>... classificationScopes);

        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null if there are no additional pages.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null if there are no additional pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private List<ClassificationScopeSummary> classificationScopes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClassificationScopesResponse model) {
            super(model);
            classificationScopes(model.classificationScopes);
            nextToken(model.nextToken);
        }

        public final List<ClassificationScopeSummary.Builder> getClassificationScopes() {
            List<ClassificationScopeSummary.Builder> result = ___listOfClassificationScopeSummaryCopier
                    .copyToBuilder(this.classificationScopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClassificationScopes(Collection<ClassificationScopeSummary.BuilderImpl> classificationScopes) {
            this.classificationScopes = ___listOfClassificationScopeSummaryCopier.copyFromBuilder(classificationScopes);
        }

        @Override
        public final Builder classificationScopes(Collection<ClassificationScopeSummary> classificationScopes) {
            this.classificationScopes = ___listOfClassificationScopeSummaryCopier.copy(classificationScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classificationScopes(ClassificationScopeSummary... classificationScopes) {
            classificationScopes(Arrays.asList(classificationScopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classificationScopes(Consumer<ClassificationScopeSummary.Builder>... classificationScopes) {
            classificationScopes(Stream.of(classificationScopes)
                    .map(c -> ClassificationScopeSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClassificationScopesResponse build() {
            return new ListClassificationScopesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
