/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies changes to the list of S3 buckets that are excluded from automated sensitive data discovery for an Amazon
 * Macie account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ClassificationScopeUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ClassificationScopeUpdate.Builder, S3ClassificationScopeUpdate> {
    private static final SdkField<S3ClassificationScopeExclusionUpdate> EXCLUDES_FIELD = SdkField
            .<S3ClassificationScopeExclusionUpdate> builder(MarshallingType.SDK_POJO).memberName("excludes")
            .getter(getter(S3ClassificationScopeUpdate::excludes)).setter(setter(Builder::excludes))
            .constructor(S3ClassificationScopeExclusionUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3ClassificationScopeExclusionUpdate excludes;

    private S3ClassificationScopeUpdate(BuilderImpl builder) {
        this.excludes = builder.excludes;
    }

    /**
     * <p>
     * The names of the S3 buckets to add or remove from the list.
     * </p>
     * 
     * @return The names of the S3 buckets to add or remove from the list.
     */
    public final S3ClassificationScopeExclusionUpdate excludes() {
        return excludes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(excludes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ClassificationScopeUpdate)) {
            return false;
        }
        S3ClassificationScopeUpdate other = (S3ClassificationScopeUpdate) obj;
        return Objects.equals(excludes(), other.excludes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ClassificationScopeUpdate").add("Excludes", excludes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("excludes", EXCLUDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ClassificationScopeUpdate, T> g) {
        return obj -> g.apply((S3ClassificationScopeUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ClassificationScopeUpdate> {
        /**
         * <p>
         * The names of the S3 buckets to add or remove from the list.
         * </p>
         * 
         * @param excludes
         *        The names of the S3 buckets to add or remove from the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(S3ClassificationScopeExclusionUpdate excludes);

        /**
         * <p>
         * The names of the S3 buckets to add or remove from the list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link S3ClassificationScopeExclusionUpdate.Builder} avoiding the need to create one manually via
         * {@link S3ClassificationScopeExclusionUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ClassificationScopeExclusionUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #excludes(S3ClassificationScopeExclusionUpdate)}.
         * 
         * @param excludes
         *        a consumer that will call methods on {@link S3ClassificationScopeExclusionUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(S3ClassificationScopeExclusionUpdate)
         */
        default Builder excludes(Consumer<S3ClassificationScopeExclusionUpdate.Builder> excludes) {
            return excludes(S3ClassificationScopeExclusionUpdate.builder().applyMutation(excludes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3ClassificationScopeExclusionUpdate excludes;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ClassificationScopeUpdate model) {
            excludes(model.excludes);
        }

        public final S3ClassificationScopeExclusionUpdate.Builder getExcludes() {
            return excludes != null ? excludes.toBuilder() : null;
        }

        public final void setExcludes(S3ClassificationScopeExclusionUpdate.BuilderImpl excludes) {
            this.excludes = excludes != null ? excludes.build() : null;
        }

        @Override
        public final Builder excludes(S3ClassificationScopeExclusionUpdate excludes) {
            this.excludes = excludes;
            return this;
        }

        @Override
        public S3ClassificationScopeUpdate build() {
            return new S3ClassificationScopeUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
