/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides quota and aggregated usage data for an Amazon Macie account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageRecord implements SdkPojo, Serializable, ToCopyableBuilder<UsageRecord.Builder, UsageRecord> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(UsageRecord::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Instant> AUTOMATED_DISCOVERY_FREE_TRIAL_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("automatedDiscoveryFreeTrialStartDate")
            .getter(getter(UsageRecord::automatedDiscoveryFreeTrialStartDate))
            .setter(setter(Builder::automatedDiscoveryFreeTrialStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("automatedDiscoveryFreeTrialStartDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> FREE_TRIAL_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("freeTrialStartDate")
            .getter(getter(UsageRecord::freeTrialStartDate))
            .setter(setter(Builder::freeTrialStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTrialStartDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<UsageByAccount>> USAGE_FIELD = SdkField
            .<List<UsageByAccount>> builder(MarshallingType.LIST)
            .memberName("usage")
            .getter(getter(UsageRecord::usage))
            .setter(setter(Builder::usage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageByAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageByAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            AUTOMATED_DISCOVERY_FREE_TRIAL_START_DATE_FIELD, FREE_TRIAL_START_DATE_FIELD, USAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Instant automatedDiscoveryFreeTrialStartDate;

    private final Instant freeTrialStartDate;

    private final List<UsageByAccount> usage;

    private UsageRecord(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.automatedDiscoveryFreeTrialStartDate = builder.automatedDiscoveryFreeTrialStartDate;
        this.freeTrialStartDate = builder.freeTrialStartDate;
        this.usage = builder.usage;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Web Services account that the data applies to.
     * </p>
     * 
     * @return The unique identifier for the Amazon Web Services account that the data applies to.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the free trial of automated sensitive data discovery
     * started for the account. This value is null if automated sensitive data discovery hasn't been enabled for the
     * account.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the free trial of automated sensitive data
     *         discovery started for the account. This value is null if automated sensitive data discovery hasn't been
     *         enabled for the account.
     */
    public final Instant automatedDiscoveryFreeTrialStartDate() {
        return automatedDiscoveryFreeTrialStartDate;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie free trial started for the account.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie free trial started for the
     *         account.
     */
    public final Instant freeTrialStartDate() {
        return freeTrialStartDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Usage property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsage() {
        return usage != null && !(usage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that contains usage data and quotas for the account. Each object contains the data for a
     * specific usage metric and the corresponding quota.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsage} method.
     * </p>
     * 
     * @return An array of objects that contains usage data and quotas for the account. Each object contains the data
     *         for a specific usage metric and the corresponding quota.
     */
    public final List<UsageByAccount> usage() {
        return usage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(automatedDiscoveryFreeTrialStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(freeTrialStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsage() ? usage() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageRecord)) {
            return false;
        }
        UsageRecord other = (UsageRecord) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(automatedDiscoveryFreeTrialStartDate(), other.automatedDiscoveryFreeTrialStartDate())
                && Objects.equals(freeTrialStartDate(), other.freeTrialStartDate()) && hasUsage() == other.hasUsage()
                && Objects.equals(usage(), other.usage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageRecord").add("AccountId", accountId())
                .add("AutomatedDiscoveryFreeTrialStartDate", automatedDiscoveryFreeTrialStartDate())
                .add("FreeTrialStartDate", freeTrialStartDate()).add("Usage", hasUsage() ? usage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "automatedDiscoveryFreeTrialStartDate":
            return Optional.ofNullable(clazz.cast(automatedDiscoveryFreeTrialStartDate()));
        case "freeTrialStartDate":
            return Optional.ofNullable(clazz.cast(freeTrialStartDate()));
        case "usage":
            return Optional.ofNullable(clazz.cast(usage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("automatedDiscoveryFreeTrialStartDate", AUTOMATED_DISCOVERY_FREE_TRIAL_START_DATE_FIELD);
        map.put("freeTrialStartDate", FREE_TRIAL_START_DATE_FIELD);
        map.put("usage", USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageRecord, T> g) {
        return obj -> g.apply((UsageRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageRecord> {
        /**
         * <p>
         * The unique identifier for the Amazon Web Services account that the data applies to.
         * </p>
         * 
         * @param accountId
         *        The unique identifier for the Amazon Web Services account that the data applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the free trial of automated sensitive data
         * discovery started for the account. This value is null if automated sensitive data discovery hasn't been
         * enabled for the account.
         * </p>
         * 
         * @param automatedDiscoveryFreeTrialStartDate
         *        The date and time, in UTC and extended ISO 8601 format, when the free trial of automated sensitive
         *        data discovery started for the account. This value is null if automated sensitive data discovery
         *        hasn't been enabled for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedDiscoveryFreeTrialStartDate(Instant automatedDiscoveryFreeTrialStartDate);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie free trial started for the
         * account.
         * </p>
         * 
         * @param freeTrialStartDate
         *        The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie free trial started for
         *        the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeTrialStartDate(Instant freeTrialStartDate);

        /**
         * <p>
         * An array of objects that contains usage data and quotas for the account. Each object contains the data for a
         * specific usage metric and the corresponding quota.
         * </p>
         * 
         * @param usage
         *        An array of objects that contains usage data and quotas for the account. Each object contains the data
         *        for a specific usage metric and the corresponding quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(Collection<UsageByAccount> usage);

        /**
         * <p>
         * An array of objects that contains usage data and quotas for the account. Each object contains the data for a
         * specific usage metric and the corresponding quota.
         * </p>
         * 
         * @param usage
         *        An array of objects that contains usage data and quotas for the account. Each object contains the data
         *        for a specific usage metric and the corresponding quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(UsageByAccount... usage);

        /**
         * <p>
         * An array of objects that contains usage data and quotas for the account. Each object contains the data for a
         * specific usage metric and the corresponding quota.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.UsageByAccount.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.macie2.model.UsageByAccount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.UsageByAccount.Builder#build()} is called immediately and
         * its result is passed to {@link #usage(List<UsageByAccount>)}.
         * 
         * @param usage
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.UsageByAccount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usage(java.util.Collection<UsageByAccount>)
         */
        Builder usage(Consumer<UsageByAccount.Builder>... usage);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Instant automatedDiscoveryFreeTrialStartDate;

        private Instant freeTrialStartDate;

        private List<UsageByAccount> usage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageRecord model) {
            accountId(model.accountId);
            automatedDiscoveryFreeTrialStartDate(model.automatedDiscoveryFreeTrialStartDate);
            freeTrialStartDate(model.freeTrialStartDate);
            usage(model.usage);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Instant getAutomatedDiscoveryFreeTrialStartDate() {
            return automatedDiscoveryFreeTrialStartDate;
        }

        public final void setAutomatedDiscoveryFreeTrialStartDate(Instant automatedDiscoveryFreeTrialStartDate) {
            this.automatedDiscoveryFreeTrialStartDate = automatedDiscoveryFreeTrialStartDate;
        }

        @Override
        public final Builder automatedDiscoveryFreeTrialStartDate(Instant automatedDiscoveryFreeTrialStartDate) {
            this.automatedDiscoveryFreeTrialStartDate = automatedDiscoveryFreeTrialStartDate;
            return this;
        }

        public final Instant getFreeTrialStartDate() {
            return freeTrialStartDate;
        }

        public final void setFreeTrialStartDate(Instant freeTrialStartDate) {
            this.freeTrialStartDate = freeTrialStartDate;
        }

        @Override
        public final Builder freeTrialStartDate(Instant freeTrialStartDate) {
            this.freeTrialStartDate = freeTrialStartDate;
            return this;
        }

        public final List<UsageByAccount.Builder> getUsage() {
            List<UsageByAccount.Builder> result = ___listOfUsageByAccountCopier.copyToBuilder(this.usage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsage(Collection<UsageByAccount.BuilderImpl> usage) {
            this.usage = ___listOfUsageByAccountCopier.copyFromBuilder(usage);
        }

        @Override
        public final Builder usage(Collection<UsageByAccount> usage) {
            this.usage = ___listOfUsageByAccountCopier.copy(usage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(UsageByAccount... usage) {
            usage(Arrays.asList(usage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(Consumer<UsageByAccount.Builder>... usage) {
            usage(Stream.of(usage).map(c -> UsageByAccount.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UsageRecord build() {
            return new UsageRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
