/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an API operation that an entity invoked for an affected resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApiCallDetails implements SdkPojo, Serializable, ToCopyableBuilder<ApiCallDetails.Builder, ApiCallDetails> {
    private static final SdkField<String> API_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("api")
            .getter(getter(ApiCallDetails::api)).setter(setter(Builder::api))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("api").build()).build();

    private static final SdkField<String> API_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiServiceName").getter(getter(ApiCallDetails::apiServiceName)).setter(setter(Builder::apiServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiServiceName").build()).build();

    private static final SdkField<Instant> FIRST_SEEN_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstSeen")
            .getter(getter(ApiCallDetails::firstSeen))
            .setter(setter(Builder::firstSeen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstSeen").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_SEEN_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastSeen")
            .getter(getter(ApiCallDetails::lastSeen))
            .setter(setter(Builder::lastSeen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeen").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_FIELD,
            API_SERVICE_NAME_FIELD, FIRST_SEEN_FIELD, LAST_SEEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String api;

    private final String apiServiceName;

    private final Instant firstSeen;

    private final Instant lastSeen;

    private ApiCallDetails(BuilderImpl builder) {
        this.api = builder.api;
        this.apiServiceName = builder.apiServiceName;
        this.firstSeen = builder.firstSeen;
        this.lastSeen = builder.lastSeen;
    }

    /**
     * <p>
     * The name of the operation that was invoked most recently and produced the finding.
     * </p>
     * 
     * @return The name of the operation that was invoked most recently and produced the finding.
     */
    public final String api() {
        return api;
    }

    /**
     * <p>
     * The URL of the Amazon Web Services service that provides the operation, for example: s3.amazonaws.com.
     * </p>
     * 
     * @return The URL of the Amazon Web Services service that provides the operation, for example: s3.amazonaws.com.
     */
    public final String apiServiceName() {
        return apiServiceName;
    }

    /**
     * <p>
     * The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced the
     * finding.
     * </p>
     * 
     * @return The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced
     *         the finding.
     */
    public final Instant firstSeen() {
        return firstSeen;
    }

    /**
     * <p>
     * The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api) was
     * invoked and produced the finding.
     * </p>
     * 
     * @return The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api)
     *         was invoked and produced the finding.
     */
    public final Instant lastSeen() {
        return lastSeen;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(api());
        hashCode = 31 * hashCode + Objects.hashCode(apiServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(firstSeen());
        hashCode = 31 * hashCode + Objects.hashCode(lastSeen());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiCallDetails)) {
            return false;
        }
        ApiCallDetails other = (ApiCallDetails) obj;
        return Objects.equals(api(), other.api()) && Objects.equals(apiServiceName(), other.apiServiceName())
                && Objects.equals(firstSeen(), other.firstSeen()) && Objects.equals(lastSeen(), other.lastSeen());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApiCallDetails").add("Api", api()).add("ApiServiceName", apiServiceName())
                .add("FirstSeen", firstSeen()).add("LastSeen", lastSeen()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "api":
            return Optional.ofNullable(clazz.cast(api()));
        case "apiServiceName":
            return Optional.ofNullable(clazz.cast(apiServiceName()));
        case "firstSeen":
            return Optional.ofNullable(clazz.cast(firstSeen()));
        case "lastSeen":
            return Optional.ofNullable(clazz.cast(lastSeen()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("api", API_FIELD);
        map.put("apiServiceName", API_SERVICE_NAME_FIELD);
        map.put("firstSeen", FIRST_SEEN_FIELD);
        map.put("lastSeen", LAST_SEEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiCallDetails, T> g) {
        return obj -> g.apply((ApiCallDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApiCallDetails> {
        /**
         * <p>
         * The name of the operation that was invoked most recently and produced the finding.
         * </p>
         * 
         * @param api
         *        The name of the operation that was invoked most recently and produced the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder api(String api);

        /**
         * <p>
         * The URL of the Amazon Web Services service that provides the operation, for example: s3.amazonaws.com.
         * </p>
         * 
         * @param apiServiceName
         *        The URL of the Amazon Web Services service that provides the operation, for example: s3.amazonaws.com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiServiceName(String apiServiceName);

        /**
         * <p>
         * The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced the
         * finding.
         * </p>
         * 
         * @param firstSeen
         *        The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and
         *        produced the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSeen(Instant firstSeen);

        /**
         * <p>
         * The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api) was
         * invoked and produced the finding.
         * </p>
         * 
         * @param lastSeen
         *        The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api)
         *        was invoked and produced the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSeen(Instant lastSeen);
    }

    static final class BuilderImpl implements Builder {
        private String api;

        private String apiServiceName;

        private Instant firstSeen;

        private Instant lastSeen;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiCallDetails model) {
            api(model.api);
            apiServiceName(model.apiServiceName);
            firstSeen(model.firstSeen);
            lastSeen(model.lastSeen);
        }

        public final String getApi() {
            return api;
        }

        public final void setApi(String api) {
            this.api = api;
        }

        @Override
        public final Builder api(String api) {
            this.api = api;
            return this;
        }

        public final String getApiServiceName() {
            return apiServiceName;
        }

        public final void setApiServiceName(String apiServiceName) {
            this.apiServiceName = apiServiceName;
        }

        @Override
        public final Builder apiServiceName(String apiServiceName) {
            this.apiServiceName = apiServiceName;
            return this;
        }

        public final Instant getFirstSeen() {
            return firstSeen;
        }

        public final void setFirstSeen(Instant firstSeen) {
            this.firstSeen = firstSeen;
        }

        @Override
        public final Builder firstSeen(Instant firstSeen) {
            this.firstSeen = firstSeen;
            return this;
        }

        public final Instant getLastSeen() {
            return lastSeen;
        }

        public final void setLastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
        }

        @Override
        public final Builder lastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        @Override
        public ApiCallDetails build() {
            return new ApiCallDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
