/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Unit {
    TERABYTES("TERABYTES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Unit> VALUE_MAP;
    private final String value;

    private Unit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Unit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Unit> knownValues() {
        EnumSet<Unit> knownValues = EnumSet.allOf(Unit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Unit.class, Unit::toString);
    }
}

