/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.DefaultDetection;
import software.amazon.awssdk.services.macie2.model.DefaultDetectionsCopier;
import software.amazon.awssdk.services.macie2.model.SensitiveDataItemCategory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SensitiveDataItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SensitiveDataItem> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(SensitiveDataItem.getter(SensitiveDataItem::categoryAsString)).setter(SensitiveDataItem.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<List<DefaultDetection>> DETECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("detections").getter(SensitiveDataItem.getter(SensitiveDataItem::detections)).setter(SensitiveDataItem.setter(Builder::detections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DefaultDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalCount").getter(SensitiveDataItem.getter(SensitiveDataItem::totalCount)).setter(SensitiveDataItem.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, DETECTIONS_FIELD, TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SensitiveDataItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String category;
    private final List<DefaultDetection> detections;
    private final Long totalCount;

    private SensitiveDataItem(BuilderImpl builder) {
        this.category = builder.category;
        this.detections = builder.detections;
        this.totalCount = builder.totalCount;
    }

    public final SensitiveDataItemCategory category() {
        return SensitiveDataItemCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final boolean hasDetections() {
        return this.detections != null && !(this.detections instanceof SdkAutoConstructList);
    }

    public final List<DefaultDetection> detections() {
        return this.detections;
    }

    public final Long totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetections() ? this.detections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SensitiveDataItem)) {
            return false;
        }
        SensitiveDataItem other = (SensitiveDataItem)obj;
        return Objects.equals(this.categoryAsString(), other.categoryAsString()) && this.hasDetections() == other.hasDetections() && Objects.equals(this.detections(), other.detections()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SensitiveDataItem").add("Category", (Object)this.categoryAsString()).add("Detections", this.hasDetections() ? this.detections() : null).add("TotalCount", (Object)this.totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "detections": {
                return Optional.ofNullable(clazz.cast(this.detections()));
            }
            case "totalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("category", CATEGORY_FIELD);
        map.put("detections", DETECTIONS_FIELD);
        map.put("totalCount", TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SensitiveDataItem, T> g) {
        return obj -> g.apply((SensitiveDataItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private List<DefaultDetection> detections = DefaultSdkAutoConstructList.getInstance();
        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SensitiveDataItem model) {
            this.category(model.category);
            this.detections(model.detections);
            this.totalCount(model.totalCount);
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(SensitiveDataItemCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final List<DefaultDetection.Builder> getDetections() {
            List<DefaultDetection.Builder> result = DefaultDetectionsCopier.copyToBuilder(this.detections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetections(Collection<DefaultDetection.BuilderImpl> detections) {
            this.detections = DefaultDetectionsCopier.copyFromBuilder(detections);
        }

        @Override
        public final Builder detections(Collection<DefaultDetection> detections) {
            this.detections = DefaultDetectionsCopier.copy(detections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(DefaultDetection ... detections) {
            this.detections(Arrays.asList(detections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(Consumer<DefaultDetection.Builder> ... detections) {
            this.detections(Stream.of(detections).map(c -> (DefaultDetection)((DefaultDetection.Builder)DefaultDetection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public SensitiveDataItem build() {
            return new SensitiveDataItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SensitiveDataItem> {
        public Builder category(String var1);

        public Builder category(SensitiveDataItemCategory var1);

        public Builder detections(Collection<DefaultDetection> var1);

        public Builder detections(DefaultDetection ... var1);

        public Builder detections(Consumer<DefaultDetection.Builder> ... var1);

        public Builder totalCount(Long var1);
    }
}

