/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.SessionContextAttributes;
import software.amazon.awssdk.services.macie2.model.SessionIssuer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionContext> {
    private static final SdkField<SessionContextAttributes> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attributes").getter(SessionContext.getter(SessionContext::attributes)).setter(SessionContext.setter(Builder::attributes)).constructor(SessionContextAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build()}).build();
    private static final SdkField<SessionIssuer> SESSION_ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionIssuer").getter(SessionContext.getter(SessionContext::sessionIssuer)).setter(SessionContext.setter(Builder::sessionIssuer)).constructor(SessionIssuer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionIssuer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, SESSION_ISSUER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SessionContext.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SessionContextAttributes attributes;
    private final SessionIssuer sessionIssuer;

    private SessionContext(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.sessionIssuer = builder.sessionIssuer;
    }

    public final SessionContextAttributes attributes() {
        return this.attributes;
    }

    public final SessionIssuer sessionIssuer() {
        return this.sessionIssuer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionIssuer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionContext)) {
            return false;
        }
        SessionContext other = (SessionContext)obj;
        return Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.sessionIssuer(), other.sessionIssuer());
    }

    public final String toString() {
        return ToString.builder((String)"SessionContext").add("Attributes", (Object)this.attributes()).add("SessionIssuer", (Object)this.sessionIssuer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "sessionIssuer": {
                return Optional.ofNullable(clazz.cast(this.sessionIssuer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("sessionIssuer", SESSION_ISSUER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionContext, T> g) {
        return obj -> g.apply((SessionContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SessionContextAttributes attributes;
        private SessionIssuer sessionIssuer;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionContext model) {
            this.attributes(model.attributes);
            this.sessionIssuer(model.sessionIssuer);
        }

        public final SessionContextAttributes.Builder getAttributes() {
            return this.attributes != null ? this.attributes.toBuilder() : null;
        }

        public final void setAttributes(SessionContextAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(SessionContextAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final SessionIssuer.Builder getSessionIssuer() {
            return this.sessionIssuer != null ? this.sessionIssuer.toBuilder() : null;
        }

        public final void setSessionIssuer(SessionIssuer.BuilderImpl sessionIssuer) {
            this.sessionIssuer = sessionIssuer != null ? sessionIssuer.build() : null;
        }

        @Override
        public final Builder sessionIssuer(SessionIssuer sessionIssuer) {
            this.sessionIssuer = sessionIssuer;
            return this;
        }

        public SessionContext build() {
            return new SessionContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionContext> {
        public Builder attributes(SessionContextAttributes var1);

        default public Builder attributes(Consumer<SessionContextAttributes.Builder> attributes) {
            return this.attributes((SessionContextAttributes)((SessionContextAttributes.Builder)SessionContextAttributes.builder().applyMutation(attributes)).build());
        }

        public Builder sessionIssuer(SessionIssuer var1);

        default public Builder sessionIssuer(Consumer<SessionIssuer.Builder> sessionIssuer) {
            return this.sessionIssuer((SessionIssuer)((SessionIssuer.Builder)SessionIssuer.builder().applyMutation(sessionIssuer)).build());
        }
    }
}

