/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure for a boolean condition matching on the incoming mail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngressBooleanExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<IngressBooleanExpression.Builder, IngressBooleanExpression> {
    private static final SdkField<IngressBooleanToEvaluate> EVALUATE_FIELD = SdkField
            .<IngressBooleanToEvaluate> builder(MarshallingType.SDK_POJO).memberName("Evaluate")
            .getter(getter(IngressBooleanExpression::evaluate)).setter(setter(Builder::evaluate))
            .constructor(IngressBooleanToEvaluate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluate").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(IngressBooleanExpression::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EVALUATE_FIELD, OPERATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final IngressBooleanToEvaluate evaluate;

    private final String operator;

    private IngressBooleanExpression(BuilderImpl builder) {
        this.evaluate = builder.evaluate;
        this.operator = builder.operator;
    }

    /**
     * <p>
     * The operand on which to perform a boolean condition operation.
     * </p>
     * 
     * @return The operand on which to perform a boolean condition operation.
     */
    public final IngressBooleanToEvaluate evaluate() {
        return evaluate;
    }

    /**
     * <p>
     * The matching operator for a boolean condition expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link IngressBooleanOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return The matching operator for a boolean condition expression.
     * @see IngressBooleanOperator
     */
    public final IngressBooleanOperator operator() {
        return IngressBooleanOperator.fromValue(operator);
    }

    /**
     * <p>
     * The matching operator for a boolean condition expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link IngressBooleanOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatorAsString}.
     * </p>
     * 
     * @return The matching operator for a boolean condition expression.
     * @see IngressBooleanOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluate());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressBooleanExpression)) {
            return false;
        }
        IngressBooleanExpression other = (IngressBooleanExpression) obj;
        return Objects.equals(evaluate(), other.evaluate()) && Objects.equals(operatorAsString(), other.operatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngressBooleanExpression").add("Evaluate", evaluate()).add("Operator", operatorAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Evaluate":
            return Optional.ofNullable(clazz.cast(evaluate()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngressBooleanExpression, T> g) {
        return obj -> g.apply((IngressBooleanExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngressBooleanExpression> {
        /**
         * <p>
         * The operand on which to perform a boolean condition operation.
         * </p>
         * 
         * @param evaluate
         *        The operand on which to perform a boolean condition operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluate(IngressBooleanToEvaluate evaluate);

        /**
         * <p>
         * The operand on which to perform a boolean condition operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressBooleanToEvaluate.Builder}
         * avoiding the need to create one manually via {@link IngressBooleanToEvaluate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressBooleanToEvaluate.Builder#build()} is called immediately
         * and its result is passed to {@link #evaluate(IngressBooleanToEvaluate)}.
         * 
         * @param evaluate
         *        a consumer that will call methods on {@link IngressBooleanToEvaluate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluate(IngressBooleanToEvaluate)
         */
        default Builder evaluate(Consumer<IngressBooleanToEvaluate.Builder> evaluate) {
            return evaluate(IngressBooleanToEvaluate.builder().applyMutation(evaluate).build());
        }

        /**
         * <p>
         * The matching operator for a boolean condition expression.
         * </p>
         * 
         * @param operator
         *        The matching operator for a boolean condition expression.
         * @see IngressBooleanOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressBooleanOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The matching operator for a boolean condition expression.
         * </p>
         * 
         * @param operator
         *        The matching operator for a boolean condition expression.
         * @see IngressBooleanOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressBooleanOperator
         */
        Builder operator(IngressBooleanOperator operator);
    }

    static final class BuilderImpl implements Builder {
        private IngressBooleanToEvaluate evaluate;

        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressBooleanExpression model) {
            evaluate(model.evaluate);
            operator(model.operator);
        }

        public final IngressBooleanToEvaluate.Builder getEvaluate() {
            return evaluate != null ? evaluate.toBuilder() : null;
        }

        public final void setEvaluate(IngressBooleanToEvaluate.BuilderImpl evaluate) {
            this.evaluate = evaluate != null ? evaluate.build() : null;
        }

        @Override
        public final Builder evaluate(IngressBooleanToEvaluate evaluate) {
            this.evaluate = evaluate;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(IngressBooleanOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        @Override
        public IngressBooleanExpression build() {
            return new IngressBooleanExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
