/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum RuleNumberOperator {
    EQUALS("EQUALS"),

    NOT_EQUALS("NOT_EQUALS"),

    LESS_THAN("LESS_THAN"),

    GREATER_THAN("GREATER_THAN"),

    LESS_THAN_OR_EQUAL("LESS_THAN_OR_EQUAL"),

    GREATER_THAN_OR_EQUAL("GREATER_THAN_OR_EQUAL"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleNumberOperator> VALUE_MAP = EnumUtils.uniqueIndex(RuleNumberOperator.class,
            RuleNumberOperator::toString);

    private final String value;

    private RuleNumberOperator(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return RuleNumberOperator corresponding to the value
     */
    public static RuleNumberOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link RuleNumberOperator}s
     */
    public static Set<RuleNumberOperator> knownValues() {
        Set<RuleNumberOperator> knownValues = EnumSet.allOf(RuleNumberOperator.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
