/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRuleSetRequest extends MailManagerRequest implements
        ToCopyableBuilder<UpdateRuleSetRequest.Builder, UpdateRuleSetRequest> {
    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetId").getter(getter(UpdateRuleSetRequest::ruleSetId)).setter(setter(Builder::ruleSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()).build();

    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetName").getter(getter(UpdateRuleSetRequest::ruleSetName)).setter(setter(Builder::ruleSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()).build();

    private static final SdkField<List<Rule>> RULES_FIELD = SdkField
            .<List<Rule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(UpdateRuleSetRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Rule> builder(MarshallingType.SDK_POJO)
                                            .constructor(Rule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SET_ID_FIELD,
            RULE_SET_NAME_FIELD, RULES_FIELD));

    private final String ruleSetId;

    private final String ruleSetName;

    private final List<Rule> rules;

    private UpdateRuleSetRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetId = builder.ruleSetId;
        this.ruleSetName = builder.ruleSetName;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The identifier of a rule set you want to update.
     * </p>
     * 
     * @return The identifier of a rule set you want to update.
     */
    public final String ruleSetId() {
        return ruleSetId;
    }

    /**
     * <p>
     * A user-friendly name for the rule set resource.
     * </p>
     * 
     * @return A user-friendly name for the rule set resource.
     */
    public final String ruleSetName() {
        return ruleSetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A new set of rules to replace the current rules of the rule set—these rules will override all the rules of the
     * rule set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return A new set of rules to replace the current rules of the rule set—these rules will override all the rules
     *         of the rule set.
     */
    public final List<Rule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleSetRequest)) {
            return false;
        }
        UpdateRuleSetRequest other = (UpdateRuleSetRequest) obj;
        return Objects.equals(ruleSetId(), other.ruleSetId()) && Objects.equals(ruleSetName(), other.ruleSetName())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRuleSetRequest").add("RuleSetId", ruleSetId()).add("RuleSetName", ruleSetName())
                .add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSetId":
            return Optional.ofNullable(clazz.cast(ruleSetId()));
        case "RuleSetName":
            return Optional.ofNullable(clazz.cast(ruleSetName()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRuleSetRequest, T> g) {
        return obj -> g.apply((UpdateRuleSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRuleSetRequest> {
        /**
         * <p>
         * The identifier of a rule set you want to update.
         * </p>
         * 
         * @param ruleSetId
         *        The identifier of a rule set you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetId(String ruleSetId);

        /**
         * <p>
         * A user-friendly name for the rule set resource.
         * </p>
         * 
         * @param ruleSetName
         *        A user-friendly name for the rule set resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        /**
         * <p>
         * A new set of rules to replace the current rules of the rule set—these rules will override all the rules of
         * the rule set.
         * </p>
         * 
         * @param rules
         *        A new set of rules to replace the current rules of the rule set—these rules will override all the
         *        rules of the rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * A new set of rules to replace the current rules of the rule set—these rules will override all the rules of
         * the rule set.
         * </p>
         * 
         * @param rules
         *        A new set of rules to replace the current rules of the rule set—these rules will override all the
         *        rules of the rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);

        /**
         * <p>
         * A new set of rules to replace the current rules of the rule set—these rules will override all the rules of
         * the rule set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.Rule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mailmanager.model.Rule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.Rule.Builder#build()} is called immediately and its
         * result is passed to {@link #rules(List<Rule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.Rule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<Rule>)
         */
        Builder rules(Consumer<Rule.Builder>... rules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MailManagerRequest.BuilderImpl implements Builder {
        private String ruleSetId;

        private String ruleSetName;

        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRuleSetRequest model) {
            super(model);
            ruleSetId(model.ruleSetId);
            ruleSetName(model.ruleSetName);
            rules(model.rules);
        }

        public final String getRuleSetId() {
            return ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RulesCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> Rule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRuleSetRequest build() {
            return new UpdateRuleSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
