/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response containing details of the requested archive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetArchiveResponse extends MailManagerResponse implements
        ToCopyableBuilder<GetArchiveResponse.Builder, GetArchiveResponse> {
    private static final SdkField<String> ARCHIVE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveArn").getter(getter(GetArchiveResponse::archiveArn)).setter(setter(Builder::archiveArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveArn").build()).build();

    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveId").getter(getter(GetArchiveResponse::archiveId)).setter(setter(Builder::archiveId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()).build();

    private static final SdkField<String> ARCHIVE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveName").getter(getter(GetArchiveResponse::archiveName)).setter(setter(Builder::archiveName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveName").build()).build();

    private static final SdkField<String> ARCHIVE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveState").getter(getter(GetArchiveResponse::archiveStateAsString))
            .setter(setter(Builder::archiveState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveState").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(GetArchiveResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(GetArchiveResponse::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(GetArchiveResponse::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<ArchiveRetention> RETENTION_FIELD = SdkField
            .<ArchiveRetention> builder(MarshallingType.SDK_POJO).memberName("Retention")
            .getter(getter(GetArchiveResponse::retention)).setter(setter(Builder::retention))
            .constructor(ArchiveRetention::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retention").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ARN_FIELD,
            ARCHIVE_ID_FIELD, ARCHIVE_NAME_FIELD, ARCHIVE_STATE_FIELD, CREATED_TIMESTAMP_FIELD, KMS_KEY_ARN_FIELD,
            LAST_UPDATED_TIMESTAMP_FIELD, RETENTION_FIELD));

    private final String archiveArn;

    private final String archiveId;

    private final String archiveName;

    private final String archiveState;

    private final Instant createdTimestamp;

    private final String kmsKeyArn;

    private final Instant lastUpdatedTimestamp;

    private final ArchiveRetention retention;

    private GetArchiveResponse(BuilderImpl builder) {
        super(builder);
        this.archiveArn = builder.archiveArn;
        this.archiveId = builder.archiveId;
        this.archiveName = builder.archiveName;
        this.archiveState = builder.archiveState;
        this.createdTimestamp = builder.createdTimestamp;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.retention = builder.retention;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the archive.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the archive.
     */
    public final String archiveArn() {
        return archiveArn;
    }

    /**
     * <p>
     * The unique identifier of the archive.
     * </p>
     * 
     * @return The unique identifier of the archive.
     */
    public final String archiveId() {
        return archiveId;
    }

    /**
     * <p>
     * The unique name assigned to the archive.
     * </p>
     * 
     * @return The unique name assigned to the archive.
     */
    public final String archiveName() {
        return archiveName;
    }

    /**
     * <p>
     * The current state of the archive:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The archive is ready and available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in 30
     * days. No further modifications can be made in this state.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #archiveState} will
     * return {@link ArchiveState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #archiveStateAsString}.
     * </p>
     * 
     * @return The current state of the archive:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> – The archive is ready and available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted
     *         in 30 days. No further modifications can be made in this state.
     *         </p>
     *         </li>
     * @see ArchiveState
     */
    public final ArchiveState archiveState() {
        return ArchiveState.fromValue(archiveState);
    }

    /**
     * <p>
     * The current state of the archive:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The archive is ready and available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in 30
     * days. No further modifications can be made in this state.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #archiveState} will
     * return {@link ArchiveState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #archiveStateAsString}.
     * </p>
     * 
     * @return The current state of the archive:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> – The archive is ready and available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted
     *         in 30 days. No further modifications can be made in this state.
     *         </p>
     *         </li>
     * @see ArchiveState
     */
    public final String archiveStateAsString() {
        return archiveState;
    }

    /**
     * <p>
     * The timestamp of when the archive was created.
     * </p>
     * 
     * @return The timestamp of when the archive was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key used to encrypt the archive.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key used to encrypt the archive.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The timestamp of when the archive was modified.
     * </p>
     * 
     * @return The timestamp of when the archive was modified.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The retention period for emails in this archive.
     * </p>
     * 
     * @return The retention period for emails in this archive.
     */
    public final ArchiveRetention retention() {
        return retention;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(archiveArn());
        hashCode = 31 * hashCode + Objects.hashCode(archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(archiveName());
        hashCode = 31 * hashCode + Objects.hashCode(archiveStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(retention());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveResponse)) {
            return false;
        }
        GetArchiveResponse other = (GetArchiveResponse) obj;
        return Objects.equals(archiveArn(), other.archiveArn()) && Objects.equals(archiveId(), other.archiveId())
                && Objects.equals(archiveName(), other.archiveName())
                && Objects.equals(archiveStateAsString(), other.archiveStateAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(retention(), other.retention());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetArchiveResponse").add("ArchiveArn", archiveArn()).add("ArchiveId", archiveId())
                .add("ArchiveName", archiveName()).add("ArchiveState", archiveStateAsString())
                .add("CreatedTimestamp", createdTimestamp()).add("KmsKeyArn", kmsKeyArn())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).add("Retention", retention()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveArn":
            return Optional.ofNullable(clazz.cast(archiveArn()));
        case "ArchiveId":
            return Optional.ofNullable(clazz.cast(archiveId()));
        case "ArchiveName":
            return Optional.ofNullable(clazz.cast(archiveName()));
        case "ArchiveState":
            return Optional.ofNullable(clazz.cast(archiveStateAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "Retention":
            return Optional.ofNullable(clazz.cast(retention()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveResponse, T> g) {
        return obj -> g.apply((GetArchiveResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetArchiveResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the archive.
         * </p>
         * 
         * @param archiveArn
         *        The Amazon Resource Name (ARN) of the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveArn(String archiveArn);

        /**
         * <p>
         * The unique identifier of the archive.
         * </p>
         * 
         * @param archiveId
         *        The unique identifier of the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveId(String archiveId);

        /**
         * <p>
         * The unique name assigned to the archive.
         * </p>
         * 
         * @param archiveName
         *        The unique name assigned to the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveName(String archiveName);

        /**
         * <p>
         * The current state of the archive:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> – The archive is ready and available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in
         * 30 days. No further modifications can be made in this state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param archiveState
         *        The current state of the archive:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> – The archive is ready and available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently
         *        deleted in 30 days. No further modifications can be made in this state.
         *        </p>
         *        </li>
         * @see ArchiveState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchiveState
         */
        Builder archiveState(String archiveState);

        /**
         * <p>
         * The current state of the archive:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> – The archive is ready and available for use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in
         * 30 days. No further modifications can be made in this state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param archiveState
         *        The current state of the archive:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> – The archive is ready and available for use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently
         *        deleted in 30 days. No further modifications can be made in this state.
         *        </p>
         *        </li>
         * @see ArchiveState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchiveState
         */
        Builder archiveState(ArchiveState archiveState);

        /**
         * <p>
         * The timestamp of when the archive was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp of when the archive was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key used to encrypt the archive.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key used to encrypt the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The timestamp of when the archive was modified.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The timestamp of when the archive was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * The retention period for emails in this archive.
         * </p>
         * 
         * @param retention
         *        The retention period for emails in this archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retention(ArchiveRetention retention);

        /**
         * <p>
         * The retention period for emails in this archive.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArchiveRetention.Builder} avoiding the
         * need to create one manually via {@link ArchiveRetention#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchiveRetention.Builder#build()} is called immediately and its
         * result is passed to {@link #retention(ArchiveRetention)}.
         * 
         * @param retention
         *        a consumer that will call methods on {@link ArchiveRetention.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retention(ArchiveRetention)
         */
        default Builder retention(Consumer<ArchiveRetention.Builder> retention) {
            return retention(ArchiveRetention.builder().applyMutation(retention).build());
        }
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private String archiveArn;

        private String archiveId;

        private String archiveName;

        private String archiveState;

        private Instant createdTimestamp;

        private String kmsKeyArn;

        private Instant lastUpdatedTimestamp;

        private ArchiveRetention retention;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveResponse model) {
            super(model);
            archiveArn(model.archiveArn);
            archiveId(model.archiveId);
            archiveName(model.archiveName);
            archiveState(model.archiveState);
            createdTimestamp(model.createdTimestamp);
            kmsKeyArn(model.kmsKeyArn);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            retention(model.retention);
        }

        public final String getArchiveArn() {
            return archiveArn;
        }

        public final void setArchiveArn(String archiveArn) {
            this.archiveArn = archiveArn;
        }

        @Override
        public final Builder archiveArn(String archiveArn) {
            this.archiveArn = archiveArn;
            return this;
        }

        public final String getArchiveId() {
            return archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final String getArchiveName() {
            return archiveName;
        }

        public final void setArchiveName(String archiveName) {
            this.archiveName = archiveName;
        }

        @Override
        public final Builder archiveName(String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        public final String getArchiveState() {
            return archiveState;
        }

        public final void setArchiveState(String archiveState) {
            this.archiveState = archiveState;
        }

        @Override
        public final Builder archiveState(String archiveState) {
            this.archiveState = archiveState;
            return this;
        }

        @Override
        public final Builder archiveState(ArchiveState archiveState) {
            this.archiveState(archiveState == null ? null : archiveState.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final ArchiveRetention.Builder getRetention() {
            return retention != null ? retention.toBuilder() : null;
        }

        public final void setRetention(ArchiveRetention.BuilderImpl retention) {
            this.retention = retention != null ? retention.build() : null;
        }

        @Override
        public final Builder retention(ArchiveRetention retention) {
            this.retention = retention;
            return this;
        }

        @Override
        public GetArchiveResponse build() {
            return new GetArchiveResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
