/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure of a traffic policy resource which is a container for policy statements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficPolicy implements SdkPojo, Serializable, ToCopyableBuilder<TrafficPolicy.Builder, TrafficPolicy> {
    private static final SdkField<String> DEFAULT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultAction").getter(getter(TrafficPolicy::defaultActionAsString))
            .setter(setter(Builder::defaultAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyId").getter(getter(TrafficPolicy::trafficPolicyId))
            .setter(setter(Builder::trafficPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyName").getter(getter(TrafficPolicy::trafficPolicyName))
            .setter(setter(Builder::trafficPolicyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_ACTION_FIELD,
            TRAFFIC_POLICY_ID_FIELD, TRAFFIC_POLICY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultAction;

    private final String trafficPolicyId;

    private final String trafficPolicyName;

    private TrafficPolicy(BuilderImpl builder) {
        this.defaultAction = builder.defaultAction;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyName = builder.trafficPolicyName;
    }

    /**
     * <p>
     * Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not
     * addressed by) the conditions of your policy statements
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultAction}
     * will return {@link AcceptAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultActionAsString}.
     * </p>
     * 
     * @return Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of
     *         (or not addressed by) the conditions of your policy statements
     * @see AcceptAction
     */
    public final AcceptAction defaultAction() {
        return AcceptAction.fromValue(defaultAction);
    }

    /**
     * <p>
     * Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not
     * addressed by) the conditions of your policy statements
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultAction}
     * will return {@link AcceptAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultActionAsString}.
     * </p>
     * 
     * @return Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of
     *         (or not addressed by) the conditions of your policy statements
     * @see AcceptAction
     */
    public final String defaultActionAsString() {
        return defaultAction;
    }

    /**
     * <p>
     * The identifier of the traffic policy resource.
     * </p>
     * 
     * @return The identifier of the traffic policy resource.
     */
    public final String trafficPolicyId() {
        return trafficPolicyId;
    }

    /**
     * <p>
     * A user-friendly name of the traffic policy resource.
     * </p>
     * 
     * @return A user-friendly name of the traffic policy resource.
     */
    public final String trafficPolicyName() {
        return trafficPolicyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPolicy)) {
            return false;
        }
        TrafficPolicy other = (TrafficPolicy) obj;
        return Objects.equals(defaultActionAsString(), other.defaultActionAsString())
                && Objects.equals(trafficPolicyId(), other.trafficPolicyId())
                && Objects.equals(trafficPolicyName(), other.trafficPolicyName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficPolicy").add("DefaultAction", defaultActionAsString())
                .add("TrafficPolicyId", trafficPolicyId()).add("TrafficPolicyName", trafficPolicyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultAction":
            return Optional.ofNullable(clazz.cast(defaultActionAsString()));
        case "TrafficPolicyId":
            return Optional.ofNullable(clazz.cast(trafficPolicyId()));
        case "TrafficPolicyName":
            return Optional.ofNullable(clazz.cast(trafficPolicyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficPolicy, T> g) {
        return obj -> g.apply((TrafficPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficPolicy> {
        /**
         * <p>
         * Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or
         * not addressed by) the conditions of your policy statements
         * </p>
         * 
         * @param defaultAction
         *        Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside
         *        of (or not addressed by) the conditions of your policy statements
         * @see AcceptAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptAction
         */
        Builder defaultAction(String defaultAction);

        /**
         * <p>
         * Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or
         * not addressed by) the conditions of your policy statements
         * </p>
         * 
         * @param defaultAction
         *        Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside
         *        of (or not addressed by) the conditions of your policy statements
         * @see AcceptAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptAction
         */
        Builder defaultAction(AcceptAction defaultAction);

        /**
         * <p>
         * The identifier of the traffic policy resource.
         * </p>
         * 
         * @param trafficPolicyId
         *        The identifier of the traffic policy resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);

        /**
         * <p>
         * A user-friendly name of the traffic policy resource.
         * </p>
         * 
         * @param trafficPolicyName
         *        A user-friendly name of the traffic policy resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyName(String trafficPolicyName);
    }

    static final class BuilderImpl implements Builder {
        private String defaultAction;

        private String trafficPolicyId;

        private String trafficPolicyName;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficPolicy model) {
            defaultAction(model.defaultAction);
            trafficPolicyId(model.trafficPolicyId);
            trafficPolicyName(model.trafficPolicyName);
        }

        public final String getDefaultAction() {
            return defaultAction;
        }

        public final void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        @Override
        public final Builder defaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        @Override
        public final Builder defaultAction(AcceptAction defaultAction) {
            this.defaultAction(defaultAction == null ? null : defaultAction.toString());
            return this;
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final String getTrafficPolicyName() {
            return trafficPolicyName;
        }

        public final void setTrafficPolicyName(String trafficPolicyName) {
            this.trafficPolicyName = trafficPolicyName;
        }

        @Override
        public final Builder trafficPolicyName(String trafficPolicyName) {
            this.trafficPolicyName = trafficPolicyName;
            return this;
        }

        @Override
        public TrafficPolicy build() {
            return new TrafficPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
