/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mailmanager.model.SearchState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchStatus> {
    private static final SdkField<Instant> COMPLETION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTimestamp").getter(SearchStatus.getter(SearchStatus::completionTimestamp)).setter(SearchStatus.setter(Builder::completionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTimestamp").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(SearchStatus.getter(SearchStatus::errorMessage)).setter(SearchStatus.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(SearchStatus.getter(SearchStatus::stateAsString)).setter(SearchStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> SUBMISSION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmissionTimestamp").getter(SearchStatus.getter(SearchStatus::submissionTimestamp)).setter(SearchStatus.setter(Builder::submissionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmissionTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIMESTAMP_FIELD, ERROR_MESSAGE_FIELD, STATE_FIELD, SUBMISSION_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant completionTimestamp;
    private final String errorMessage;
    private final String state;
    private final Instant submissionTimestamp;

    private SearchStatus(BuilderImpl builder) {
        this.completionTimestamp = builder.completionTimestamp;
        this.errorMessage = builder.errorMessage;
        this.state = builder.state;
        this.submissionTimestamp = builder.submissionTimestamp;
    }

    public final Instant completionTimestamp() {
        return this.completionTimestamp;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final SearchState state() {
        return SearchState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant submissionTimestamp() {
        return this.submissionTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submissionTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchStatus)) {
            return false;
        }
        SearchStatus other = (SearchStatus)obj;
        return Objects.equals(this.completionTimestamp(), other.completionTimestamp()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.submissionTimestamp(), other.submissionTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"SearchStatus").add("CompletionTimestamp", (Object)this.completionTimestamp()).add("ErrorMessage", (Object)this.errorMessage()).add("State", (Object)this.stateAsString()).add("SubmissionTimestamp", (Object)this.submissionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompletionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.completionTimestamp()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "SubmissionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.submissionTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchStatus, T> g) {
        return obj -> g.apply((SearchStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant completionTimestamp;
        private String errorMessage;
        private String state;
        private Instant submissionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchStatus model) {
            this.completionTimestamp(model.completionTimestamp);
            this.errorMessage(model.errorMessage);
            this.state(model.state);
            this.submissionTimestamp(model.submissionTimestamp);
        }

        public final Instant getCompletionTimestamp() {
            return this.completionTimestamp;
        }

        public final void setCompletionTimestamp(Instant completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
        }

        @Override
        public final Builder completionTimestamp(Instant completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SearchState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getSubmissionTimestamp() {
            return this.submissionTimestamp;
        }

        public final void setSubmissionTimestamp(Instant submissionTimestamp) {
            this.submissionTimestamp = submissionTimestamp;
        }

        @Override
        public final Builder submissionTimestamp(Instant submissionTimestamp) {
            this.submissionTimestamp = submissionTimestamp;
            return this;
        }

        public SearchStatus build() {
            return new SearchStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchStatus> {
        public Builder completionTimestamp(Instant var1);

        public Builder errorMessage(String var1);

        public Builder state(String var1);

        public Builder state(SearchState var1);

        public Builder submissionTimestamp(Instant var1);
    }
}

