/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A subscription for an Add On representing the acceptance of its terms of use and additional pricing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddonSubscription implements SdkPojo, Serializable,
        ToCopyableBuilder<AddonSubscription.Builder, AddonSubscription> {
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddonName").getter(getter(AddonSubscription::addonName)).setter(setter(Builder::addonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddonName").build()).build();

    private static final SdkField<String> ADDON_SUBSCRIPTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddonSubscriptionArn").getter(getter(AddonSubscription::addonSubscriptionArn))
            .setter(setter(Builder::addonSubscriptionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddonSubscriptionArn").build())
            .build();

    private static final SdkField<String> ADDON_SUBSCRIPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddonSubscriptionId").getter(getter(AddonSubscription::addonSubscriptionId))
            .setter(setter(Builder::addonSubscriptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddonSubscriptionId").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(AddonSubscription::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_NAME_FIELD,
            ADDON_SUBSCRIPTION_ARN_FIELD, ADDON_SUBSCRIPTION_ID_FIELD, CREATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String addonName;

    private final String addonSubscriptionArn;

    private final String addonSubscriptionId;

    private final Instant createdTimestamp;

    private AddonSubscription(BuilderImpl builder) {
        this.addonName = builder.addonName;
        this.addonSubscriptionArn = builder.addonSubscriptionArn;
        this.addonSubscriptionId = builder.addonSubscriptionId;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The name of the Add On.
     * </p>
     * 
     * @return The name of the Add On.
     */
    public final String addonName() {
        return addonName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Add On subscription.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Add On subscription.
     */
    public final String addonSubscriptionArn() {
        return addonSubscriptionArn;
    }

    /**
     * <p>
     * The unique ID of the Add On subscription.
     * </p>
     * 
     * @return The unique ID of the Add On subscription.
     */
    public final String addonSubscriptionId() {
        return addonSubscriptionId;
    }

    /**
     * <p>
     * The timestamp of when the Add On subscription was created.
     * </p>
     * 
     * @return The timestamp of when the Add On subscription was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addonName());
        hashCode = 31 * hashCode + Objects.hashCode(addonSubscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(addonSubscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonSubscription)) {
            return false;
        }
        AddonSubscription other = (AddonSubscription) obj;
        return Objects.equals(addonName(), other.addonName())
                && Objects.equals(addonSubscriptionArn(), other.addonSubscriptionArn())
                && Objects.equals(addonSubscriptionId(), other.addonSubscriptionId())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddonSubscription").add("AddonName", addonName())
                .add("AddonSubscriptionArn", addonSubscriptionArn()).add("AddonSubscriptionId", addonSubscriptionId())
                .add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddonName":
            return Optional.ofNullable(clazz.cast(addonName()));
        case "AddonSubscriptionArn":
            return Optional.ofNullable(clazz.cast(addonSubscriptionArn()));
        case "AddonSubscriptionId":
            return Optional.ofNullable(clazz.cast(addonSubscriptionId()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddonSubscription, T> g) {
        return obj -> g.apply((AddonSubscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddonSubscription> {
        /**
         * <p>
         * The name of the Add On.
         * </p>
         * 
         * @param addonName
         *        The name of the Add On.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonName(String addonName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Add On subscription.
         * </p>
         * 
         * @param addonSubscriptionArn
         *        The Amazon Resource Name (ARN) of the Add On subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonSubscriptionArn(String addonSubscriptionArn);

        /**
         * <p>
         * The unique ID of the Add On subscription.
         * </p>
         * 
         * @param addonSubscriptionId
         *        The unique ID of the Add On subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonSubscriptionId(String addonSubscriptionId);

        /**
         * <p>
         * The timestamp of when the Add On subscription was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp of when the Add On subscription was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String addonName;

        private String addonSubscriptionArn;

        private String addonSubscriptionId;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(AddonSubscription model) {
            addonName(model.addonName);
            addonSubscriptionArn(model.addonSubscriptionArn);
            addonSubscriptionId(model.addonSubscriptionId);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getAddonName() {
            return addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getAddonSubscriptionArn() {
            return addonSubscriptionArn;
        }

        public final void setAddonSubscriptionArn(String addonSubscriptionArn) {
            this.addonSubscriptionArn = addonSubscriptionArn;
        }

        @Override
        public final Builder addonSubscriptionArn(String addonSubscriptionArn) {
            this.addonSubscriptionArn = addonSubscriptionArn;
            return this;
        }

        public final String getAddonSubscriptionId() {
            return addonSubscriptionId;
        }

        public final void setAddonSubscriptionId(String addonSubscriptionId) {
            this.addonSubscriptionId = addonSubscriptionId;
        }

        @Override
        public final Builder addonSubscriptionId(String addonSubscriptionId) {
            this.addonSubscriptionId = addonSubscriptionId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public AddonSubscription build() {
            return new AddonSubscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
