/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action to archive the email by delivering the email to an Amazon SES archive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveAction implements SdkPojo, Serializable, ToCopyableBuilder<ArchiveAction.Builder, ArchiveAction> {
    private static final SdkField<String> ACTION_FAILURE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionFailurePolicy").getter(getter(ArchiveAction::actionFailurePolicyAsString))
            .setter(setter(Builder::actionFailurePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionFailurePolicy").build())
            .build();

    private static final SdkField<String> TARGET_ARCHIVE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetArchive").getter(getter(ArchiveAction::targetArchive)).setter(setter(Builder::targetArchive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArchive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FAILURE_POLICY_FIELD,
            TARGET_ARCHIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionFailurePolicy;

    private final String targetArchive;

    private ArchiveAction(BuilderImpl builder) {
        this.actionFailurePolicy = builder.actionFailurePolicy;
        this.targetArchive = builder.targetArchive;
    }

    /**
     * <p>
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors.
     * For example, the specified archive has been deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionFailurePolicy} will return {@link ActionFailurePolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionFailurePolicyAsString}.
     * </p>
     * 
     * @return A policy that states what to do in the case of failure. The action will fail if there are configuration
     *         errors. For example, the specified archive has been deleted.
     * @see ActionFailurePolicy
     */
    public final ActionFailurePolicy actionFailurePolicy() {
        return ActionFailurePolicy.fromValue(actionFailurePolicy);
    }

    /**
     * <p>
     * A policy that states what to do in the case of failure. The action will fail if there are configuration errors.
     * For example, the specified archive has been deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionFailurePolicy} will return {@link ActionFailurePolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionFailurePolicyAsString}.
     * </p>
     * 
     * @return A policy that states what to do in the case of failure. The action will fail if there are configuration
     *         errors. For example, the specified archive has been deleted.
     * @see ActionFailurePolicy
     */
    public final String actionFailurePolicyAsString() {
        return actionFailurePolicy;
    }

    /**
     * <p>
     * The identifier of the archive to send the email to.
     * </p>
     * 
     * @return The identifier of the archive to send the email to.
     */
    public final String targetArchive() {
        return targetArchive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionFailurePolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetArchive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveAction)) {
            return false;
        }
        ArchiveAction other = (ArchiveAction) obj;
        return Objects.equals(actionFailurePolicyAsString(), other.actionFailurePolicyAsString())
                && Objects.equals(targetArchive(), other.targetArchive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchiveAction").add("ActionFailurePolicy", actionFailurePolicyAsString())
                .add("TargetArchive", targetArchive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionFailurePolicy":
            return Optional.ofNullable(clazz.cast(actionFailurePolicyAsString()));
        case "TargetArchive":
            return Optional.ofNullable(clazz.cast(targetArchive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArchiveAction, T> g) {
        return obj -> g.apply((ArchiveAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveAction> {
        /**
         * <p>
         * A policy that states what to do in the case of failure. The action will fail if there are configuration
         * errors. For example, the specified archive has been deleted.
         * </p>
         * 
         * @param actionFailurePolicy
         *        A policy that states what to do in the case of failure. The action will fail if there are
         *        configuration errors. For example, the specified archive has been deleted.
         * @see ActionFailurePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionFailurePolicy
         */
        Builder actionFailurePolicy(String actionFailurePolicy);

        /**
         * <p>
         * A policy that states what to do in the case of failure. The action will fail if there are configuration
         * errors. For example, the specified archive has been deleted.
         * </p>
         * 
         * @param actionFailurePolicy
         *        A policy that states what to do in the case of failure. The action will fail if there are
         *        configuration errors. For example, the specified archive has been deleted.
         * @see ActionFailurePolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionFailurePolicy
         */
        Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy);

        /**
         * <p>
         * The identifier of the archive to send the email to.
         * </p>
         * 
         * @param targetArchive
         *        The identifier of the archive to send the email to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArchive(String targetArchive);
    }

    static final class BuilderImpl implements Builder {
        private String actionFailurePolicy;

        private String targetArchive;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveAction model) {
            actionFailurePolicy(model.actionFailurePolicy);
            targetArchive(model.targetArchive);
        }

        public final String getActionFailurePolicy() {
            return actionFailurePolicy;
        }

        public final void setActionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
        }

        @Override
        public final Builder actionFailurePolicy(String actionFailurePolicy) {
            this.actionFailurePolicy = actionFailurePolicy;
            return this;
        }

        @Override
        public final Builder actionFailurePolicy(ActionFailurePolicy actionFailurePolicy) {
            this.actionFailurePolicy(actionFailurePolicy == null ? null : actionFailurePolicy.toString());
            return this;
        }

        public final String getTargetArchive() {
            return targetArchive;
        }

        public final void setTargetArchive(String targetArchive) {
            this.targetArchive = targetArchive;
        }

        @Override
        public final Builder targetArchive(String targetArchive) {
            this.targetArchive = targetArchive;
            return this;
        }

        @Override
        public ArchiveAction build() {
            return new ArchiveAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
