/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule set contains a list of rules that are evaluated in order. Each rule is evaluated sequentially for each email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleSet implements SdkPojo, Serializable, ToCopyableBuilder<RuleSet.Builder, RuleSet> {
    private static final SdkField<Instant> LAST_MODIFICATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationDate").getter(getter(RuleSet::lastModificationDate))
            .setter(setter(Builder::lastModificationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationDate").build())
            .build();

    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetId").getter(getter(RuleSet::ruleSetId)).setter(setter(Builder::ruleSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()).build();

    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetName").getter(getter(RuleSet::ruleSetName)).setter(setter(Builder::ruleSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_MODIFICATION_DATE_FIELD,
            RULE_SET_ID_FIELD, RULE_SET_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant lastModificationDate;

    private final String ruleSetId;

    private final String ruleSetName;

    private RuleSet(BuilderImpl builder) {
        this.lastModificationDate = builder.lastModificationDate;
        this.ruleSetId = builder.ruleSetId;
        this.ruleSetName = builder.ruleSetName;
    }

    /**
     * <p>
     * The last modification date of the rule set.
     * </p>
     * 
     * @return The last modification date of the rule set.
     */
    public final Instant lastModificationDate() {
        return lastModificationDate;
    }

    /**
     * <p>
     * The identifier of the rule set.
     * </p>
     * 
     * @return The identifier of the rule set.
     */
    public final String ruleSetId() {
        return ruleSetId;
    }

    /**
     * <p>
     * A user-friendly name for the rule set.
     * </p>
     * 
     * @return A user-friendly name for the rule set.
     */
    public final String ruleSetName() {
        return ruleSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationDate());
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleSet)) {
            return false;
        }
        RuleSet other = (RuleSet) obj;
        return Objects.equals(lastModificationDate(), other.lastModificationDate())
                && Objects.equals(ruleSetId(), other.ruleSetId()) && Objects.equals(ruleSetName(), other.ruleSetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleSet").add("LastModificationDate", lastModificationDate()).add("RuleSetId", ruleSetId())
                .add("RuleSetName", ruleSetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastModificationDate":
            return Optional.ofNullable(clazz.cast(lastModificationDate()));
        case "RuleSetId":
            return Optional.ofNullable(clazz.cast(ruleSetId()));
        case "RuleSetName":
            return Optional.ofNullable(clazz.cast(ruleSetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleSet, T> g) {
        return obj -> g.apply((RuleSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleSet> {
        /**
         * <p>
         * The last modification date of the rule set.
         * </p>
         * 
         * @param lastModificationDate
         *        The last modification date of the rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationDate(Instant lastModificationDate);

        /**
         * <p>
         * The identifier of the rule set.
         * </p>
         * 
         * @param ruleSetId
         *        The identifier of the rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetId(String ruleSetId);

        /**
         * <p>
         * A user-friendly name for the rule set.
         * </p>
         * 
         * @param ruleSetName
         *        A user-friendly name for the rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastModificationDate;

        private String ruleSetId;

        private String ruleSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleSet model) {
            lastModificationDate(model.lastModificationDate);
            ruleSetId(model.ruleSetId);
            ruleSetName(model.ruleSetName);
        }

        public final Instant getLastModificationDate() {
            return lastModificationDate;
        }

        public final void setLastModificationDate(Instant lastModificationDate) {
            this.lastModificationDate = lastModificationDate;
        }

        @Override
        public final Builder lastModificationDate(Instant lastModificationDate) {
            this.lastModificationDate = lastModificationDate;
            return this;
        }

        public final String getRuleSetId() {
            return ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        @Override
        public RuleSet build() {
            return new RuleSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
