/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteIngressPointRequest extends MailManagerRequest implements
        ToCopyableBuilder<DeleteIngressPointRequest.Builder, DeleteIngressPointRequest> {
    private static final SdkField<String> INGRESS_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngressPointId").getter(getter(DeleteIngressPointRequest::ingressPointId))
            .setter(setter(Builder::ingressPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGRESS_POINT_ID_FIELD));

    private final String ingressPointId;

    private DeleteIngressPointRequest(BuilderImpl builder) {
        super(builder);
        this.ingressPointId = builder.ingressPointId;
    }

    /**
     * <p>
     * The identifier of the ingress endpoint resource that you want to delete.
     * </p>
     * 
     * @return The identifier of the ingress endpoint resource that you want to delete.
     */
    public final String ingressPointId() {
        return ingressPointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIngressPointRequest)) {
            return false;
        }
        DeleteIngressPointRequest other = (DeleteIngressPointRequest) obj;
        return Objects.equals(ingressPointId(), other.ingressPointId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteIngressPointRequest").add("IngressPointId", ingressPointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IngressPointId":
            return Optional.ofNullable(clazz.cast(ingressPointId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteIngressPointRequest, T> g) {
        return obj -> g.apply((DeleteIngressPointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteIngressPointRequest> {
        /**
         * <p>
         * The identifier of the ingress endpoint resource that you want to delete.
         * </p>
         * 
         * @param ingressPointId
         *        The identifier of the ingress endpoint resource that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointId(String ingressPointId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MailManagerRequest.BuilderImpl implements Builder {
        private String ingressPointId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIngressPointRequest model) {
            super(model);
            ingressPointId(model.ingressPointId);
        }

        public final String getIngressPointId() {
            return ingressPointId;
        }

        public final void setIngressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
        }

        @Override
        public final Builder ingressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteIngressPointRequest build() {
            return new DeleteIngressPointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
