/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary statuses of an archive export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportSummary implements SdkPojo, Serializable, ToCopyableBuilder<ExportSummary.Builder, ExportSummary> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportId").getter(getter(ExportSummary::exportId)).setter(setter(Builder::exportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportId").build()).build();

    private static final SdkField<ExportStatus> STATUS_FIELD = SdkField.<ExportStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(ExportSummary::status)).setter(setter(Builder::status))
            .constructor(ExportStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(EXPORT_ID_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exportId;

    private final ExportStatus status;

    private ExportSummary(BuilderImpl builder) {
        this.exportId = builder.exportId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique identifier of the export job.
     * </p>
     * 
     * @return The unique identifier of the export job.
     */
    public final String exportId() {
        return exportId;
    }

    /**
     * <p>
     * The current status of the export job.
     * </p>
     * 
     * @return The current status of the export job.
     */
    public final ExportStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSummary)) {
            return false;
        }
        ExportSummary other = (ExportSummary) obj;
        return Objects.equals(exportId(), other.exportId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportSummary").add("ExportId", exportId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportId":
            return Optional.ofNullable(clazz.cast(exportId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportSummary, T> g) {
        return obj -> g.apply((ExportSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportSummary> {
        /**
         * <p>
         * The unique identifier of the export job.
         * </p>
         * 
         * @param exportId
         *        The unique identifier of the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportId(String exportId);

        /**
         * <p>
         * The current status of the export job.
         * </p>
         * 
         * @param status
         *        The current status of the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ExportStatus status);

        /**
         * <p>
         * The current status of the export job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportStatus.Builder} avoiding the need
         * to create one manually via {@link ExportStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(ExportStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ExportStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ExportStatus)
         */
        default Builder status(Consumer<ExportStatus.Builder> status) {
            return status(ExportStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String exportId;

        private ExportStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSummary model) {
            exportId(model.exportId);
            status(model.status);
        }

        public final String getExportId() {
            return exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final ExportStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ExportStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ExportStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public ExportSummary build() {
            return new ExportSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
