/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAddonSubscriptionResponse extends MailManagerResponse implements
        ToCopyableBuilder<GetAddonSubscriptionResponse.Builder, GetAddonSubscriptionResponse> {
    private static final SdkField<String> ADDON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddonName").getter(getter(GetAddonSubscriptionResponse::addonName)).setter(setter(Builder::addonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddonName").build()).build();

    private static final SdkField<String> ADDON_SUBSCRIPTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddonSubscriptionArn").getter(getter(GetAddonSubscriptionResponse::addonSubscriptionArn))
            .setter(setter(Builder::addonSubscriptionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddonSubscriptionArn").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(GetAddonSubscriptionResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_NAME_FIELD,
            ADDON_SUBSCRIPTION_ARN_FIELD, CREATED_TIMESTAMP_FIELD));

    private final String addonName;

    private final String addonSubscriptionArn;

    private final Instant createdTimestamp;

    private GetAddonSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.addonName = builder.addonName;
        this.addonSubscriptionArn = builder.addonSubscriptionArn;
        this.createdTimestamp = builder.createdTimestamp;
    }

    /**
     * <p>
     * The name of the Add On for the subscription.
     * </p>
     * 
     * @return The name of the Add On for the subscription.
     */
    public final String addonName() {
        return addonName;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) for the subscription.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) for the subscription.
     */
    public final String addonSubscriptionArn() {
        return addonSubscriptionArn;
    }

    /**
     * <p>
     * The timestamp of when the Add On subscription was created.
     * </p>
     * 
     * @return The timestamp of when the Add On subscription was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(addonName());
        hashCode = 31 * hashCode + Objects.hashCode(addonSubscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAddonSubscriptionResponse)) {
            return false;
        }
        GetAddonSubscriptionResponse other = (GetAddonSubscriptionResponse) obj;
        return Objects.equals(addonName(), other.addonName())
                && Objects.equals(addonSubscriptionArn(), other.addonSubscriptionArn())
                && Objects.equals(createdTimestamp(), other.createdTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAddonSubscriptionResponse").add("AddonName", addonName())
                .add("AddonSubscriptionArn", addonSubscriptionArn()).add("CreatedTimestamp", createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddonName":
            return Optional.ofNullable(clazz.cast(addonName()));
        case "AddonSubscriptionArn":
            return Optional.ofNullable(clazz.cast(addonSubscriptionArn()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAddonSubscriptionResponse, T> g) {
        return obj -> g.apply((GetAddonSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAddonSubscriptionResponse> {
        /**
         * <p>
         * The name of the Add On for the subscription.
         * </p>
         * 
         * @param addonName
         *        The name of the Add On for the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonName(String addonName);

        /**
         * <p>
         * Amazon Resource Name (ARN) for the subscription.
         * </p>
         * 
         * @param addonSubscriptionArn
         *        Amazon Resource Name (ARN) for the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonSubscriptionArn(String addonSubscriptionArn);

        /**
         * <p>
         * The timestamp of when the Add On subscription was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp of when the Add On subscription was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private String addonName;

        private String addonSubscriptionArn;

        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAddonSubscriptionResponse model) {
            super(model);
            addonName(model.addonName);
            addonSubscriptionArn(model.addonSubscriptionArn);
            createdTimestamp(model.createdTimestamp);
        }

        public final String getAddonName() {
            return addonName;
        }

        public final void setAddonName(String addonName) {
            this.addonName = addonName;
        }

        @Override
        public final Builder addonName(String addonName) {
            this.addonName = addonName;
            return this;
        }

        public final String getAddonSubscriptionArn() {
            return addonSubscriptionArn;
        }

        public final void setAddonSubscriptionArn(String addonSubscriptionArn) {
            this.addonSubscriptionArn = addonSubscriptionArn;
        }

        @Override
        public final Builder addonSubscriptionArn(String addonSubscriptionArn) {
            this.addonSubscriptionArn = addonSubscriptionArn;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public GetAddonSubscriptionResponse build() {
            return new GetAddonSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
