/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelayResponse extends MailManagerResponse implements
        ToCopyableBuilder<GetRelayResponse.Builder, GetRelayResponse> {
    private static final SdkField<RelayAuthentication> AUTHENTICATION_FIELD = SdkField
            .<RelayAuthentication> builder(MarshallingType.SDK_POJO).memberName("Authentication")
            .getter(getter(GetRelayResponse::authentication)).setter(setter(Builder::authentication))
            .constructor(RelayAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(GetRelayResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimestamp").getter(getter(GetRelayResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimestamp").build())
            .build();

    private static final SdkField<String> RELAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelayArn").getter(getter(GetRelayResponse::relayArn)).setter(setter(Builder::relayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayArn").build()).build();

    private static final SdkField<String> RELAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelayId").getter(getter(GetRelayResponse::relayId)).setter(setter(Builder::relayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayId").build()).build();

    private static final SdkField<String> RELAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelayName").getter(getter(GetRelayResponse::relayName)).setter(setter(Builder::relayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayName").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(GetRelayResponse::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<Integer> SERVER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ServerPort").getter(getter(GetRelayResponse::serverPort)).setter(setter(Builder::serverPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_FIELD,
            CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, RELAY_ARN_FIELD, RELAY_ID_FIELD, RELAY_NAME_FIELD,
            SERVER_NAME_FIELD, SERVER_PORT_FIELD));

    private final RelayAuthentication authentication;

    private final Instant createdTimestamp;

    private final Instant lastModifiedTimestamp;

    private final String relayArn;

    private final String relayId;

    private final String relayName;

    private final String serverName;

    private final Integer serverPort;

    private GetRelayResponse(BuilderImpl builder) {
        super(builder);
        this.authentication = builder.authentication;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.relayArn = builder.relayArn;
        this.relayId = builder.relayId;
        this.relayName = builder.relayName;
        this.serverName = builder.serverName;
        this.serverPort = builder.serverPort;
    }

    /**
     * <p>
     * The authentication attribute—contains the secret ARN where the customer relay server credentials are stored.
     * </p>
     * 
     * @return The authentication attribute—contains the secret ARN where the customer relay server credentials are
     *         stored.
     */
    public final RelayAuthentication authentication() {
        return authentication;
    }

    /**
     * <p>
     * The timestamp of when the relay was created.
     * </p>
     * 
     * @return The timestamp of when the relay was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The timestamp of when relay was last updated.
     * </p>
     * 
     * @return The timestamp of when relay was last updated.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the relay.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the relay.
     */
    public final String relayArn() {
        return relayArn;
    }

    /**
     * <p>
     * The unique relay identifier.
     * </p>
     * 
     * @return The unique relay identifier.
     */
    public final String relayId() {
        return relayId;
    }

    /**
     * <p>
     * The unique name of the relay.
     * </p>
     * 
     * @return The unique name of the relay.
     */
    public final String relayName() {
        return relayName;
    }

    /**
     * <p>
     * The destination relay server address.
     * </p>
     * 
     * @return The destination relay server address.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The destination relay server port.
     * </p>
     * 
     * @return The destination relay server port.
     */
    public final Integer serverPort() {
        return serverPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authentication());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(relayArn());
        hashCode = 31 * hashCode + Objects.hashCode(relayId());
        hashCode = 31 * hashCode + Objects.hashCode(relayName());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(serverPort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelayResponse)) {
            return false;
        }
        GetRelayResponse other = (GetRelayResponse) obj;
        return Objects.equals(authentication(), other.authentication())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp())
                && Objects.equals(relayArn(), other.relayArn()) && Objects.equals(relayId(), other.relayId())
                && Objects.equals(relayName(), other.relayName()) && Objects.equals(serverName(), other.serverName())
                && Objects.equals(serverPort(), other.serverPort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRelayResponse").add("Authentication", authentication())
                .add("CreatedTimestamp", createdTimestamp()).add("LastModifiedTimestamp", lastModifiedTimestamp())
                .add("RelayArn", relayArn()).add("RelayId", relayId()).add("RelayName", relayName())
                .add("ServerName", serverName()).add("ServerPort", serverPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Authentication":
            return Optional.ofNullable(clazz.cast(authentication()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "LastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        case "RelayArn":
            return Optional.ofNullable(clazz.cast(relayArn()));
        case "RelayId":
            return Optional.ofNullable(clazz.cast(relayId()));
        case "RelayName":
            return Optional.ofNullable(clazz.cast(relayName()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "ServerPort":
            return Optional.ofNullable(clazz.cast(serverPort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelayResponse, T> g) {
        return obj -> g.apply((GetRelayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRelayResponse> {
        /**
         * <p>
         * The authentication attribute—contains the secret ARN where the customer relay server credentials are stored.
         * </p>
         * 
         * @param authentication
         *        The authentication attribute—contains the secret ARN where the customer relay server credentials are
         *        stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authentication(RelayAuthentication authentication);

        /**
         * <p>
         * The authentication attribute—contains the secret ARN where the customer relay server credentials are stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelayAuthentication.Builder} avoiding the
         * need to create one manually via {@link RelayAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelayAuthentication.Builder#build()} is called immediately and
         * its result is passed to {@link #authentication(RelayAuthentication)}.
         * 
         * @param authentication
         *        a consumer that will call methods on {@link RelayAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authentication(RelayAuthentication)
         */
        default Builder authentication(Consumer<RelayAuthentication.Builder> authentication) {
            return authentication(RelayAuthentication.builder().applyMutation(authentication).build());
        }

        /**
         * <p>
         * The timestamp of when the relay was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp of when the relay was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The timestamp of when relay was last updated.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The timestamp of when relay was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the relay.
         * </p>
         * 
         * @param relayArn
         *        The Amazon Resource Name (ARN) of the relay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relayArn(String relayArn);

        /**
         * <p>
         * The unique relay identifier.
         * </p>
         * 
         * @param relayId
         *        The unique relay identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relayId(String relayId);

        /**
         * <p>
         * The unique name of the relay.
         * </p>
         * 
         * @param relayName
         *        The unique name of the relay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relayName(String relayName);

        /**
         * <p>
         * The destination relay server address.
         * </p>
         * 
         * @param serverName
         *        The destination relay server address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The destination relay server port.
         * </p>
         * 
         * @param serverPort
         *        The destination relay server port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverPort(Integer serverPort);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private RelayAuthentication authentication;

        private Instant createdTimestamp;

        private Instant lastModifiedTimestamp;

        private String relayArn;

        private String relayId;

        private String relayName;

        private String serverName;

        private Integer serverPort;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelayResponse model) {
            super(model);
            authentication(model.authentication);
            createdTimestamp(model.createdTimestamp);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
            relayArn(model.relayArn);
            relayId(model.relayId);
            relayName(model.relayName);
            serverName(model.serverName);
            serverPort(model.serverPort);
        }

        public final RelayAuthentication.Builder getAuthentication() {
            return authentication != null ? authentication.toBuilder() : null;
        }

        public final void setAuthentication(RelayAuthentication.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        @Override
        public final Builder authentication(RelayAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getRelayArn() {
            return relayArn;
        }

        public final void setRelayArn(String relayArn) {
            this.relayArn = relayArn;
        }

        @Override
        public final Builder relayArn(String relayArn) {
            this.relayArn = relayArn;
            return this;
        }

        public final String getRelayId() {
            return relayId;
        }

        public final void setRelayId(String relayId) {
            this.relayId = relayId;
        }

        @Override
        public final Builder relayId(String relayId) {
            this.relayId = relayId;
            return this;
        }

        public final String getRelayName() {
            return relayName;
        }

        public final void setRelayName(String relayName) {
            this.relayName = relayName;
        }

        @Override
        public final Builder relayName(String relayName) {
            this.relayName = relayName;
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getServerPort() {
            return serverPort;
        }

        public final void setServerPort(Integer serverPort) {
            this.serverPort = serverPort;
        }

        @Override
        public final Builder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        @Override
        public GetRelayResponse build() {
            return new GetRelayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
