/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure for a TLS related condition matching on the incoming mail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngressTlsProtocolExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<IngressTlsProtocolExpression.Builder, IngressTlsProtocolExpression> {
    private static final SdkField<IngressTlsProtocolToEvaluate> EVALUATE_FIELD = SdkField
            .<IngressTlsProtocolToEvaluate> builder(MarshallingType.SDK_POJO).memberName("Evaluate")
            .getter(getter(IngressTlsProtocolExpression::evaluate)).setter(setter(Builder::evaluate))
            .constructor(IngressTlsProtocolToEvaluate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluate").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operator").getter(getter(IngressTlsProtocolExpression::operatorAsString))
            .setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(IngressTlsProtocolExpression::valueAsString)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATE_FIELD,
            OPERATOR_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final IngressTlsProtocolToEvaluate evaluate;

    private final String operator;

    private final String value;

    private IngressTlsProtocolExpression(BuilderImpl builder) {
        this.evaluate = builder.evaluate;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    /**
     * <p>
     * The left hand side argument of a TLS condition expression.
     * </p>
     * 
     * @return The left hand side argument of a TLS condition expression.
     */
    public final IngressTlsProtocolToEvaluate evaluate() {
        return evaluate;
    }

    /**
     * <p>
     * The matching operator for a TLS condition expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link IngressTlsProtocolOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The matching operator for a TLS condition expression.
     * @see IngressTlsProtocolOperator
     */
    public final IngressTlsProtocolOperator operator() {
        return IngressTlsProtocolOperator.fromValue(operator);
    }

    /**
     * <p>
     * The matching operator for a TLS condition expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link IngressTlsProtocolOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operatorAsString}.
     * </p>
     * 
     * @return The matching operator for a TLS condition expression.
     * @see IngressTlsProtocolOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The right hand side argument of a TLS condition expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link IngressTlsProtocolAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #valueAsString}.
     * </p>
     * 
     * @return The right hand side argument of a TLS condition expression.
     * @see IngressTlsProtocolAttribute
     */
    public final IngressTlsProtocolAttribute value() {
        return IngressTlsProtocolAttribute.fromValue(value);
    }

    /**
     * <p>
     * The right hand side argument of a TLS condition expression.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #value} will return
     * {@link IngressTlsProtocolAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #valueAsString}.
     * </p>
     * 
     * @return The right hand side argument of a TLS condition expression.
     * @see IngressTlsProtocolAttribute
     */
    public final String valueAsString() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluate());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(valueAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressTlsProtocolExpression)) {
            return false;
        }
        IngressTlsProtocolExpression other = (IngressTlsProtocolExpression) obj;
        return Objects.equals(evaluate(), other.evaluate()) && Objects.equals(operatorAsString(), other.operatorAsString())
                && Objects.equals(valueAsString(), other.valueAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngressTlsProtocolExpression").add("Evaluate", evaluate()).add("Operator", operatorAsString())
                .add("Value", valueAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Evaluate":
            return Optional.ofNullable(clazz.cast(evaluate()));
        case "Operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(valueAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngressTlsProtocolExpression, T> g) {
        return obj -> g.apply((IngressTlsProtocolExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngressTlsProtocolExpression> {
        /**
         * <p>
         * The left hand side argument of a TLS condition expression.
         * </p>
         * 
         * @param evaluate
         *        The left hand side argument of a TLS condition expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluate(IngressTlsProtocolToEvaluate evaluate);

        /**
         * <p>
         * The left hand side argument of a TLS condition expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressTlsProtocolToEvaluate.Builder}
         * avoiding the need to create one manually via {@link IngressTlsProtocolToEvaluate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressTlsProtocolToEvaluate.Builder#build()} is called
         * immediately and its result is passed to {@link #evaluate(IngressTlsProtocolToEvaluate)}.
         * 
         * @param evaluate
         *        a consumer that will call methods on {@link IngressTlsProtocolToEvaluate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluate(IngressTlsProtocolToEvaluate)
         */
        default Builder evaluate(Consumer<IngressTlsProtocolToEvaluate.Builder> evaluate) {
            return evaluate(IngressTlsProtocolToEvaluate.builder().applyMutation(evaluate).build());
        }

        /**
         * <p>
         * The matching operator for a TLS condition expression.
         * </p>
         * 
         * @param operator
         *        The matching operator for a TLS condition expression.
         * @see IngressTlsProtocolOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressTlsProtocolOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * The matching operator for a TLS condition expression.
         * </p>
         * 
         * @param operator
         *        The matching operator for a TLS condition expression.
         * @see IngressTlsProtocolOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressTlsProtocolOperator
         */
        Builder operator(IngressTlsProtocolOperator operator);

        /**
         * <p>
         * The right hand side argument of a TLS condition expression.
         * </p>
         * 
         * @param value
         *        The right hand side argument of a TLS condition expression.
         * @see IngressTlsProtocolAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressTlsProtocolAttribute
         */
        Builder value(String value);

        /**
         * <p>
         * The right hand side argument of a TLS condition expression.
         * </p>
         * 
         * @param value
         *        The right hand side argument of a TLS condition expression.
         * @see IngressTlsProtocolAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngressTlsProtocolAttribute
         */
        Builder value(IngressTlsProtocolAttribute value);
    }

    static final class BuilderImpl implements Builder {
        private IngressTlsProtocolToEvaluate evaluate;

        private String operator;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressTlsProtocolExpression model) {
            evaluate(model.evaluate);
            operator(model.operator);
            value(model.value);
        }

        public final IngressTlsProtocolToEvaluate.Builder getEvaluate() {
            return evaluate != null ? evaluate.toBuilder() : null;
        }

        public final void setEvaluate(IngressTlsProtocolToEvaluate.BuilderImpl evaluate) {
            this.evaluate = evaluate != null ? evaluate.build() : null;
        }

        @Override
        public final Builder evaluate(IngressTlsProtocolToEvaluate evaluate) {
            this.evaluate = evaluate;
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(IngressTlsProtocolOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(IngressTlsProtocolAttribute value) {
            this.value(value == null ? null : value.toString());
            return this;
        }

        @Override
        public IngressTlsProtocolExpression build() {
            return new IngressTlsProtocolExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
