/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAddonSubscriptionsResponse extends MailManagerResponse implements
        ToCopyableBuilder<ListAddonSubscriptionsResponse.Builder, ListAddonSubscriptionsResponse> {
    private static final SdkField<List<AddonSubscription>> ADDON_SUBSCRIPTIONS_FIELD = SdkField
            .<List<AddonSubscription>> builder(MarshallingType.LIST)
            .memberName("AddonSubscriptions")
            .getter(getter(ListAddonSubscriptionsResponse::addonSubscriptions))
            .setter(setter(Builder::addonSubscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddonSubscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddonSubscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddonSubscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAddonSubscriptionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDON_SUBSCRIPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AddonSubscription> addonSubscriptions;

    private final String nextToken;

    private ListAddonSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.addonSubscriptions = builder.addonSubscriptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddonSubscriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddonSubscriptions() {
        return addonSubscriptions != null && !(addonSubscriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of ingress endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddonSubscriptions} method.
     * </p>
     * 
     * @return The list of ingress endpoints.
     */
    public final List<AddonSubscription> addonSubscriptions() {
        return addonSubscriptions;
    }

    /**
     * <p>
     * If NextToken is returned, there are more results available. The value of NextToken is a unique pagination token
     * for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return If NextToken is returned, there are more results available. The value of NextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAddonSubscriptions() ? addonSubscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAddonSubscriptionsResponse)) {
            return false;
        }
        ListAddonSubscriptionsResponse other = (ListAddonSubscriptionsResponse) obj;
        return hasAddonSubscriptions() == other.hasAddonSubscriptions()
                && Objects.equals(addonSubscriptions(), other.addonSubscriptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAddonSubscriptionsResponse")
                .add("AddonSubscriptions", hasAddonSubscriptions() ? addonSubscriptions() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddonSubscriptions":
            return Optional.ofNullable(clazz.cast(addonSubscriptions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAddonSubscriptionsResponse, T> g) {
        return obj -> g.apply((ListAddonSubscriptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAddonSubscriptionsResponse> {
        /**
         * <p>
         * The list of ingress endpoints.
         * </p>
         * 
         * @param addonSubscriptions
         *        The list of ingress endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonSubscriptions(Collection<AddonSubscription> addonSubscriptions);

        /**
         * <p>
         * The list of ingress endpoints.
         * </p>
         * 
         * @param addonSubscriptions
         *        The list of ingress endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addonSubscriptions(AddonSubscription... addonSubscriptions);

        /**
         * <p>
         * The list of ingress endpoints.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mailmanager.model.AddonSubscription.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.mailmanager.model.AddonSubscription#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mailmanager.model.AddonSubscription.Builder#build()} is called
         * immediately and its result is passed to {@link #addonSubscriptions(List<AddonSubscription>)}.
         * 
         * @param addonSubscriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mailmanager.model.AddonSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addonSubscriptions(java.util.Collection<AddonSubscription>)
         */
        Builder addonSubscriptions(Consumer<AddonSubscription.Builder>... addonSubscriptions);

        /**
         * <p>
         * If NextToken is returned, there are more results available. The value of NextToken is a unique pagination
         * token for each page. Make the call again using the returned token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        If NextToken is returned, there are more results available. The value of NextToken is a unique
         *        pagination token for each page. Make the call again using the returned token to retrieve the next
         *        page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private List<AddonSubscription> addonSubscriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAddonSubscriptionsResponse model) {
            super(model);
            addonSubscriptions(model.addonSubscriptions);
            nextToken(model.nextToken);
        }

        public final List<AddonSubscription.Builder> getAddonSubscriptions() {
            List<AddonSubscription.Builder> result = AddonSubscriptionsCopier.copyToBuilder(this.addonSubscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddonSubscriptions(Collection<AddonSubscription.BuilderImpl> addonSubscriptions) {
            this.addonSubscriptions = AddonSubscriptionsCopier.copyFromBuilder(addonSubscriptions);
        }

        @Override
        public final Builder addonSubscriptions(Collection<AddonSubscription> addonSubscriptions) {
            this.addonSubscriptions = AddonSubscriptionsCopier.copy(addonSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonSubscriptions(AddonSubscription... addonSubscriptions) {
            addonSubscriptions(Arrays.asList(addonSubscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addonSubscriptions(Consumer<AddonSubscription.Builder>... addonSubscriptions) {
            addonSubscriptions(Stream.of(addonSubscriptions).map(c -> AddonSubscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAddonSubscriptionsResponse build() {
            return new ListAddonSubscriptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
