/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The textual body content of an email message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageBody implements SdkPojo, Serializable, ToCopyableBuilder<MessageBody.Builder, MessageBody> {
    private static final SdkField<String> HTML_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Html")
            .getter(getter(MessageBody::html)).setter(setter(Builder::html))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Html").build()).build();

    private static final SdkField<Boolean> MESSAGE_MALFORMED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MessageMalformed").getter(getter(MessageBody::messageMalformed))
            .setter(setter(Builder::messageMalformed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageMalformed").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(MessageBody::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTML_FIELD,
            MESSAGE_MALFORMED_FIELD, TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String html;

    private final Boolean messageMalformed;

    private final String text;

    private MessageBody(BuilderImpl builder) {
        this.html = builder.html;
        this.messageMalformed = builder.messageMalformed;
        this.text = builder.text;
    }

    /**
     * <p>
     * The HTML body content of the message.
     * </p>
     * 
     * @return The HTML body content of the message.
     */
    public final String html() {
        return html;
    }

    /**
     * <p>
     * A flag indicating if the email was malformed.
     * </p>
     * 
     * @return A flag indicating if the email was malformed.
     */
    public final Boolean messageMalformed() {
        return messageMalformed;
    }

    /**
     * <p>
     * The plain text body content of the message.
     * </p>
     * 
     * @return The plain text body content of the message.
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(html());
        hashCode = 31 * hashCode + Objects.hashCode(messageMalformed());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageBody)) {
            return false;
        }
        MessageBody other = (MessageBody) obj;
        return Objects.equals(html(), other.html()) && Objects.equals(messageMalformed(), other.messageMalformed())
                && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageBody").add("Html", html()).add("MessageMalformed", messageMalformed())
                .add("Text", text()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Html":
            return Optional.ofNullable(clazz.cast(html()));
        case "MessageMalformed":
            return Optional.ofNullable(clazz.cast(messageMalformed()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MessageBody, T> g) {
        return obj -> g.apply((MessageBody) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageBody> {
        /**
         * <p>
         * The HTML body content of the message.
         * </p>
         * 
         * @param html
         *        The HTML body content of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder html(String html);

        /**
         * <p>
         * A flag indicating if the email was malformed.
         * </p>
         * 
         * @param messageMalformed
         *        A flag indicating if the email was malformed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageMalformed(Boolean messageMalformed);

        /**
         * <p>
         * The plain text body content of the message.
         * </p>
         * 
         * @param text
         *        The plain text body content of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);
    }

    static final class BuilderImpl implements Builder {
        private String html;

        private Boolean messageMalformed;

        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageBody model) {
            html(model.html);
            messageMalformed(model.messageMalformed);
            text(model.text);
        }

        public final String getHtml() {
            return html;
        }

        public final void setHtml(String html) {
            this.html = html;
        }

        @Override
        public final Builder html(String html) {
            this.html = html;
            return this;
        }

        public final Boolean getMessageMalformed() {
            return messageMalformed;
        }

        public final void setMessageMalformed(Boolean messageMalformed) {
            this.messageMalformed = messageMalformed;
        }

        @Override
        public final Builder messageMalformed(Boolean messageMalformed) {
            this.messageMalformed = messageMalformed;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public MessageBody build() {
            return new MessageBody(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
