/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A result row containing metadata for an archived email message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Row implements SdkPojo, Serializable, ToCopyableBuilder<Row.Builder, Row> {
    private static final SdkField<String> ARCHIVED_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchivedMessageId").getter(getter(Row::archivedMessageId)).setter(setter(Builder::archivedMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivedMessageId").build()).build();

    private static final SdkField<String> CC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cc")
            .getter(getter(Row::cc)).setter(setter(Builder::cc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cc").build()).build();

    private static final SdkField<String> DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Date")
            .getter(getter(Row::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()).build();

    private static final SdkField<String> FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("From")
            .getter(getter(Row::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()).build();

    private static final SdkField<Boolean> HAS_ATTACHMENTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasAttachments").getter(getter(Row::hasAttachments)).setter(setter(Builder::hasAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasAttachments").build()).build();

    private static final SdkField<String> IN_REPLY_TO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InReplyTo").getter(getter(Row::inReplyTo)).setter(setter(Builder::inReplyTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InReplyTo").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(Row::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<List<String>> RECEIVED_HEADERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReceivedHeaders")
            .getter(getter(Row::receivedHeaders))
            .setter(setter(Builder::receivedHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> RECEIVED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReceivedTimestamp").getter(getter(Row::receivedTimestamp)).setter(setter(Builder::receivedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedTimestamp").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(Row::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> TO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("To")
            .getter(getter(Row::to)).setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").build()).build();

    private static final SdkField<String> X_MAILER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XMailer").getter(getter(Row::xMailer)).setter(setter(Builder::xMailer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XMailer").build()).build();

    private static final SdkField<String> X_ORIGINAL_MAILER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XOriginalMailer").getter(getter(Row::xOriginalMailer)).setter(setter(Builder::xOriginalMailer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XOriginalMailer").build()).build();

    private static final SdkField<String> X_PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XPriority").getter(getter(Row::xPriority)).setter(setter(Builder::xPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XPriority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVED_MESSAGE_ID_FIELD,
            CC_FIELD, DATE_FIELD, FROM_FIELD, HAS_ATTACHMENTS_FIELD, IN_REPLY_TO_FIELD, MESSAGE_ID_FIELD, RECEIVED_HEADERS_FIELD,
            RECEIVED_TIMESTAMP_FIELD, SUBJECT_FIELD, TO_FIELD, X_MAILER_FIELD, X_ORIGINAL_MAILER_FIELD, X_PRIORITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String archivedMessageId;

    private final String cc;

    private final String date;

    private final String from;

    private final Boolean hasAttachments;

    private final String inReplyTo;

    private final String messageId;

    private final List<String> receivedHeaders;

    private final Instant receivedTimestamp;

    private final String subject;

    private final String to;

    private final String xMailer;

    private final String xOriginalMailer;

    private final String xPriority;

    private Row(BuilderImpl builder) {
        this.archivedMessageId = builder.archivedMessageId;
        this.cc = builder.cc;
        this.date = builder.date;
        this.from = builder.from;
        this.hasAttachments = builder.hasAttachments;
        this.inReplyTo = builder.inReplyTo;
        this.messageId = builder.messageId;
        this.receivedHeaders = builder.receivedHeaders;
        this.receivedTimestamp = builder.receivedTimestamp;
        this.subject = builder.subject;
        this.to = builder.to;
        this.xMailer = builder.xMailer;
        this.xOriginalMailer = builder.xOriginalMailer;
        this.xPriority = builder.xPriority;
    }

    /**
     * <p>
     * The unique identifier of the archived message.
     * </p>
     * 
     * @return The unique identifier of the archived message.
     */
    public final String archivedMessageId() {
        return archivedMessageId;
    }

    /**
     * <p>
     * The email addresses in the CC header.
     * </p>
     * 
     * @return The email addresses in the CC header.
     */
    public final String cc() {
        return cc;
    }

    /**
     * <p>
     * The date the email was sent.
     * </p>
     * 
     * @return The date the email was sent.
     */
    public final String date() {
        return date;
    }

    /**
     * <p>
     * The email address of the sender.
     * </p>
     * 
     * @return The email address of the sender.
     */
    public final String from() {
        return from;
    }

    /**
     * <p>
     * A flag indicating if the email has attachments.
     * </p>
     * 
     * @return A flag indicating if the email has attachments.
     */
    public final Boolean hasAttachments() {
        return hasAttachments;
    }

    /**
     * <p>
     * The email message ID this is a reply to.
     * </p>
     * 
     * @return The email message ID this is a reply to.
     */
    public final String inReplyTo() {
        return inReplyTo;
    }

    /**
     * <p>
     * The unique message ID of the email.
     * </p>
     * 
     * @return The unique message ID of the email.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReceivedHeaders property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReceivedHeaders() {
        return receivedHeaders != null && !(receivedHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The received headers from the email delivery path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReceivedHeaders} method.
     * </p>
     * 
     * @return The received headers from the email delivery path.
     */
    public final List<String> receivedHeaders() {
        return receivedHeaders;
    }

    /**
     * <p>
     * The timestamp of when the email was received.
     * </p>
     * 
     * @return The timestamp of when the email was received.
     */
    public final Instant receivedTimestamp() {
        return receivedTimestamp;
    }

    /**
     * <p>
     * The subject header value of the email.
     * </p>
     * 
     * @return The subject header value of the email.
     */
    public final String subject() {
        return subject;
    }

    /**
     * <p>
     * The email addresses in the To header.
     * </p>
     * 
     * @return The email addresses in the To header.
     */
    public final String to() {
        return to;
    }

    /**
     * <p>
     * The user agent that sent the email.
     * </p>
     * 
     * @return The user agent that sent the email.
     */
    public final String xMailer() {
        return xMailer;
    }

    /**
     * <p>
     * The original user agent that sent the email.
     * </p>
     * 
     * @return The original user agent that sent the email.
     */
    public final String xOriginalMailer() {
        return xOriginalMailer;
    }

    /**
     * <p>
     * The priority level of the email.
     * </p>
     * 
     * @return The priority level of the email.
     */
    public final String xPriority() {
        return xPriority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(archivedMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(cc());
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(inReplyTo());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasReceivedHeaders() ? receivedHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(receivedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        hashCode = 31 * hashCode + Objects.hashCode(xMailer());
        hashCode = 31 * hashCode + Objects.hashCode(xOriginalMailer());
        hashCode = 31 * hashCode + Objects.hashCode(xPriority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        Row other = (Row) obj;
        return Objects.equals(archivedMessageId(), other.archivedMessageId()) && Objects.equals(cc(), other.cc())
                && Objects.equals(date(), other.date()) && Objects.equals(from(), other.from())
                && Objects.equals(hasAttachments(), other.hasAttachments()) && Objects.equals(inReplyTo(), other.inReplyTo())
                && Objects.equals(messageId(), other.messageId()) && hasReceivedHeaders() == other.hasReceivedHeaders()
                && Objects.equals(receivedHeaders(), other.receivedHeaders())
                && Objects.equals(receivedTimestamp(), other.receivedTimestamp()) && Objects.equals(subject(), other.subject())
                && Objects.equals(to(), other.to()) && Objects.equals(xMailer(), other.xMailer())
                && Objects.equals(xOriginalMailer(), other.xOriginalMailer()) && Objects.equals(xPriority(), other.xPriority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Row").add("ArchivedMessageId", archivedMessageId()).add("Cc", cc()).add("Date", date())
                .add("From", from()).add("HasAttachments", hasAttachments()).add("InReplyTo", inReplyTo())
                .add("MessageId", messageId()).add("ReceivedHeaders", hasReceivedHeaders() ? receivedHeaders() : null)
                .add("ReceivedTimestamp", receivedTimestamp()).add("Subject", subject()).add("To", to())
                .add("XMailer", xMailer()).add("XOriginalMailer", xOriginalMailer()).add("XPriority", xPriority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchivedMessageId":
            return Optional.ofNullable(clazz.cast(archivedMessageId()));
        case "Cc":
            return Optional.ofNullable(clazz.cast(cc()));
        case "Date":
            return Optional.ofNullable(clazz.cast(date()));
        case "From":
            return Optional.ofNullable(clazz.cast(from()));
        case "HasAttachments":
            return Optional.ofNullable(clazz.cast(hasAttachments()));
        case "InReplyTo":
            return Optional.ofNullable(clazz.cast(inReplyTo()));
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "ReceivedHeaders":
            return Optional.ofNullable(clazz.cast(receivedHeaders()));
        case "ReceivedTimestamp":
            return Optional.ofNullable(clazz.cast(receivedTimestamp()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "To":
            return Optional.ofNullable(clazz.cast(to()));
        case "XMailer":
            return Optional.ofNullable(clazz.cast(xMailer()));
        case "XOriginalMailer":
            return Optional.ofNullable(clazz.cast(xOriginalMailer()));
        case "XPriority":
            return Optional.ofNullable(clazz.cast(xPriority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Row, T> g) {
        return obj -> g.apply((Row) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Row> {
        /**
         * <p>
         * The unique identifier of the archived message.
         * </p>
         * 
         * @param archivedMessageId
         *        The unique identifier of the archived message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archivedMessageId(String archivedMessageId);

        /**
         * <p>
         * The email addresses in the CC header.
         * </p>
         * 
         * @param cc
         *        The email addresses in the CC header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cc(String cc);

        /**
         * <p>
         * The date the email was sent.
         * </p>
         * 
         * @param date
         *        The date the email was sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(String date);

        /**
         * <p>
         * The email address of the sender.
         * </p>
         * 
         * @param from
         *        The email address of the sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(String from);

        /**
         * <p>
         * A flag indicating if the email has attachments.
         * </p>
         * 
         * @param hasAttachments
         *        A flag indicating if the email has attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasAttachments(Boolean hasAttachments);

        /**
         * <p>
         * The email message ID this is a reply to.
         * </p>
         * 
         * @param inReplyTo
         *        The email message ID this is a reply to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inReplyTo(String inReplyTo);

        /**
         * <p>
         * The unique message ID of the email.
         * </p>
         * 
         * @param messageId
         *        The unique message ID of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The received headers from the email delivery path.
         * </p>
         * 
         * @param receivedHeaders
         *        The received headers from the email delivery path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receivedHeaders(Collection<String> receivedHeaders);

        /**
         * <p>
         * The received headers from the email delivery path.
         * </p>
         * 
         * @param receivedHeaders
         *        The received headers from the email delivery path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receivedHeaders(String... receivedHeaders);

        /**
         * <p>
         * The timestamp of when the email was received.
         * </p>
         * 
         * @param receivedTimestamp
         *        The timestamp of when the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receivedTimestamp(Instant receivedTimestamp);

        /**
         * <p>
         * The subject header value of the email.
         * </p>
         * 
         * @param subject
         *        The subject header value of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The email addresses in the To header.
         * </p>
         * 
         * @param to
         *        The email addresses in the To header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(String to);

        /**
         * <p>
         * The user agent that sent the email.
         * </p>
         * 
         * @param xMailer
         *        The user agent that sent the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xMailer(String xMailer);

        /**
         * <p>
         * The original user agent that sent the email.
         * </p>
         * 
         * @param xOriginalMailer
         *        The original user agent that sent the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xOriginalMailer(String xOriginalMailer);

        /**
         * <p>
         * The priority level of the email.
         * </p>
         * 
         * @param xPriority
         *        The priority level of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xPriority(String xPriority);
    }

    static final class BuilderImpl implements Builder {
        private String archivedMessageId;

        private String cc;

        private String date;

        private String from;

        private Boolean hasAttachments;

        private String inReplyTo;

        private String messageId;

        private List<String> receivedHeaders = DefaultSdkAutoConstructList.getInstance();

        private Instant receivedTimestamp;

        private String subject;

        private String to;

        private String xMailer;

        private String xOriginalMailer;

        private String xPriority;

        private BuilderImpl() {
        }

        private BuilderImpl(Row model) {
            archivedMessageId(model.archivedMessageId);
            cc(model.cc);
            date(model.date);
            from(model.from);
            hasAttachments(model.hasAttachments);
            inReplyTo(model.inReplyTo);
            messageId(model.messageId);
            receivedHeaders(model.receivedHeaders);
            receivedTimestamp(model.receivedTimestamp);
            subject(model.subject);
            to(model.to);
            xMailer(model.xMailer);
            xOriginalMailer(model.xOriginalMailer);
            xPriority(model.xPriority);
        }

        public final String getArchivedMessageId() {
            return archivedMessageId;
        }

        public final void setArchivedMessageId(String archivedMessageId) {
            this.archivedMessageId = archivedMessageId;
        }

        @Override
        public final Builder archivedMessageId(String archivedMessageId) {
            this.archivedMessageId = archivedMessageId;
            return this;
        }

        public final String getCc() {
            return cc;
        }

        public final void setCc(String cc) {
            this.cc = cc;
        }

        @Override
        public final Builder cc(String cc) {
            this.cc = cc;
            return this;
        }

        public final String getDate() {
            return date;
        }

        public final void setDate(String date) {
            this.date = date;
        }

        @Override
        public final Builder date(String date) {
            this.date = date;
            return this;
        }

        public final String getFrom() {
            return from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final Boolean getHasAttachments() {
            return hasAttachments;
        }

        public final void setHasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
        }

        @Override
        public final Builder hasAttachments(Boolean hasAttachments) {
            this.hasAttachments = hasAttachments;
            return this;
        }

        public final String getInReplyTo() {
            return inReplyTo;
        }

        public final void setInReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
        }

        @Override
        public final Builder inReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
            return this;
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final Collection<String> getReceivedHeaders() {
            if (receivedHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return receivedHeaders;
        }

        public final void setReceivedHeaders(Collection<String> receivedHeaders) {
            this.receivedHeaders = EmailReceivedHeadersListCopier.copy(receivedHeaders);
        }

        @Override
        public final Builder receivedHeaders(Collection<String> receivedHeaders) {
            this.receivedHeaders = EmailReceivedHeadersListCopier.copy(receivedHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receivedHeaders(String... receivedHeaders) {
            receivedHeaders(Arrays.asList(receivedHeaders));
            return this;
        }

        public final Instant getReceivedTimestamp() {
            return receivedTimestamp;
        }

        public final void setReceivedTimestamp(Instant receivedTimestamp) {
            this.receivedTimestamp = receivedTimestamp;
        }

        @Override
        public final Builder receivedTimestamp(Instant receivedTimestamp) {
            this.receivedTimestamp = receivedTimestamp;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getTo() {
            return to;
        }

        public final void setTo(String to) {
            this.to = to;
        }

        @Override
        public final Builder to(String to) {
            this.to = to;
            return this;
        }

        public final String getXMailer() {
            return xMailer;
        }

        public final void setXMailer(String xMailer) {
            this.xMailer = xMailer;
        }

        @Override
        public final Builder xMailer(String xMailer) {
            this.xMailer = xMailer;
            return this;
        }

        public final String getXOriginalMailer() {
            return xOriginalMailer;
        }

        public final void setXOriginalMailer(String xOriginalMailer) {
            this.xOriginalMailer = xOriginalMailer;
        }

        @Override
        public final Builder xOriginalMailer(String xOriginalMailer) {
            this.xOriginalMailer = xOriginalMailer;
            return this;
        }

        public final String getXPriority() {
            return xPriority;
        }

        public final void setXPriority(String xPriority) {
            this.xPriority = xPriority;
        }

        @Override
        public final Builder xPriority(String xPriority) {
            this.xPriority = xPriority;
            return this;
        }

        @Override
        public Row build() {
            return new Row(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
