/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number to evaluate in a numeric condition expression.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleNumberToEvaluate implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleNumberToEvaluate.Builder, RuleNumberToEvaluate> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Attribute").getter(getter(RuleNumberToEvaluate::attributeAsString)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final Type type;

    private RuleNumberToEvaluate(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.type = builder.type;
    }

    /**
     * <p>
     * An email attribute that is used as the number to evaluate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link RuleNumberEmailAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeAsString}.
     * </p>
     * 
     * @return An email attribute that is used as the number to evaluate.
     * @see RuleNumberEmailAttribute
     */
    public final RuleNumberEmailAttribute attribute() {
        return RuleNumberEmailAttribute.fromValue(attribute);
    }

    /**
     * <p>
     * An email attribute that is used as the number to evaluate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link RuleNumberEmailAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeAsString}.
     * </p>
     * 
     * @return An email attribute that is used as the number to evaluate.
     * @see RuleNumberEmailAttribute
     */
    public final String attributeAsString() {
        return attribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleNumberToEvaluate)) {
            return false;
        }
        RuleNumberToEvaluate other = (RuleNumberToEvaluate) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleNumberToEvaluate").add("Attribute", attributeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #attributeAsString()} initialized to the given value.
     *
     * <p>
     * An email attribute that is used as the number to evaluate.
     * </p>
     * 
     * @param attribute
     *        An email attribute that is used as the number to evaluate.
     * @see RuleNumberEmailAttribute
     */
    public static RuleNumberToEvaluate fromAttribute(String attribute) {
        return builder().attribute(attribute).build();
    }

    /**
     * Create an instance of this class with {@link #attributeAsString()} initialized to the given value.
     *
     * <p>
     * An email attribute that is used as the number to evaluate.
     * </p>
     * 
     * @param attribute
     *        An email attribute that is used as the number to evaluate.
     * @see RuleNumberEmailAttribute
     */
    public static RuleNumberToEvaluate fromAttribute(RuleNumberEmailAttribute attribute) {
        return builder().attribute(attribute).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleNumberToEvaluate, T> g) {
        return obj -> g.apply((RuleNumberToEvaluate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleNumberToEvaluate> {
        /**
         * <p>
         * An email attribute that is used as the number to evaluate.
         * </p>
         * 
         * @param attribute
         *        An email attribute that is used as the number to evaluate.
         * @see RuleNumberEmailAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleNumberEmailAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * An email attribute that is used as the number to evaluate.
         * </p>
         * 
         * @param attribute
         *        An email attribute that is used as the number to evaluate.
         * @see RuleNumberEmailAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleNumberEmailAttribute
         */
        Builder attribute(RuleNumberEmailAttribute attribute);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleNumberToEvaluate model) {
            attribute(model.attribute);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            Object oldValue = this.attribute;
            this.attribute = attribute;
            handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
        }

        @Override
        public final Builder attribute(String attribute) {
            Object oldValue = this.attribute;
            this.attribute = attribute;
            handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
            return this;
        }

        @Override
        public final Builder attribute(RuleNumberEmailAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        @Override
        public RuleNumberToEvaluate build() {
            return new RuleNumberToEvaluate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RuleNumberToEvaluate#type()
     */
    public enum Type {
        ATTRIBUTE,

        UNKNOWN_TO_SDK_VERSION
    }
}
