/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for exporting email data to an Amazon S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ExportDestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ExportDestinationConfiguration.Builder, S3ExportDestinationConfiguration> {
    private static final SdkField<String> S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Location").getter(getter(S3ExportDestinationConfiguration::s3Location))
            .setter(setter(Builder::s3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Location;

    private S3ExportDestinationConfiguration(BuilderImpl builder) {
        this.s3Location = builder.s3Location;
    }

    /**
     * <p>
     * The S3 location to deliver the exported email data.
     * </p>
     * 
     * @return The S3 location to deliver the exported email data.
     */
    public final String s3Location() {
        return s3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ExportDestinationConfiguration)) {
            return false;
        }
        S3ExportDestinationConfiguration other = (S3ExportDestinationConfiguration) obj;
        return Objects.equals(s3Location(), other.s3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ExportDestinationConfiguration").add("S3Location", s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ExportDestinationConfiguration, T> g) {
        return obj -> g.apply((S3ExportDestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ExportDestinationConfiguration> {
        /**
         * <p>
         * The S3 location to deliver the exported email data.
         * </p>
         * 
         * @param s3Location
         *        The S3 location to deliver the exported email data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(String s3Location);
    }

    static final class BuilderImpl implements Builder {
        private String s3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ExportDestinationConfiguration model) {
            s3Location(model.s3Location);
        }

        public final String getS3Location() {
            return s3Location;
        }

        public final void setS3Location(String s3Location) {
            this.s3Location = s3Location;
        }

        @Override
        public final Builder s3Location(String s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        @Override
        public S3ExportDestinationConfiguration build() {
            return new S3ExportDestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
