/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to initiate a search across emails in an archive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartArchiveSearchRequest extends MailManagerRequest implements
        ToCopyableBuilder<StartArchiveSearchRequest.Builder, StartArchiveSearchRequest> {
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveId").getter(getter(StartArchiveSearchRequest::archiveId)).setter(setter(Builder::archiveId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()).build();

    private static final SdkField<ArchiveFilters> FILTERS_FIELD = SdkField.<ArchiveFilters> builder(MarshallingType.SDK_POJO)
            .memberName("Filters").getter(getter(StartArchiveSearchRequest::filters)).setter(setter(Builder::filters))
            .constructor(ArchiveFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<Instant> FROM_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FromTimestamp").getter(getter(StartArchiveSearchRequest::fromTimestamp))
            .setter(setter(Builder::fromTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromTimestamp").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(StartArchiveSearchRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Instant> TO_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ToTimestamp").getter(getter(StartArchiveSearchRequest::toTimestamp))
            .setter(setter(Builder::toTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ID_FIELD,
            FILTERS_FIELD, FROM_TIMESTAMP_FIELD, MAX_RESULTS_FIELD, TO_TIMESTAMP_FIELD));

    private final String archiveId;

    private final ArchiveFilters filters;

    private final Instant fromTimestamp;

    private final Integer maxResults;

    private final Instant toTimestamp;

    private StartArchiveSearchRequest(BuilderImpl builder) {
        super(builder);
        this.archiveId = builder.archiveId;
        this.filters = builder.filters;
        this.fromTimestamp = builder.fromTimestamp;
        this.maxResults = builder.maxResults;
        this.toTimestamp = builder.toTimestamp;
    }

    /**
     * <p>
     * The identifier of the archive to search emails in.
     * </p>
     * 
     * @return The identifier of the archive to search emails in.
     */
    public final String archiveId() {
        return archiveId;
    }

    /**
     * <p>
     * Criteria to filter which emails are included in the search results.
     * </p>
     * 
     * @return Criteria to filter which emails are included in the search results.
     */
    public final ArchiveFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The start timestamp of the range to search emails from.
     * </p>
     * 
     * @return The start timestamp of the range to search emails from.
     */
    public final Instant fromTimestamp() {
        return fromTimestamp;
    }

    /**
     * <p>
     * The maximum number of search results to return.
     * </p>
     * 
     * @return The maximum number of search results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The end timestamp of the range to search emails from.
     * </p>
     * 
     * @return The end timestamp of the range to search emails from.
     */
    public final Instant toTimestamp() {
        return toTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(fromTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(toTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartArchiveSearchRequest)) {
            return false;
        }
        StartArchiveSearchRequest other = (StartArchiveSearchRequest) obj;
        return Objects.equals(archiveId(), other.archiveId()) && Objects.equals(filters(), other.filters())
                && Objects.equals(fromTimestamp(), other.fromTimestamp()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(toTimestamp(), other.toTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartArchiveSearchRequest").add("ArchiveId", archiveId()).add("Filters", filters())
                .add("FromTimestamp", fromTimestamp()).add("MaxResults", maxResults()).add("ToTimestamp", toTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveId":
            return Optional.ofNullable(clazz.cast(archiveId()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "FromTimestamp":
            return Optional.ofNullable(clazz.cast(fromTimestamp()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ToTimestamp":
            return Optional.ofNullable(clazz.cast(toTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartArchiveSearchRequest, T> g) {
        return obj -> g.apply((StartArchiveSearchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartArchiveSearchRequest> {
        /**
         * <p>
         * The identifier of the archive to search emails in.
         * </p>
         * 
         * @param archiveId
         *        The identifier of the archive to search emails in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveId(String archiveId);

        /**
         * <p>
         * Criteria to filter which emails are included in the search results.
         * </p>
         * 
         * @param filters
         *        Criteria to filter which emails are included in the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ArchiveFilters filters);

        /**
         * <p>
         * Criteria to filter which emails are included in the search results.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArchiveFilters.Builder} avoiding the need
         * to create one manually via {@link ArchiveFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchiveFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(ArchiveFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ArchiveFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ArchiveFilters)
         */
        default Builder filters(Consumer<ArchiveFilters.Builder> filters) {
            return filters(ArchiveFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The start timestamp of the range to search emails from.
         * </p>
         * 
         * @param fromTimestamp
         *        The start timestamp of the range to search emails from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromTimestamp(Instant fromTimestamp);

        /**
         * <p>
         * The maximum number of search results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of search results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The end timestamp of the range to search emails from.
         * </p>
         * 
         * @param toTimestamp
         *        The end timestamp of the range to search emails from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toTimestamp(Instant toTimestamp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MailManagerRequest.BuilderImpl implements Builder {
        private String archiveId;

        private ArchiveFilters filters;

        private Instant fromTimestamp;

        private Integer maxResults;

        private Instant toTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StartArchiveSearchRequest model) {
            super(model);
            archiveId(model.archiveId);
            filters(model.filters);
            fromTimestamp(model.fromTimestamp);
            maxResults(model.maxResults);
            toTimestamp(model.toTimestamp);
        }

        public final String getArchiveId() {
            return archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final ArchiveFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ArchiveFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ArchiveFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Instant getFromTimestamp() {
            return fromTimestamp;
        }

        public final void setFromTimestamp(Instant fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
        }

        @Override
        public final Builder fromTimestamp(Instant fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getToTimestamp() {
            return toTimestamp;
        }

        public final void setToTimestamp(Instant toTimestamp) {
            this.toTimestamp = toTimestamp;
        }

        @Override
        public final Builder toTimestamp(Instant toTimestamp) {
            this.toTimestamp = toTimestamp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartArchiveSearchRequest build() {
            return new StartArchiveSearchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
