/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRelayRequest extends MailManagerRequest implements
        ToCopyableBuilder<UpdateRelayRequest.Builder, UpdateRelayRequest> {
    private static final SdkField<RelayAuthentication> AUTHENTICATION_FIELD = SdkField
            .<RelayAuthentication> builder(MarshallingType.SDK_POJO).memberName("Authentication")
            .getter(getter(UpdateRelayRequest::authentication)).setter(setter(Builder::authentication))
            .constructor(RelayAuthentication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").build()).build();

    private static final SdkField<String> RELAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelayId").getter(getter(UpdateRelayRequest::relayId)).setter(setter(Builder::relayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayId").build()).build();

    private static final SdkField<String> RELAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelayName").getter(getter(UpdateRelayRequest::relayName)).setter(setter(Builder::relayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayName").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(UpdateRelayRequest::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<Integer> SERVER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ServerPort").getter(getter(UpdateRelayRequest::serverPort)).setter(setter(Builder::serverPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_FIELD,
            RELAY_ID_FIELD, RELAY_NAME_FIELD, SERVER_NAME_FIELD, SERVER_PORT_FIELD));

    private final RelayAuthentication authentication;

    private final String relayId;

    private final String relayName;

    private final String serverName;

    private final Integer serverPort;

    private UpdateRelayRequest(BuilderImpl builder) {
        super(builder);
        this.authentication = builder.authentication;
        this.relayId = builder.relayId;
        this.relayName = builder.relayName;
        this.serverName = builder.serverName;
        this.serverPort = builder.serverPort;
    }

    /**
     * <p>
     * Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored.
     * </p>
     * 
     * @return Authentication for the relay destination server—specify the secretARN where the SMTP credentials are
     *         stored.
     */
    public final RelayAuthentication authentication() {
        return authentication;
    }

    /**
     * <p>
     * The unique relay identifier.
     * </p>
     * 
     * @return The unique relay identifier.
     */
    public final String relayId() {
        return relayId;
    }

    /**
     * <p>
     * The name of the relay resource.
     * </p>
     * 
     * @return The name of the relay resource.
     */
    public final String relayName() {
        return relayName;
    }

    /**
     * <p>
     * The destination relay server address.
     * </p>
     * 
     * @return The destination relay server address.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The destination relay server port.
     * </p>
     * 
     * @return The destination relay server port.
     */
    public final Integer serverPort() {
        return serverPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authentication());
        hashCode = 31 * hashCode + Objects.hashCode(relayId());
        hashCode = 31 * hashCode + Objects.hashCode(relayName());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(serverPort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRelayRequest)) {
            return false;
        }
        UpdateRelayRequest other = (UpdateRelayRequest) obj;
        return Objects.equals(authentication(), other.authentication()) && Objects.equals(relayId(), other.relayId())
                && Objects.equals(relayName(), other.relayName()) && Objects.equals(serverName(), other.serverName())
                && Objects.equals(serverPort(), other.serverPort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRelayRequest").add("Authentication", authentication()).add("RelayId", relayId())
                .add("RelayName", relayName()).add("ServerName", serverName()).add("ServerPort", serverPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Authentication":
            return Optional.ofNullable(clazz.cast(authentication()));
        case "RelayId":
            return Optional.ofNullable(clazz.cast(relayId()));
        case "RelayName":
            return Optional.ofNullable(clazz.cast(relayName()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "ServerPort":
            return Optional.ofNullable(clazz.cast(serverPort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRelayRequest, T> g) {
        return obj -> g.apply((UpdateRelayRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRelayRequest> {
        /**
         * <p>
         * Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored.
         * </p>
         * 
         * @param authentication
         *        Authentication for the relay destination server—specify the secretARN where the SMTP credentials are
         *        stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authentication(RelayAuthentication authentication);

        /**
         * <p>
         * Authentication for the relay destination server—specify the secretARN where the SMTP credentials are stored.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelayAuthentication.Builder} avoiding the
         * need to create one manually via {@link RelayAuthentication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelayAuthentication.Builder#build()} is called immediately and
         * its result is passed to {@link #authentication(RelayAuthentication)}.
         * 
         * @param authentication
         *        a consumer that will call methods on {@link RelayAuthentication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authentication(RelayAuthentication)
         */
        default Builder authentication(Consumer<RelayAuthentication.Builder> authentication) {
            return authentication(RelayAuthentication.builder().applyMutation(authentication).build());
        }

        /**
         * <p>
         * The unique relay identifier.
         * </p>
         * 
         * @param relayId
         *        The unique relay identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relayId(String relayId);

        /**
         * <p>
         * The name of the relay resource.
         * </p>
         * 
         * @param relayName
         *        The name of the relay resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relayName(String relayName);

        /**
         * <p>
         * The destination relay server address.
         * </p>
         * 
         * @param serverName
         *        The destination relay server address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The destination relay server port.
         * </p>
         * 
         * @param serverPort
         *        The destination relay server port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverPort(Integer serverPort);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MailManagerRequest.BuilderImpl implements Builder {
        private RelayAuthentication authentication;

        private String relayId;

        private String relayName;

        private String serverName;

        private Integer serverPort;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRelayRequest model) {
            super(model);
            authentication(model.authentication);
            relayId(model.relayId);
            relayName(model.relayName);
            serverName(model.serverName);
            serverPort(model.serverPort);
        }

        public final RelayAuthentication.Builder getAuthentication() {
            return authentication != null ? authentication.toBuilder() : null;
        }

        public final void setAuthentication(RelayAuthentication.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        @Override
        public final Builder authentication(RelayAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getRelayId() {
            return relayId;
        }

        public final void setRelayId(String relayId) {
            this.relayId = relayId;
        }

        @Override
        public final Builder relayId(String relayId) {
            this.relayId = relayId;
            return this;
        }

        public final String getRelayName() {
            return relayName;
        }

        public final void setRelayName(String relayName) {
            this.relayName = relayName;
        }

        @Override
        public final Builder relayName(String relayName) {
            this.relayName = relayName;
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getServerPort() {
            return serverPort;
        }

        public final void setServerPort(Integer serverPort) {
            this.serverPort = serverPort;
        }

        @Override
        public final Builder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRelayRequest build() {
            return new UpdateRelayRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
