/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response containing details of the specified archive export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetArchiveExportResponse extends MailManagerResponse implements
        ToCopyableBuilder<GetArchiveExportResponse.Builder, GetArchiveExportResponse> {
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveId").getter(getter(GetArchiveExportResponse::archiveId)).setter(setter(Builder::archiveId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()).build();

    private static final SdkField<ExportDestinationConfiguration> EXPORT_DESTINATION_CONFIGURATION_FIELD = SdkField
            .<ExportDestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ExportDestinationConfiguration")
            .getter(getter(GetArchiveExportResponse::exportDestinationConfiguration))
            .setter(setter(Builder::exportDestinationConfiguration))
            .constructor(ExportDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDestinationConfiguration")
                    .build()).build();

    private static final SdkField<ArchiveFilters> FILTERS_FIELD = SdkField.<ArchiveFilters> builder(MarshallingType.SDK_POJO)
            .memberName("Filters").getter(getter(GetArchiveExportResponse::filters)).setter(setter(Builder::filters))
            .constructor(ArchiveFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<Instant> FROM_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FromTimestamp").getter(getter(GetArchiveExportResponse::fromTimestamp))
            .setter(setter(Builder::fromTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromTimestamp").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetArchiveExportResponse::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<ExportStatus> STATUS_FIELD = SdkField.<ExportStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(GetArchiveExportResponse::status)).setter(setter(Builder::status))
            .constructor(ExportStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> TO_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ToTimestamp").getter(getter(GetArchiveExportResponse::toTimestamp)).setter(setter(Builder::toTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ID_FIELD,
            EXPORT_DESTINATION_CONFIGURATION_FIELD, FILTERS_FIELD, FROM_TIMESTAMP_FIELD, MAX_RESULTS_FIELD, STATUS_FIELD,
            TO_TIMESTAMP_FIELD));

    private final String archiveId;

    private final ExportDestinationConfiguration exportDestinationConfiguration;

    private final ArchiveFilters filters;

    private final Instant fromTimestamp;

    private final Integer maxResults;

    private final ExportStatus status;

    private final Instant toTimestamp;

    private GetArchiveExportResponse(BuilderImpl builder) {
        super(builder);
        this.archiveId = builder.archiveId;
        this.exportDestinationConfiguration = builder.exportDestinationConfiguration;
        this.filters = builder.filters;
        this.fromTimestamp = builder.fromTimestamp;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
        this.toTimestamp = builder.toTimestamp;
    }

    /**
     * <p>
     * The identifier of the archive the email export was performed from.
     * </p>
     * 
     * @return The identifier of the archive the email export was performed from.
     */
    public final String archiveId() {
        return archiveId;
    }

    /**
     * <p>
     * Where the exported emails are being delivered.
     * </p>
     * 
     * @return Where the exported emails are being delivered.
     */
    public final ExportDestinationConfiguration exportDestinationConfiguration() {
        return exportDestinationConfiguration;
    }

    /**
     * <p>
     * The criteria used to filter emails included in the export.
     * </p>
     * 
     * @return The criteria used to filter emails included in the export.
     */
    public final ArchiveFilters filters() {
        return filters;
    }

    /**
     * <p>
     * The start of the timestamp range the exported emails cover.
     * </p>
     * 
     * @return The start of the timestamp range the exported emails cover.
     */
    public final Instant fromTimestamp() {
        return fromTimestamp;
    }

    /**
     * <p>
     * The maximum number of email items included in the export.
     * </p>
     * 
     * @return The maximum number of email items included in the export.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The current status of the export job.
     * </p>
     * 
     * @return The current status of the export job.
     */
    public final ExportStatus status() {
        return status;
    }

    /**
     * <p>
     * The end of the date range the exported emails cover.
     * </p>
     * 
     * @return The end of the date range the exported emails cover.
     */
    public final Instant toTimestamp() {
        return toTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(exportDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(fromTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(toTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveExportResponse)) {
            return false;
        }
        GetArchiveExportResponse other = (GetArchiveExportResponse) obj;
        return Objects.equals(archiveId(), other.archiveId())
                && Objects.equals(exportDestinationConfiguration(), other.exportDestinationConfiguration())
                && Objects.equals(filters(), other.filters()) && Objects.equals(fromTimestamp(), other.fromTimestamp())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(status(), other.status())
                && Objects.equals(toTimestamp(), other.toTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetArchiveExportResponse").add("ArchiveId", archiveId())
                .add("ExportDestinationConfiguration", exportDestinationConfiguration()).add("Filters", filters())
                .add("FromTimestamp", fromTimestamp()).add("MaxResults", maxResults()).add("Status", status())
                .add("ToTimestamp", toTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveId":
            return Optional.ofNullable(clazz.cast(archiveId()));
        case "ExportDestinationConfiguration":
            return Optional.ofNullable(clazz.cast(exportDestinationConfiguration()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "FromTimestamp":
            return Optional.ofNullable(clazz.cast(fromTimestamp()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ToTimestamp":
            return Optional.ofNullable(clazz.cast(toTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveExportResponse, T> g) {
        return obj -> g.apply((GetArchiveExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetArchiveExportResponse> {
        /**
         * <p>
         * The identifier of the archive the email export was performed from.
         * </p>
         * 
         * @param archiveId
         *        The identifier of the archive the email export was performed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveId(String archiveId);

        /**
         * <p>
         * Where the exported emails are being delivered.
         * </p>
         * 
         * @param exportDestinationConfiguration
         *        Where the exported emails are being delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDestinationConfiguration(ExportDestinationConfiguration exportDestinationConfiguration);

        /**
         * <p>
         * Where the exported emails are being delivered.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportDestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExportDestinationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #exportDestinationConfiguration(ExportDestinationConfiguration)}.
         * 
         * @param exportDestinationConfiguration
         *        a consumer that will call methods on {@link ExportDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportDestinationConfiguration(ExportDestinationConfiguration)
         */
        default Builder exportDestinationConfiguration(
                Consumer<ExportDestinationConfiguration.Builder> exportDestinationConfiguration) {
            return exportDestinationConfiguration(ExportDestinationConfiguration.builder()
                    .applyMutation(exportDestinationConfiguration).build());
        }

        /**
         * <p>
         * The criteria used to filter emails included in the export.
         * </p>
         * 
         * @param filters
         *        The criteria used to filter emails included in the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ArchiveFilters filters);

        /**
         * <p>
         * The criteria used to filter emails included in the export.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArchiveFilters.Builder} avoiding the need
         * to create one manually via {@link ArchiveFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchiveFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(ArchiveFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ArchiveFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ArchiveFilters)
         */
        default Builder filters(Consumer<ArchiveFilters.Builder> filters) {
            return filters(ArchiveFilters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The start of the timestamp range the exported emails cover.
         * </p>
         * 
         * @param fromTimestamp
         *        The start of the timestamp range the exported emails cover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromTimestamp(Instant fromTimestamp);

        /**
         * <p>
         * The maximum number of email items included in the export.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of email items included in the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The current status of the export job.
         * </p>
         * 
         * @param status
         *        The current status of the export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ExportStatus status);

        /**
         * <p>
         * The current status of the export job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportStatus.Builder} avoiding the need
         * to create one manually via {@link ExportStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(ExportStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ExportStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ExportStatus)
         */
        default Builder status(Consumer<ExportStatus.Builder> status) {
            return status(ExportStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The end of the date range the exported emails cover.
         * </p>
         * 
         * @param toTimestamp
         *        The end of the date range the exported emails cover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toTimestamp(Instant toTimestamp);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private String archiveId;

        private ExportDestinationConfiguration exportDestinationConfiguration;

        private ArchiveFilters filters;

        private Instant fromTimestamp;

        private Integer maxResults;

        private ExportStatus status;

        private Instant toTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveExportResponse model) {
            super(model);
            archiveId(model.archiveId);
            exportDestinationConfiguration(model.exportDestinationConfiguration);
            filters(model.filters);
            fromTimestamp(model.fromTimestamp);
            maxResults(model.maxResults);
            status(model.status);
            toTimestamp(model.toTimestamp);
        }

        public final String getArchiveId() {
            return archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final ExportDestinationConfiguration.Builder getExportDestinationConfiguration() {
            return exportDestinationConfiguration != null ? exportDestinationConfiguration.toBuilder() : null;
        }

        public final void setExportDestinationConfiguration(
                ExportDestinationConfiguration.BuilderImpl exportDestinationConfiguration) {
            this.exportDestinationConfiguration = exportDestinationConfiguration != null ? exportDestinationConfiguration.build()
                    : null;
        }

        @Override
        public final Builder exportDestinationConfiguration(ExportDestinationConfiguration exportDestinationConfiguration) {
            this.exportDestinationConfiguration = exportDestinationConfiguration;
            return this;
        }

        public final ArchiveFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ArchiveFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ArchiveFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Instant getFromTimestamp() {
            return fromTimestamp;
        }

        public final void setFromTimestamp(Instant fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
        }

        @Override
        public final Builder fromTimestamp(Instant fromTimestamp) {
            this.fromTimestamp = fromTimestamp;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ExportStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ExportStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ExportStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getToTimestamp() {
            return toTimestamp;
        }

        public final void setToTimestamp(Instant toTimestamp) {
            this.toTimestamp = toTimestamp;
        }

        @Override
        public final Builder toTimestamp(Instant toTimestamp) {
            this.toTimestamp = toTimestamp;
            return this;
        }

        @Override
        public GetArchiveExportResponse build() {
            return new GetArchiveExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
