/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response containing details about the requested archived email message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetArchiveMessageResponse extends MailManagerResponse implements
        ToCopyableBuilder<GetArchiveMessageResponse.Builder, GetArchiveMessageResponse> {
    private static final SdkField<String> MESSAGE_DOWNLOAD_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageDownloadLink").getter(getter(GetArchiveMessageResponse::messageDownloadLink))
            .setter(setter(Builder::messageDownloadLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageDownloadLink").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_DOWNLOAD_LINK_FIELD));

    private final String messageDownloadLink;

    private GetArchiveMessageResponse(BuilderImpl builder) {
        super(builder);
        this.messageDownloadLink = builder.messageDownloadLink;
    }

    /**
     * <p>
     * A pre-signed URL to temporarily download the full message content.
     * </p>
     * 
     * @return A pre-signed URL to temporarily download the full message content.
     */
    public final String messageDownloadLink() {
        return messageDownloadLink;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(messageDownloadLink());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveMessageResponse)) {
            return false;
        }
        GetArchiveMessageResponse other = (GetArchiveMessageResponse) obj;
        return Objects.equals(messageDownloadLink(), other.messageDownloadLink());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetArchiveMessageResponse").add("MessageDownloadLink", messageDownloadLink()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageDownloadLink":
            return Optional.ofNullable(clazz.cast(messageDownloadLink()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveMessageResponse, T> g) {
        return obj -> g.apply((GetArchiveMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetArchiveMessageResponse> {
        /**
         * <p>
         * A pre-signed URL to temporarily download the full message content.
         * </p>
         * 
         * @param messageDownloadLink
         *        A pre-signed URL to temporarily download the full message content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageDownloadLink(String messageDownloadLink);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private String messageDownloadLink;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveMessageResponse model) {
            super(model);
            messageDownloadLink(model.messageDownloadLink);
        }

        public final String getMessageDownloadLink() {
            return messageDownloadLink;
        }

        public final void setMessageDownloadLink(String messageDownloadLink) {
            this.messageDownloadLink = messageDownloadLink;
        }

        @Override
        public final Builder messageDownloadLink(String messageDownloadLink) {
            this.messageDownloadLink = messageDownloadLink;
            return this;
        }

        @Override
        public GetArchiveMessageResponse build() {
            return new GetArchiveMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
