/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The email traffic filtering conditions which are contained in a traffic policy resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyCondition implements SdkPojo, Serializable, ToCopyableBuilder<PolicyCondition.Builder, PolicyCondition> {
    private static final SdkField<IngressBooleanExpression> BOOLEAN_EXPRESSION_FIELD = SdkField
            .<IngressBooleanExpression> builder(MarshallingType.SDK_POJO).memberName("BooleanExpression")
            .getter(getter(PolicyCondition::booleanExpression)).setter(setter(Builder::booleanExpression))
            .constructor(IngressBooleanExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanExpression").build()).build();

    private static final SdkField<IngressIpv4Expression> IP_EXPRESSION_FIELD = SdkField
            .<IngressIpv4Expression> builder(MarshallingType.SDK_POJO).memberName("IpExpression")
            .getter(getter(PolicyCondition::ipExpression)).setter(setter(Builder::ipExpression))
            .constructor(IngressIpv4Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpExpression").build()).build();

    private static final SdkField<IngressStringExpression> STRING_EXPRESSION_FIELD = SdkField
            .<IngressStringExpression> builder(MarshallingType.SDK_POJO).memberName("StringExpression")
            .getter(getter(PolicyCondition::stringExpression)).setter(setter(Builder::stringExpression))
            .constructor(IngressStringExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringExpression").build()).build();

    private static final SdkField<IngressTlsProtocolExpression> TLS_EXPRESSION_FIELD = SdkField
            .<IngressTlsProtocolExpression> builder(MarshallingType.SDK_POJO).memberName("TlsExpression")
            .getter(getter(PolicyCondition::tlsExpression)).setter(setter(Builder::tlsExpression))
            .constructor(IngressTlsProtocolExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsExpression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_EXPRESSION_FIELD,
            IP_EXPRESSION_FIELD, STRING_EXPRESSION_FIELD, TLS_EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final IngressBooleanExpression booleanExpression;

    private final IngressIpv4Expression ipExpression;

    private final IngressStringExpression stringExpression;

    private final IngressTlsProtocolExpression tlsExpression;

    private final Type type;

    private PolicyCondition(BuilderImpl builder) {
        this.booleanExpression = builder.booleanExpression;
        this.ipExpression = builder.ipExpression;
        this.stringExpression = builder.stringExpression;
        this.tlsExpression = builder.tlsExpression;
        this.type = builder.type;
    }

    /**
     * <p>
     * This represents a boolean type condition matching on the incoming mail. It performs the boolean operation
     * configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     * </p>
     * 
     * @return This represents a boolean type condition matching on the incoming mail. It performs the boolean operation
     *         configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     */
    public final IngressBooleanExpression booleanExpression() {
        return booleanExpression;
    }

    /**
     * <p>
     * This represents an IP based condition matching on the incoming mail. It performs the operation configured in
     * 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     * </p>
     * 
     * @return This represents an IP based condition matching on the incoming mail. It performs the operation configured
     *         in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     */
    public final IngressIpv4Expression ipExpression() {
        return ipExpression;
    }

    /**
     * <p>
     * This represents a string based condition matching on the incoming mail. It performs the string operation
     * configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     * </p>
     * 
     * @return This represents a string based condition matching on the incoming mail. It performs the string operation
     *         configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     */
    public final IngressStringExpression stringExpression() {
        return stringExpression;
    }

    /**
     * <p>
     * This represents a TLS based condition matching on the incoming mail. It performs the operation configured in
     * 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     * </p>
     * 
     * @return This represents a TLS based condition matching on the incoming mail. It performs the operation configured
     *         in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     */
    public final IngressTlsProtocolExpression tlsExpression() {
        return tlsExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(booleanExpression());
        hashCode = 31 * hashCode + Objects.hashCode(ipExpression());
        hashCode = 31 * hashCode + Objects.hashCode(stringExpression());
        hashCode = 31 * hashCode + Objects.hashCode(tlsExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyCondition)) {
            return false;
        }
        PolicyCondition other = (PolicyCondition) obj;
        return Objects.equals(booleanExpression(), other.booleanExpression())
                && Objects.equals(ipExpression(), other.ipExpression())
                && Objects.equals(stringExpression(), other.stringExpression())
                && Objects.equals(tlsExpression(), other.tlsExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyCondition").add("BooleanExpression", booleanExpression())
                .add("IpExpression", ipExpression()).add("StringExpression", stringExpression())
                .add("TlsExpression", tlsExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BooleanExpression":
            return Optional.ofNullable(clazz.cast(booleanExpression()));
        case "IpExpression":
            return Optional.ofNullable(clazz.cast(ipExpression()));
        case "StringExpression":
            return Optional.ofNullable(clazz.cast(stringExpression()));
        case "TlsExpression":
            return Optional.ofNullable(clazz.cast(tlsExpression()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #booleanExpression()} initialized to the given value.
     *
     * <p>
     * This represents a boolean type condition matching on the incoming mail. It performs the boolean operation
     * configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     * </p>
     * 
     * @param booleanExpression
     *        This represents a boolean type condition matching on the incoming mail. It performs the boolean operation
     *        configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     */
    public static PolicyCondition fromBooleanExpression(IngressBooleanExpression booleanExpression) {
        return builder().booleanExpression(booleanExpression).build();
    }

    /**
     * Create an instance of this class with {@link #booleanExpression()} initialized to the given value.
     *
     * <p>
     * This represents a boolean type condition matching on the incoming mail. It performs the boolean operation
     * configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     * </p>
     * 
     * @param booleanExpression
     *        This represents a boolean type condition matching on the incoming mail. It performs the boolean operation
     *        configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     */
    public static PolicyCondition fromBooleanExpression(Consumer<IngressBooleanExpression.Builder> booleanExpression) {
        IngressBooleanExpression.Builder builder = IngressBooleanExpression.builder();
        booleanExpression.accept(builder);
        return fromBooleanExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ipExpression()} initialized to the given value.
     *
     * <p>
     * This represents an IP based condition matching on the incoming mail. It performs the operation configured in
     * 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     * </p>
     * 
     * @param ipExpression
     *        This represents an IP based condition matching on the incoming mail. It performs the operation configured
     *        in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     */
    public static PolicyCondition fromIpExpression(IngressIpv4Expression ipExpression) {
        return builder().ipExpression(ipExpression).build();
    }

    /**
     * Create an instance of this class with {@link #ipExpression()} initialized to the given value.
     *
     * <p>
     * This represents an IP based condition matching on the incoming mail. It performs the operation configured in
     * 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     * </p>
     * 
     * @param ipExpression
     *        This represents an IP based condition matching on the incoming mail. It performs the operation configured
     *        in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     */
    public static PolicyCondition fromIpExpression(Consumer<IngressIpv4Expression.Builder> ipExpression) {
        IngressIpv4Expression.Builder builder = IngressIpv4Expression.builder();
        ipExpression.accept(builder);
        return fromIpExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #stringExpression()} initialized to the given value.
     *
     * <p>
     * This represents a string based condition matching on the incoming mail. It performs the string operation
     * configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     * </p>
     * 
     * @param stringExpression
     *        This represents a string based condition matching on the incoming mail. It performs the string operation
     *        configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     */
    public static PolicyCondition fromStringExpression(IngressStringExpression stringExpression) {
        return builder().stringExpression(stringExpression).build();
    }

    /**
     * Create an instance of this class with {@link #stringExpression()} initialized to the given value.
     *
     * <p>
     * This represents a string based condition matching on the incoming mail. It performs the string operation
     * configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     * </p>
     * 
     * @param stringExpression
     *        This represents a string based condition matching on the incoming mail. It performs the string operation
     *        configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     */
    public static PolicyCondition fromStringExpression(Consumer<IngressStringExpression.Builder> stringExpression) {
        IngressStringExpression.Builder builder = IngressStringExpression.builder();
        stringExpression.accept(builder);
        return fromStringExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tlsExpression()} initialized to the given value.
     *
     * <p>
     * This represents a TLS based condition matching on the incoming mail. It performs the operation configured in
     * 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     * </p>
     * 
     * @param tlsExpression
     *        This represents a TLS based condition matching on the incoming mail. It performs the operation configured
     *        in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     */
    public static PolicyCondition fromTlsExpression(IngressTlsProtocolExpression tlsExpression) {
        return builder().tlsExpression(tlsExpression).build();
    }

    /**
     * Create an instance of this class with {@link #tlsExpression()} initialized to the given value.
     *
     * <p>
     * This represents a TLS based condition matching on the incoming mail. It performs the operation configured in
     * 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     * </p>
     * 
     * @param tlsExpression
     *        This represents a TLS based condition matching on the incoming mail. It performs the operation configured
     *        in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
     */
    public static PolicyCondition fromTlsExpression(Consumer<IngressTlsProtocolExpression.Builder> tlsExpression) {
        IngressTlsProtocolExpression.Builder builder = IngressTlsProtocolExpression.builder();
        tlsExpression.accept(builder);
        return fromTlsExpression(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyCondition, T> g) {
        return obj -> g.apply((PolicyCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyCondition> {
        /**
         * <p>
         * This represents a boolean type condition matching on the incoming mail. It performs the boolean operation
         * configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * </p>
         * 
         * @param booleanExpression
         *        This represents a boolean type condition matching on the incoming mail. It performs the boolean
         *        operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanExpression(IngressBooleanExpression booleanExpression);

        /**
         * <p>
         * This represents a boolean type condition matching on the incoming mail. It performs the boolean operation
         * configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressBooleanExpression.Builder}
         * avoiding the need to create one manually via {@link IngressBooleanExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressBooleanExpression.Builder#build()} is called immediately
         * and its result is passed to {@link #booleanExpression(IngressBooleanExpression)}.
         * 
         * @param booleanExpression
         *        a consumer that will call methods on {@link IngressBooleanExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #booleanExpression(IngressBooleanExpression)
         */
        default Builder booleanExpression(Consumer<IngressBooleanExpression.Builder> booleanExpression) {
            return booleanExpression(IngressBooleanExpression.builder().applyMutation(booleanExpression).build());
        }

        /**
         * <p>
         * This represents an IP based condition matching on the incoming mail. It performs the operation configured in
         * 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * </p>
         * 
         * @param ipExpression
         *        This represents an IP based condition matching on the incoming mail. It performs the operation
         *        configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipExpression(IngressIpv4Expression ipExpression);

        /**
         * <p>
         * This represents an IP based condition matching on the incoming mail. It performs the operation configured in
         * 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressIpv4Expression.Builder} avoiding
         * the need to create one manually via {@link IngressIpv4Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressIpv4Expression.Builder#build()} is called immediately and
         * its result is passed to {@link #ipExpression(IngressIpv4Expression)}.
         * 
         * @param ipExpression
         *        a consumer that will call methods on {@link IngressIpv4Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipExpression(IngressIpv4Expression)
         */
        default Builder ipExpression(Consumer<IngressIpv4Expression.Builder> ipExpression) {
            return ipExpression(IngressIpv4Expression.builder().applyMutation(ipExpression).build());
        }

        /**
         * <p>
         * This represents a string based condition matching on the incoming mail. It performs the string operation
         * configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * </p>
         * 
         * @param stringExpression
         *        This represents a string based condition matching on the incoming mail. It performs the string
         *        operation configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringExpression(IngressStringExpression stringExpression);

        /**
         * <p>
         * This represents a string based condition matching on the incoming mail. It performs the string operation
         * configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressStringExpression.Builder} avoiding
         * the need to create one manually via {@link IngressStringExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressStringExpression.Builder#build()} is called immediately
         * and its result is passed to {@link #stringExpression(IngressStringExpression)}.
         * 
         * @param stringExpression
         *        a consumer that will call methods on {@link IngressStringExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringExpression(IngressStringExpression)
         */
        default Builder stringExpression(Consumer<IngressStringExpression.Builder> stringExpression) {
            return stringExpression(IngressStringExpression.builder().applyMutation(stringExpression).build());
        }

        /**
         * <p>
         * This represents a TLS based condition matching on the incoming mail. It performs the operation configured in
         * 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * </p>
         * 
         * @param tlsExpression
         *        This represents a TLS based condition matching on the incoming mail. It performs the operation
         *        configured in 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsExpression(IngressTlsProtocolExpression tlsExpression);

        /**
         * <p>
         * This represents a TLS based condition matching on the incoming mail. It performs the operation configured in
         * 'Operator' and evaluates the 'Protocol' object against the 'Value'.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressTlsProtocolExpression.Builder}
         * avoiding the need to create one manually via {@link IngressTlsProtocolExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressTlsProtocolExpression.Builder#build()} is called
         * immediately and its result is passed to {@link #tlsExpression(IngressTlsProtocolExpression)}.
         * 
         * @param tlsExpression
         *        a consumer that will call methods on {@link IngressTlsProtocolExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tlsExpression(IngressTlsProtocolExpression)
         */
        default Builder tlsExpression(Consumer<IngressTlsProtocolExpression.Builder> tlsExpression) {
            return tlsExpression(IngressTlsProtocolExpression.builder().applyMutation(tlsExpression).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IngressBooleanExpression booleanExpression;

        private IngressIpv4Expression ipExpression;

        private IngressStringExpression stringExpression;

        private IngressTlsProtocolExpression tlsExpression;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyCondition model) {
            booleanExpression(model.booleanExpression);
            ipExpression(model.ipExpression);
            stringExpression(model.stringExpression);
            tlsExpression(model.tlsExpression);
        }

        public final IngressBooleanExpression.Builder getBooleanExpression() {
            return booleanExpression != null ? booleanExpression.toBuilder() : null;
        }

        public final void setBooleanExpression(IngressBooleanExpression.BuilderImpl booleanExpression) {
            Object oldValue = this.booleanExpression;
            this.booleanExpression = booleanExpression != null ? booleanExpression.build() : null;
            handleUnionValueChange(Type.BOOLEAN_EXPRESSION, oldValue, this.booleanExpression);
        }

        @Override
        public final Builder booleanExpression(IngressBooleanExpression booleanExpression) {
            Object oldValue = this.booleanExpression;
            this.booleanExpression = booleanExpression;
            handleUnionValueChange(Type.BOOLEAN_EXPRESSION, oldValue, this.booleanExpression);
            return this;
        }

        public final IngressIpv4Expression.Builder getIpExpression() {
            return ipExpression != null ? ipExpression.toBuilder() : null;
        }

        public final void setIpExpression(IngressIpv4Expression.BuilderImpl ipExpression) {
            Object oldValue = this.ipExpression;
            this.ipExpression = ipExpression != null ? ipExpression.build() : null;
            handleUnionValueChange(Type.IP_EXPRESSION, oldValue, this.ipExpression);
        }

        @Override
        public final Builder ipExpression(IngressIpv4Expression ipExpression) {
            Object oldValue = this.ipExpression;
            this.ipExpression = ipExpression;
            handleUnionValueChange(Type.IP_EXPRESSION, oldValue, this.ipExpression);
            return this;
        }

        public final IngressStringExpression.Builder getStringExpression() {
            return stringExpression != null ? stringExpression.toBuilder() : null;
        }

        public final void setStringExpression(IngressStringExpression.BuilderImpl stringExpression) {
            Object oldValue = this.stringExpression;
            this.stringExpression = stringExpression != null ? stringExpression.build() : null;
            handleUnionValueChange(Type.STRING_EXPRESSION, oldValue, this.stringExpression);
        }

        @Override
        public final Builder stringExpression(IngressStringExpression stringExpression) {
            Object oldValue = this.stringExpression;
            this.stringExpression = stringExpression;
            handleUnionValueChange(Type.STRING_EXPRESSION, oldValue, this.stringExpression);
            return this;
        }

        public final IngressTlsProtocolExpression.Builder getTlsExpression() {
            return tlsExpression != null ? tlsExpression.toBuilder() : null;
        }

        public final void setTlsExpression(IngressTlsProtocolExpression.BuilderImpl tlsExpression) {
            Object oldValue = this.tlsExpression;
            this.tlsExpression = tlsExpression != null ? tlsExpression.build() : null;
            handleUnionValueChange(Type.TLS_EXPRESSION, oldValue, this.tlsExpression);
        }

        @Override
        public final Builder tlsExpression(IngressTlsProtocolExpression tlsExpression) {
            Object oldValue = this.tlsExpression;
            this.tlsExpression = tlsExpression;
            handleUnionValueChange(Type.TLS_EXPRESSION, oldValue, this.tlsExpression);
            return this;
        }

        @Override
        public PolicyCondition build() {
            return new PolicyCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PolicyCondition#type()
     */
    public enum Type {
        BOOLEAN_EXPRESSION,

        IP_EXPRESSION,

        STRING_EXPRESSION,

        TLS_EXPRESSION,

        UNKNOWN_TO_SDK_VERSION
    }
}
