/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleSetResponse extends MailManagerResponse implements
        ToCopyableBuilder<CreateRuleSetResponse.Builder, CreateRuleSetResponse> {
    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetId").getter(getter(CreateRuleSetResponse::ruleSetId)).setter(setter(Builder::ruleSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SET_ID_FIELD));

    private final String ruleSetId;

    private CreateRuleSetResponse(BuilderImpl builder) {
        super(builder);
        this.ruleSetId = builder.ruleSetId;
    }

    /**
     * <p>
     * The identifier of the created rule set.
     * </p>
     * 
     * @return The identifier of the created rule set.
     */
    public final String ruleSetId() {
        return ruleSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleSetResponse)) {
            return false;
        }
        CreateRuleSetResponse other = (CreateRuleSetResponse) obj;
        return Objects.equals(ruleSetId(), other.ruleSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRuleSetResponse").add("RuleSetId", ruleSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSetId":
            return Optional.ofNullable(clazz.cast(ruleSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleSetResponse, T> g) {
        return obj -> g.apply((CreateRuleSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleSetResponse> {
        /**
         * <p>
         * The identifier of the created rule set.
         * </p>
         * 
         * @param ruleSetId
         *        The identifier of the created rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetId(String ruleSetId);
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private String ruleSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleSetResponse model) {
            super(model);
            ruleSetId(model.ruleSetId);
        }

        public final String getRuleSetId() {
            return ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        @Override
        public CreateRuleSetResponse build() {
            return new CreateRuleSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
