/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response containing details about the requested archived email message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetArchiveMessageResponse extends MailManagerResponse implements
        ToCopyableBuilder<GetArchiveMessageResponse.Builder, GetArchiveMessageResponse> {
    private static final SdkField<Envelope> ENVELOPE_FIELD = SdkField.<Envelope> builder(MarshallingType.SDK_POJO)
            .memberName("Envelope").getter(getter(GetArchiveMessageResponse::envelope)).setter(setter(Builder::envelope))
            .constructor(Envelope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Envelope").build()).build();

    private static final SdkField<String> MESSAGE_DOWNLOAD_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageDownloadLink").getter(getter(GetArchiveMessageResponse::messageDownloadLink))
            .setter(setter(Builder::messageDownloadLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageDownloadLink").build())
            .build();

    private static final SdkField<Metadata> METADATA_FIELD = SdkField.<Metadata> builder(MarshallingType.SDK_POJO)
            .memberName("Metadata").getter(getter(GetArchiveMessageResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(Metadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVELOPE_FIELD,
            MESSAGE_DOWNLOAD_LINK_FIELD, METADATA_FIELD));

    private final Envelope envelope;

    private final String messageDownloadLink;

    private final Metadata metadata;

    private GetArchiveMessageResponse(BuilderImpl builder) {
        super(builder);
        this.envelope = builder.envelope;
        this.messageDownloadLink = builder.messageDownloadLink;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The SMTP envelope information of the email.
     * </p>
     * 
     * @return The SMTP envelope information of the email.
     */
    public final Envelope envelope() {
        return envelope;
    }

    /**
     * <p>
     * A pre-signed URL to temporarily download the full message content.
     * </p>
     * 
     * @return A pre-signed URL to temporarily download the full message content.
     */
    public final String messageDownloadLink() {
        return messageDownloadLink;
    }

    /**
     * <p>
     * The metadata about the email.
     * </p>
     * 
     * @return The metadata about the email.
     */
    public final Metadata metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(envelope());
        hashCode = 31 * hashCode + Objects.hashCode(messageDownloadLink());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveMessageResponse)) {
            return false;
        }
        GetArchiveMessageResponse other = (GetArchiveMessageResponse) obj;
        return Objects.equals(envelope(), other.envelope()) && Objects.equals(messageDownloadLink(), other.messageDownloadLink())
                && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetArchiveMessageResponse").add("Envelope", envelope())
                .add("MessageDownloadLink", messageDownloadLink()).add("Metadata", metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Envelope":
            return Optional.ofNullable(clazz.cast(envelope()));
        case "MessageDownloadLink":
            return Optional.ofNullable(clazz.cast(messageDownloadLink()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveMessageResponse, T> g) {
        return obj -> g.apply((GetArchiveMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MailManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetArchiveMessageResponse> {
        /**
         * <p>
         * The SMTP envelope information of the email.
         * </p>
         * 
         * @param envelope
         *        The SMTP envelope information of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder envelope(Envelope envelope);

        /**
         * <p>
         * The SMTP envelope information of the email.
         * </p>
         * This is a convenience method that creates an instance of the {@link Envelope.Builder} avoiding the need to
         * create one manually via {@link Envelope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Envelope.Builder#build()} is called immediately and its result is
         * passed to {@link #envelope(Envelope)}.
         * 
         * @param envelope
         *        a consumer that will call methods on {@link Envelope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #envelope(Envelope)
         */
        default Builder envelope(Consumer<Envelope.Builder> envelope) {
            return envelope(Envelope.builder().applyMutation(envelope).build());
        }

        /**
         * <p>
         * A pre-signed URL to temporarily download the full message content.
         * </p>
         * 
         * @param messageDownloadLink
         *        A pre-signed URL to temporarily download the full message content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageDownloadLink(String messageDownloadLink);

        /**
         * <p>
         * The metadata about the email.
         * </p>
         * 
         * @param metadata
         *        The metadata about the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Metadata metadata);

        /**
         * <p>
         * The metadata about the email.
         * </p>
         * This is a convenience method that creates an instance of the {@link Metadata.Builder} avoiding the need to
         * create one manually via {@link Metadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Metadata.Builder#build()} is called immediately and its result is
         * passed to {@link #metadata(Metadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link Metadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(Metadata)
         */
        default Builder metadata(Consumer<Metadata.Builder> metadata) {
            return metadata(Metadata.builder().applyMutation(metadata).build());
        }
    }

    static final class BuilderImpl extends MailManagerResponse.BuilderImpl implements Builder {
        private Envelope envelope;

        private String messageDownloadLink;

        private Metadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveMessageResponse model) {
            super(model);
            envelope(model.envelope);
            messageDownloadLink(model.messageDownloadLink);
            metadata(model.metadata);
        }

        public final Envelope.Builder getEnvelope() {
            return envelope != null ? envelope.toBuilder() : null;
        }

        public final void setEnvelope(Envelope.BuilderImpl envelope) {
            this.envelope = envelope != null ? envelope.build() : null;
        }

        @Override
        public final Builder envelope(Envelope envelope) {
            this.envelope = envelope;
            return this;
        }

        public final String getMessageDownloadLink() {
            return messageDownloadLink;
        }

        public final void setMessageDownloadLink(String messageDownloadLink) {
            this.messageDownloadLink = messageDownloadLink;
        }

        @Override
        public final Builder messageDownloadLink(String messageDownloadLink) {
            this.messageDownloadLink = messageDownloadLink;
            return this;
        }

        public final Metadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(Metadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public GetArchiveMessageResponse build() {
            return new GetArchiveMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
