/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata about the email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Metadata implements SdkPojo, Serializable, ToCopyableBuilder<Metadata.Builder, Metadata> {
    private static final SdkField<String> INGRESS_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IngressPointId").getter(getter(Metadata::ingressPointId)).setter(setter(Builder::ingressPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPointId").build()).build();

    private static final SdkField<String> RULE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetId").getter(getter(Metadata::ruleSetId)).setter(setter(Builder::ruleSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetId").build()).build();

    private static final SdkField<String> SENDER_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderHostname").getter(getter(Metadata::senderHostname)).setter(setter(Builder::senderHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderHostname").build()).build();

    private static final SdkField<String> SENDER_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderIpAddress").getter(getter(Metadata::senderIpAddress)).setter(setter(Builder::senderIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderIpAddress").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Timestamp").getter(getter(Metadata::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<String> TLS_CIPHER_SUITE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TlsCipherSuite").getter(getter(Metadata::tlsCipherSuite)).setter(setter(Builder::tlsCipherSuite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsCipherSuite").build()).build();

    private static final SdkField<String> TLS_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TlsProtocol").getter(getter(Metadata::tlsProtocol)).setter(setter(Builder::tlsProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsProtocol").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyId").getter(getter(Metadata::trafficPolicyId)).setter(setter(Builder::trafficPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGRESS_POINT_ID_FIELD,
            RULE_SET_ID_FIELD, SENDER_HOSTNAME_FIELD, SENDER_IP_ADDRESS_FIELD, TIMESTAMP_FIELD, TLS_CIPHER_SUITE_FIELD,
            TLS_PROTOCOL_FIELD, TRAFFIC_POLICY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ingressPointId;

    private final String ruleSetId;

    private final String senderHostname;

    private final String senderIpAddress;

    private final Instant timestamp;

    private final String tlsCipherSuite;

    private final String tlsProtocol;

    private final String trafficPolicyId;

    private Metadata(BuilderImpl builder) {
        this.ingressPointId = builder.ingressPointId;
        this.ruleSetId = builder.ruleSetId;
        this.senderHostname = builder.senderHostname;
        this.senderIpAddress = builder.senderIpAddress;
        this.timestamp = builder.timestamp;
        this.tlsCipherSuite = builder.tlsCipherSuite;
        this.tlsProtocol = builder.tlsProtocol;
        this.trafficPolicyId = builder.trafficPolicyId;
    }

    /**
     * <p>
     * The ID of the ingress endpoint through which the email was received.
     * </p>
     * 
     * @return The ID of the ingress endpoint through which the email was received.
     */
    public final String ingressPointId() {
        return ingressPointId;
    }

    /**
     * <p>
     * The ID of the rule set that processed the email.
     * </p>
     * 
     * @return The ID of the rule set that processed the email.
     */
    public final String ruleSetId() {
        return ruleSetId;
    }

    /**
     * <p>
     * The name of the host from which the email was received.
     * </p>
     * 
     * @return The name of the host from which the email was received.
     */
    public final String senderHostname() {
        return senderHostname;
    }

    /**
     * <p>
     * The IP address of the host from which the email was received.
     * </p>
     * 
     * @return The IP address of the host from which the email was received.
     */
    public final String senderIpAddress() {
        return senderIpAddress;
    }

    /**
     * <p>
     * The timestamp of when the email was received.
     * </p>
     * 
     * @return The timestamp of when the email was received.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The TLS cipher suite used to communicate with the host from which the email was received.
     * </p>
     * 
     * @return The TLS cipher suite used to communicate with the host from which the email was received.
     */
    public final String tlsCipherSuite() {
        return tlsCipherSuite;
    }

    /**
     * <p>
     * The TLS protocol used to communicate with the host from which the email was received.
     * </p>
     * 
     * @return The TLS protocol used to communicate with the host from which the email was received.
     */
    public final String tlsProtocol() {
        return tlsProtocol;
    }

    /**
     * <p>
     * The ID of the traffic policy that was in effect when the email was received.
     * </p>
     * 
     * @return The ID of the traffic policy that was in effect when the email was received.
     */
    public final String trafficPolicyId() {
        return trafficPolicyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ingressPointId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetId());
        hashCode = 31 * hashCode + Objects.hashCode(senderHostname());
        hashCode = 31 * hashCode + Objects.hashCode(senderIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(tlsCipherSuite());
        hashCode = 31 * hashCode + Objects.hashCode(tlsProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata) obj;
        return Objects.equals(ingressPointId(), other.ingressPointId()) && Objects.equals(ruleSetId(), other.ruleSetId())
                && Objects.equals(senderHostname(), other.senderHostname())
                && Objects.equals(senderIpAddress(), other.senderIpAddress()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(tlsCipherSuite(), other.tlsCipherSuite()) && Objects.equals(tlsProtocol(), other.tlsProtocol())
                && Objects.equals(trafficPolicyId(), other.trafficPolicyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Metadata").add("IngressPointId", ingressPointId()).add("RuleSetId", ruleSetId())
                .add("SenderHostname", senderHostname())
                .add("SenderIpAddress", senderIpAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Timestamp", timestamp()).add("TlsCipherSuite", tlsCipherSuite()).add("TlsProtocol", tlsProtocol())
                .add("TrafficPolicyId", trafficPolicyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IngressPointId":
            return Optional.ofNullable(clazz.cast(ingressPointId()));
        case "RuleSetId":
            return Optional.ofNullable(clazz.cast(ruleSetId()));
        case "SenderHostname":
            return Optional.ofNullable(clazz.cast(senderHostname()));
        case "SenderIpAddress":
            return Optional.ofNullable(clazz.cast(senderIpAddress()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "TlsCipherSuite":
            return Optional.ofNullable(clazz.cast(tlsCipherSuite()));
        case "TlsProtocol":
            return Optional.ofNullable(clazz.cast(tlsProtocol()));
        case "TrafficPolicyId":
            return Optional.ofNullable(clazz.cast(trafficPolicyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Metadata, T> g) {
        return obj -> g.apply((Metadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Metadata> {
        /**
         * <p>
         * The ID of the ingress endpoint through which the email was received.
         * </p>
         * 
         * @param ingressPointId
         *        The ID of the ingress endpoint through which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressPointId(String ingressPointId);

        /**
         * <p>
         * The ID of the rule set that processed the email.
         * </p>
         * 
         * @param ruleSetId
         *        The ID of the rule set that processed the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetId(String ruleSetId);

        /**
         * <p>
         * The name of the host from which the email was received.
         * </p>
         * 
         * @param senderHostname
         *        The name of the host from which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderHostname(String senderHostname);

        /**
         * <p>
         * The IP address of the host from which the email was received.
         * </p>
         * 
         * @param senderIpAddress
         *        The IP address of the host from which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderIpAddress(String senderIpAddress);

        /**
         * <p>
         * The timestamp of when the email was received.
         * </p>
         * 
         * @param timestamp
         *        The timestamp of when the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The TLS cipher suite used to communicate with the host from which the email was received.
         * </p>
         * 
         * @param tlsCipherSuite
         *        The TLS cipher suite used to communicate with the host from which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsCipherSuite(String tlsCipherSuite);

        /**
         * <p>
         * The TLS protocol used to communicate with the host from which the email was received.
         * </p>
         * 
         * @param tlsProtocol
         *        The TLS protocol used to communicate with the host from which the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tlsProtocol(String tlsProtocol);

        /**
         * <p>
         * The ID of the traffic policy that was in effect when the email was received.
         * </p>
         * 
         * @param trafficPolicyId
         *        The ID of the traffic policy that was in effect when the email was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);
    }

    static final class BuilderImpl implements Builder {
        private String ingressPointId;

        private String ruleSetId;

        private String senderHostname;

        private String senderIpAddress;

        private Instant timestamp;

        private String tlsCipherSuite;

        private String tlsProtocol;

        private String trafficPolicyId;

        private BuilderImpl() {
        }

        private BuilderImpl(Metadata model) {
            ingressPointId(model.ingressPointId);
            ruleSetId(model.ruleSetId);
            senderHostname(model.senderHostname);
            senderIpAddress(model.senderIpAddress);
            timestamp(model.timestamp);
            tlsCipherSuite(model.tlsCipherSuite);
            tlsProtocol(model.tlsProtocol);
            trafficPolicyId(model.trafficPolicyId);
        }

        public final String getIngressPointId() {
            return ingressPointId;
        }

        public final void setIngressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
        }

        @Override
        public final Builder ingressPointId(String ingressPointId) {
            this.ingressPointId = ingressPointId;
            return this;
        }

        public final String getRuleSetId() {
            return ruleSetId;
        }

        public final void setRuleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
        }

        @Override
        public final Builder ruleSetId(String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        public final String getSenderHostname() {
            return senderHostname;
        }

        public final void setSenderHostname(String senderHostname) {
            this.senderHostname = senderHostname;
        }

        @Override
        public final Builder senderHostname(String senderHostname) {
            this.senderHostname = senderHostname;
            return this;
        }

        public final String getSenderIpAddress() {
            return senderIpAddress;
        }

        public final void setSenderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
        }

        @Override
        public final Builder senderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getTlsCipherSuite() {
            return tlsCipherSuite;
        }

        public final void setTlsCipherSuite(String tlsCipherSuite) {
            this.tlsCipherSuite = tlsCipherSuite;
        }

        @Override
        public final Builder tlsCipherSuite(String tlsCipherSuite) {
            this.tlsCipherSuite = tlsCipherSuite;
            return this;
        }

        public final String getTlsProtocol() {
            return tlsProtocol;
        }

        public final void setTlsProtocol(String tlsProtocol) {
            this.tlsProtocol = tlsProtocol;
        }

        @Override
        public final Builder tlsProtocol(String tlsProtocol) {
            this.tlsProtocol = tlsProtocol;
            return this;
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        @Override
        public Metadata build() {
            return new Metadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
