/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action for a rule to take. Only one of the contained actions can be set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleAction implements SdkPojo, Serializable, ToCopyableBuilder<RuleAction.Builder, RuleAction> {
    private static final SdkField<AddHeaderAction> ADD_HEADER_FIELD = SdkField
            .<AddHeaderAction> builder(MarshallingType.SDK_POJO).memberName("AddHeader").getter(getter(RuleAction::addHeader))
            .setter(setter(Builder::addHeader)).constructor(AddHeaderAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddHeader").build()).build();

    private static final SdkField<ArchiveAction> ARCHIVE_FIELD = SdkField.<ArchiveAction> builder(MarshallingType.SDK_POJO)
            .memberName("Archive").getter(getter(RuleAction::archive)).setter(setter(Builder::archive))
            .constructor(ArchiveAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Archive").build()).build();

    private static final SdkField<DeliverToMailboxAction> DELIVER_TO_MAILBOX_FIELD = SdkField
            .<DeliverToMailboxAction> builder(MarshallingType.SDK_POJO).memberName("DeliverToMailbox")
            .getter(getter(RuleAction::deliverToMailbox)).setter(setter(Builder::deliverToMailbox))
            .constructor(DeliverToMailboxAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverToMailbox").build()).build();

    private static final SdkField<DropAction> DROP_FIELD = SdkField.<DropAction> builder(MarshallingType.SDK_POJO)
            .memberName("Drop").getter(getter(RuleAction::drop)).setter(setter(Builder::drop)).constructor(DropAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Drop").build()).build();

    private static final SdkField<RelayAction> RELAY_FIELD = SdkField.<RelayAction> builder(MarshallingType.SDK_POJO)
            .memberName("Relay").getter(getter(RuleAction::relay)).setter(setter(Builder::relay))
            .constructor(RelayAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relay").build()).build();

    private static final SdkField<ReplaceRecipientAction> REPLACE_RECIPIENT_FIELD = SdkField
            .<ReplaceRecipientAction> builder(MarshallingType.SDK_POJO).memberName("ReplaceRecipient")
            .getter(getter(RuleAction::replaceRecipient)).setter(setter(Builder::replaceRecipient))
            .constructor(ReplaceRecipientAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceRecipient").build()).build();

    private static final SdkField<SendAction> SEND_FIELD = SdkField.<SendAction> builder(MarshallingType.SDK_POJO)
            .memberName("Send").getter(getter(RuleAction::send)).setter(setter(Builder::send)).constructor(SendAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Send").build()).build();

    private static final SdkField<S3Action> WRITE_TO_S3_FIELD = SdkField.<S3Action> builder(MarshallingType.SDK_POJO)
            .memberName("WriteToS3").getter(getter(RuleAction::writeToS3)).setter(setter(Builder::writeToS3))
            .constructor(S3Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteToS3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_HEADER_FIELD,
            ARCHIVE_FIELD, DELIVER_TO_MAILBOX_FIELD, DROP_FIELD, RELAY_FIELD, REPLACE_RECIPIENT_FIELD, SEND_FIELD,
            WRITE_TO_S3_FIELD));

    private static final long serialVersionUID = 1L;

    private final AddHeaderAction addHeader;

    private final ArchiveAction archive;

    private final DeliverToMailboxAction deliverToMailbox;

    private final DropAction drop;

    private final RelayAction relay;

    private final ReplaceRecipientAction replaceRecipient;

    private final SendAction send;

    private final S3Action writeToS3;

    private final Type type;

    private RuleAction(BuilderImpl builder) {
        this.addHeader = builder.addHeader;
        this.archive = builder.archive;
        this.deliverToMailbox = builder.deliverToMailbox;
        this.drop = builder.drop;
        this.relay = builder.relay;
        this.replaceRecipient = builder.replaceRecipient;
        this.send = builder.send;
        this.writeToS3 = builder.writeToS3;
        this.type = builder.type;
    }

    /**
     * <p>
     * This action adds a header. This can be used to add arbitrary email headers.
     * </p>
     * 
     * @return This action adds a header. This can be used to add arbitrary email headers.
     */
    public final AddHeaderAction addHeader() {
        return addHeader;
    }

    /**
     * <p>
     * This action archives the email. This can be used to deliver an email to an archive.
     * </p>
     * 
     * @return This action archives the email. This can be used to deliver an email to an archive.
     */
    public final ArchiveAction archive() {
        return archive;
    }

    /**
     * <p>
     * This action delivers an email to a WorkMail mailbox.
     * </p>
     * 
     * @return This action delivers an email to a WorkMail mailbox.
     */
    public final DeliverToMailboxAction deliverToMailbox() {
        return deliverToMailbox;
    }

    /**
     * <p>
     * This action terminates the evaluation of rules in the rule set.
     * </p>
     * 
     * @return This action terminates the evaluation of rules in the rule set.
     */
    public final DropAction drop() {
        return drop;
    }

    /**
     * <p>
     * This action relays the email to another SMTP server.
     * </p>
     * 
     * @return This action relays the email to another SMTP server.
     */
    public final RelayAction relay() {
        return relay;
    }

    /**
     * <p>
     * The action replaces certain or all recipients with a different set of recipients.
     * </p>
     * 
     * @return The action replaces certain or all recipients with a different set of recipients.
     */
    public final ReplaceRecipientAction replaceRecipient() {
        return replaceRecipient;
    }

    /**
     * <p>
     * This action sends the email to the internet.
     * </p>
     * 
     * @return This action sends the email to the internet.
     */
    public final SendAction send() {
        return send;
    }

    /**
     * <p>
     * This action writes the MIME content of the email to an S3 bucket.
     * </p>
     * 
     * @return This action writes the MIME content of the email to an S3 bucket.
     */
    public final S3Action writeToS3() {
        return writeToS3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addHeader());
        hashCode = 31 * hashCode + Objects.hashCode(archive());
        hashCode = 31 * hashCode + Objects.hashCode(deliverToMailbox());
        hashCode = 31 * hashCode + Objects.hashCode(drop());
        hashCode = 31 * hashCode + Objects.hashCode(relay());
        hashCode = 31 * hashCode + Objects.hashCode(replaceRecipient());
        hashCode = 31 * hashCode + Objects.hashCode(send());
        hashCode = 31 * hashCode + Objects.hashCode(writeToS3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleAction)) {
            return false;
        }
        RuleAction other = (RuleAction) obj;
        return Objects.equals(addHeader(), other.addHeader()) && Objects.equals(archive(), other.archive())
                && Objects.equals(deliverToMailbox(), other.deliverToMailbox()) && Objects.equals(drop(), other.drop())
                && Objects.equals(relay(), other.relay()) && Objects.equals(replaceRecipient(), other.replaceRecipient())
                && Objects.equals(send(), other.send()) && Objects.equals(writeToS3(), other.writeToS3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleAction").add("AddHeader", addHeader()).add("Archive", archive())
                .add("DeliverToMailbox", deliverToMailbox()).add("Drop", drop()).add("Relay", relay())
                .add("ReplaceRecipient", replaceRecipient()).add("Send", send()).add("WriteToS3", writeToS3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddHeader":
            return Optional.ofNullable(clazz.cast(addHeader()));
        case "Archive":
            return Optional.ofNullable(clazz.cast(archive()));
        case "DeliverToMailbox":
            return Optional.ofNullable(clazz.cast(deliverToMailbox()));
        case "Drop":
            return Optional.ofNullable(clazz.cast(drop()));
        case "Relay":
            return Optional.ofNullable(clazz.cast(relay()));
        case "ReplaceRecipient":
            return Optional.ofNullable(clazz.cast(replaceRecipient()));
        case "Send":
            return Optional.ofNullable(clazz.cast(send()));
        case "WriteToS3":
            return Optional.ofNullable(clazz.cast(writeToS3()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #addHeader()} initialized to the given value.
     *
     * <p>
     * This action adds a header. This can be used to add arbitrary email headers.
     * </p>
     * 
     * @param addHeader
     *        This action adds a header. This can be used to add arbitrary email headers.
     */
    public static RuleAction fromAddHeader(AddHeaderAction addHeader) {
        return builder().addHeader(addHeader).build();
    }

    /**
     * Create an instance of this class with {@link #addHeader()} initialized to the given value.
     *
     * <p>
     * This action adds a header. This can be used to add arbitrary email headers.
     * </p>
     * 
     * @param addHeader
     *        This action adds a header. This can be used to add arbitrary email headers.
     */
    public static RuleAction fromAddHeader(Consumer<AddHeaderAction.Builder> addHeader) {
        AddHeaderAction.Builder builder = AddHeaderAction.builder();
        addHeader.accept(builder);
        return fromAddHeader(builder.build());
    }

    /**
     * Create an instance of this class with {@link #archive()} initialized to the given value.
     *
     * <p>
     * This action archives the email. This can be used to deliver an email to an archive.
     * </p>
     * 
     * @param archive
     *        This action archives the email. This can be used to deliver an email to an archive.
     */
    public static RuleAction fromArchive(ArchiveAction archive) {
        return builder().archive(archive).build();
    }

    /**
     * Create an instance of this class with {@link #archive()} initialized to the given value.
     *
     * <p>
     * This action archives the email. This can be used to deliver an email to an archive.
     * </p>
     * 
     * @param archive
     *        This action archives the email. This can be used to deliver an email to an archive.
     */
    public static RuleAction fromArchive(Consumer<ArchiveAction.Builder> archive) {
        ArchiveAction.Builder builder = ArchiveAction.builder();
        archive.accept(builder);
        return fromArchive(builder.build());
    }

    /**
     * Create an instance of this class with {@link #deliverToMailbox()} initialized to the given value.
     *
     * <p>
     * This action delivers an email to a WorkMail mailbox.
     * </p>
     * 
     * @param deliverToMailbox
     *        This action delivers an email to a WorkMail mailbox.
     */
    public static RuleAction fromDeliverToMailbox(DeliverToMailboxAction deliverToMailbox) {
        return builder().deliverToMailbox(deliverToMailbox).build();
    }

    /**
     * Create an instance of this class with {@link #deliverToMailbox()} initialized to the given value.
     *
     * <p>
     * This action delivers an email to a WorkMail mailbox.
     * </p>
     * 
     * @param deliverToMailbox
     *        This action delivers an email to a WorkMail mailbox.
     */
    public static RuleAction fromDeliverToMailbox(Consumer<DeliverToMailboxAction.Builder> deliverToMailbox) {
        DeliverToMailboxAction.Builder builder = DeliverToMailboxAction.builder();
        deliverToMailbox.accept(builder);
        return fromDeliverToMailbox(builder.build());
    }

    /**
     * Create an instance of this class with {@link #drop()} initialized to the given value.
     *
     * <p>
     * This action terminates the evaluation of rules in the rule set.
     * </p>
     * 
     * @param drop
     *        This action terminates the evaluation of rules in the rule set.
     */
    public static RuleAction fromDrop(DropAction drop) {
        return builder().drop(drop).build();
    }

    /**
     * Create an instance of this class with {@link #drop()} initialized to the given value.
     *
     * <p>
     * This action terminates the evaluation of rules in the rule set.
     * </p>
     * 
     * @param drop
     *        This action terminates the evaluation of rules in the rule set.
     */
    public static RuleAction fromDrop(Consumer<DropAction.Builder> drop) {
        DropAction.Builder builder = DropAction.builder();
        drop.accept(builder);
        return fromDrop(builder.build());
    }

    /**
     * Create an instance of this class with {@link #relay()} initialized to the given value.
     *
     * <p>
     * This action relays the email to another SMTP server.
     * </p>
     * 
     * @param relay
     *        This action relays the email to another SMTP server.
     */
    public static RuleAction fromRelay(RelayAction relay) {
        return builder().relay(relay).build();
    }

    /**
     * Create an instance of this class with {@link #relay()} initialized to the given value.
     *
     * <p>
     * This action relays the email to another SMTP server.
     * </p>
     * 
     * @param relay
     *        This action relays the email to another SMTP server.
     */
    public static RuleAction fromRelay(Consumer<RelayAction.Builder> relay) {
        RelayAction.Builder builder = RelayAction.builder();
        relay.accept(builder);
        return fromRelay(builder.build());
    }

    /**
     * Create an instance of this class with {@link #replaceRecipient()} initialized to the given value.
     *
     * <p>
     * The action replaces certain or all recipients with a different set of recipients.
     * </p>
     * 
     * @param replaceRecipient
     *        The action replaces certain or all recipients with a different set of recipients.
     */
    public static RuleAction fromReplaceRecipient(ReplaceRecipientAction replaceRecipient) {
        return builder().replaceRecipient(replaceRecipient).build();
    }

    /**
     * Create an instance of this class with {@link #replaceRecipient()} initialized to the given value.
     *
     * <p>
     * The action replaces certain or all recipients with a different set of recipients.
     * </p>
     * 
     * @param replaceRecipient
     *        The action replaces certain or all recipients with a different set of recipients.
     */
    public static RuleAction fromReplaceRecipient(Consumer<ReplaceRecipientAction.Builder> replaceRecipient) {
        ReplaceRecipientAction.Builder builder = ReplaceRecipientAction.builder();
        replaceRecipient.accept(builder);
        return fromReplaceRecipient(builder.build());
    }

    /**
     * Create an instance of this class with {@link #send()} initialized to the given value.
     *
     * <p>
     * This action sends the email to the internet.
     * </p>
     * 
     * @param send
     *        This action sends the email to the internet.
     */
    public static RuleAction fromSend(SendAction send) {
        return builder().send(send).build();
    }

    /**
     * Create an instance of this class with {@link #send()} initialized to the given value.
     *
     * <p>
     * This action sends the email to the internet.
     * </p>
     * 
     * @param send
     *        This action sends the email to the internet.
     */
    public static RuleAction fromSend(Consumer<SendAction.Builder> send) {
        SendAction.Builder builder = SendAction.builder();
        send.accept(builder);
        return fromSend(builder.build());
    }

    /**
     * Create an instance of this class with {@link #writeToS3()} initialized to the given value.
     *
     * <p>
     * This action writes the MIME content of the email to an S3 bucket.
     * </p>
     * 
     * @param writeToS3
     *        This action writes the MIME content of the email to an S3 bucket.
     */
    public static RuleAction fromWriteToS3(S3Action writeToS3) {
        return builder().writeToS3(writeToS3).build();
    }

    /**
     * Create an instance of this class with {@link #writeToS3()} initialized to the given value.
     *
     * <p>
     * This action writes the MIME content of the email to an S3 bucket.
     * </p>
     * 
     * @param writeToS3
     *        This action writes the MIME content of the email to an S3 bucket.
     */
    public static RuleAction fromWriteToS3(Consumer<S3Action.Builder> writeToS3) {
        S3Action.Builder builder = S3Action.builder();
        writeToS3.accept(builder);
        return fromWriteToS3(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleAction, T> g) {
        return obj -> g.apply((RuleAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleAction> {
        /**
         * <p>
         * This action adds a header. This can be used to add arbitrary email headers.
         * </p>
         * 
         * @param addHeader
         *        This action adds a header. This can be used to add arbitrary email headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addHeader(AddHeaderAction addHeader);

        /**
         * <p>
         * This action adds a header. This can be used to add arbitrary email headers.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddHeaderAction.Builder} avoiding the
         * need to create one manually via {@link AddHeaderAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddHeaderAction.Builder#build()} is called immediately and its
         * result is passed to {@link #addHeader(AddHeaderAction)}.
         * 
         * @param addHeader
         *        a consumer that will call methods on {@link AddHeaderAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addHeader(AddHeaderAction)
         */
        default Builder addHeader(Consumer<AddHeaderAction.Builder> addHeader) {
            return addHeader(AddHeaderAction.builder().applyMutation(addHeader).build());
        }

        /**
         * <p>
         * This action archives the email. This can be used to deliver an email to an archive.
         * </p>
         * 
         * @param archive
         *        This action archives the email. This can be used to deliver an email to an archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archive(ArchiveAction archive);

        /**
         * <p>
         * This action archives the email. This can be used to deliver an email to an archive.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArchiveAction.Builder} avoiding the need
         * to create one manually via {@link ArchiveAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchiveAction.Builder#build()} is called immediately and its
         * result is passed to {@link #archive(ArchiveAction)}.
         * 
         * @param archive
         *        a consumer that will call methods on {@link ArchiveAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archive(ArchiveAction)
         */
        default Builder archive(Consumer<ArchiveAction.Builder> archive) {
            return archive(ArchiveAction.builder().applyMutation(archive).build());
        }

        /**
         * <p>
         * This action delivers an email to a WorkMail mailbox.
         * </p>
         * 
         * @param deliverToMailbox
         *        This action delivers an email to a WorkMail mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliverToMailbox(DeliverToMailboxAction deliverToMailbox);

        /**
         * <p>
         * This action delivers an email to a WorkMail mailbox.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeliverToMailboxAction.Builder} avoiding
         * the need to create one manually via {@link DeliverToMailboxAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeliverToMailboxAction.Builder#build()} is called immediately and
         * its result is passed to {@link #deliverToMailbox(DeliverToMailboxAction)}.
         * 
         * @param deliverToMailbox
         *        a consumer that will call methods on {@link DeliverToMailboxAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliverToMailbox(DeliverToMailboxAction)
         */
        default Builder deliverToMailbox(Consumer<DeliverToMailboxAction.Builder> deliverToMailbox) {
            return deliverToMailbox(DeliverToMailboxAction.builder().applyMutation(deliverToMailbox).build());
        }

        /**
         * <p>
         * This action terminates the evaluation of rules in the rule set.
         * </p>
         * 
         * @param drop
         *        This action terminates the evaluation of rules in the rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder drop(DropAction drop);

        /**
         * <p>
         * This action terminates the evaluation of rules in the rule set.
         * </p>
         * This is a convenience method that creates an instance of the {@link DropAction.Builder} avoiding the need to
         * create one manually via {@link DropAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DropAction.Builder#build()} is called immediately and its result
         * is passed to {@link #drop(DropAction)}.
         * 
         * @param drop
         *        a consumer that will call methods on {@link DropAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #drop(DropAction)
         */
        default Builder drop(Consumer<DropAction.Builder> drop) {
            return drop(DropAction.builder().applyMutation(drop).build());
        }

        /**
         * <p>
         * This action relays the email to another SMTP server.
         * </p>
         * 
         * @param relay
         *        This action relays the email to another SMTP server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relay(RelayAction relay);

        /**
         * <p>
         * This action relays the email to another SMTP server.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelayAction.Builder} avoiding the need to
         * create one manually via {@link RelayAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelayAction.Builder#build()} is called immediately and its result
         * is passed to {@link #relay(RelayAction)}.
         * 
         * @param relay
         *        a consumer that will call methods on {@link RelayAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relay(RelayAction)
         */
        default Builder relay(Consumer<RelayAction.Builder> relay) {
            return relay(RelayAction.builder().applyMutation(relay).build());
        }

        /**
         * <p>
         * The action replaces certain or all recipients with a different set of recipients.
         * </p>
         * 
         * @param replaceRecipient
         *        The action replaces certain or all recipients with a different set of recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceRecipient(ReplaceRecipientAction replaceRecipient);

        /**
         * <p>
         * The action replaces certain or all recipients with a different set of recipients.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplaceRecipientAction.Builder} avoiding
         * the need to create one manually via {@link ReplaceRecipientAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplaceRecipientAction.Builder#build()} is called immediately and
         * its result is passed to {@link #replaceRecipient(ReplaceRecipientAction)}.
         * 
         * @param replaceRecipient
         *        a consumer that will call methods on {@link ReplaceRecipientAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replaceRecipient(ReplaceRecipientAction)
         */
        default Builder replaceRecipient(Consumer<ReplaceRecipientAction.Builder> replaceRecipient) {
            return replaceRecipient(ReplaceRecipientAction.builder().applyMutation(replaceRecipient).build());
        }

        /**
         * <p>
         * This action sends the email to the internet.
         * </p>
         * 
         * @param send
         *        This action sends the email to the internet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder send(SendAction send);

        /**
         * <p>
         * This action sends the email to the internet.
         * </p>
         * This is a convenience method that creates an instance of the {@link SendAction.Builder} avoiding the need to
         * create one manually via {@link SendAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SendAction.Builder#build()} is called immediately and its result
         * is passed to {@link #send(SendAction)}.
         * 
         * @param send
         *        a consumer that will call methods on {@link SendAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #send(SendAction)
         */
        default Builder send(Consumer<SendAction.Builder> send) {
            return send(SendAction.builder().applyMutation(send).build());
        }

        /**
         * <p>
         * This action writes the MIME content of the email to an S3 bucket.
         * </p>
         * 
         * @param writeToS3
         *        This action writes the MIME content of the email to an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeToS3(S3Action writeToS3);

        /**
         * <p>
         * This action writes the MIME content of the email to an S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Action.Builder} avoiding the need to
         * create one manually via {@link S3Action#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Action.Builder#build()} is called immediately and its result is
         * passed to {@link #writeToS3(S3Action)}.
         * 
         * @param writeToS3
         *        a consumer that will call methods on {@link S3Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #writeToS3(S3Action)
         */
        default Builder writeToS3(Consumer<S3Action.Builder> writeToS3) {
            return writeToS3(S3Action.builder().applyMutation(writeToS3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AddHeaderAction addHeader;

        private ArchiveAction archive;

        private DeliverToMailboxAction deliverToMailbox;

        private DropAction drop;

        private RelayAction relay;

        private ReplaceRecipientAction replaceRecipient;

        private SendAction send;

        private S3Action writeToS3;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleAction model) {
            addHeader(model.addHeader);
            archive(model.archive);
            deliverToMailbox(model.deliverToMailbox);
            drop(model.drop);
            relay(model.relay);
            replaceRecipient(model.replaceRecipient);
            send(model.send);
            writeToS3(model.writeToS3);
        }

        public final AddHeaderAction.Builder getAddHeader() {
            return addHeader != null ? addHeader.toBuilder() : null;
        }

        public final void setAddHeader(AddHeaderAction.BuilderImpl addHeader) {
            Object oldValue = this.addHeader;
            this.addHeader = addHeader != null ? addHeader.build() : null;
            handleUnionValueChange(Type.ADD_HEADER, oldValue, this.addHeader);
        }

        @Override
        public final Builder addHeader(AddHeaderAction addHeader) {
            Object oldValue = this.addHeader;
            this.addHeader = addHeader;
            handleUnionValueChange(Type.ADD_HEADER, oldValue, this.addHeader);
            return this;
        }

        public final ArchiveAction.Builder getArchive() {
            return archive != null ? archive.toBuilder() : null;
        }

        public final void setArchive(ArchiveAction.BuilderImpl archive) {
            Object oldValue = this.archive;
            this.archive = archive != null ? archive.build() : null;
            handleUnionValueChange(Type.ARCHIVE, oldValue, this.archive);
        }

        @Override
        public final Builder archive(ArchiveAction archive) {
            Object oldValue = this.archive;
            this.archive = archive;
            handleUnionValueChange(Type.ARCHIVE, oldValue, this.archive);
            return this;
        }

        public final DeliverToMailboxAction.Builder getDeliverToMailbox() {
            return deliverToMailbox != null ? deliverToMailbox.toBuilder() : null;
        }

        public final void setDeliverToMailbox(DeliverToMailboxAction.BuilderImpl deliverToMailbox) {
            Object oldValue = this.deliverToMailbox;
            this.deliverToMailbox = deliverToMailbox != null ? deliverToMailbox.build() : null;
            handleUnionValueChange(Type.DELIVER_TO_MAILBOX, oldValue, this.deliverToMailbox);
        }

        @Override
        public final Builder deliverToMailbox(DeliverToMailboxAction deliverToMailbox) {
            Object oldValue = this.deliverToMailbox;
            this.deliverToMailbox = deliverToMailbox;
            handleUnionValueChange(Type.DELIVER_TO_MAILBOX, oldValue, this.deliverToMailbox);
            return this;
        }

        public final DropAction.Builder getDrop() {
            return drop != null ? drop.toBuilder() : null;
        }

        public final void setDrop(DropAction.BuilderImpl drop) {
            Object oldValue = this.drop;
            this.drop = drop != null ? drop.build() : null;
            handleUnionValueChange(Type.DROP, oldValue, this.drop);
        }

        @Override
        public final Builder drop(DropAction drop) {
            Object oldValue = this.drop;
            this.drop = drop;
            handleUnionValueChange(Type.DROP, oldValue, this.drop);
            return this;
        }

        public final RelayAction.Builder getRelay() {
            return relay != null ? relay.toBuilder() : null;
        }

        public final void setRelay(RelayAction.BuilderImpl relay) {
            Object oldValue = this.relay;
            this.relay = relay != null ? relay.build() : null;
            handleUnionValueChange(Type.RELAY, oldValue, this.relay);
        }

        @Override
        public final Builder relay(RelayAction relay) {
            Object oldValue = this.relay;
            this.relay = relay;
            handleUnionValueChange(Type.RELAY, oldValue, this.relay);
            return this;
        }

        public final ReplaceRecipientAction.Builder getReplaceRecipient() {
            return replaceRecipient != null ? replaceRecipient.toBuilder() : null;
        }

        public final void setReplaceRecipient(ReplaceRecipientAction.BuilderImpl replaceRecipient) {
            Object oldValue = this.replaceRecipient;
            this.replaceRecipient = replaceRecipient != null ? replaceRecipient.build() : null;
            handleUnionValueChange(Type.REPLACE_RECIPIENT, oldValue, this.replaceRecipient);
        }

        @Override
        public final Builder replaceRecipient(ReplaceRecipientAction replaceRecipient) {
            Object oldValue = this.replaceRecipient;
            this.replaceRecipient = replaceRecipient;
            handleUnionValueChange(Type.REPLACE_RECIPIENT, oldValue, this.replaceRecipient);
            return this;
        }

        public final SendAction.Builder getSend() {
            return send != null ? send.toBuilder() : null;
        }

        public final void setSend(SendAction.BuilderImpl send) {
            Object oldValue = this.send;
            this.send = send != null ? send.build() : null;
            handleUnionValueChange(Type.SEND, oldValue, this.send);
        }

        @Override
        public final Builder send(SendAction send) {
            Object oldValue = this.send;
            this.send = send;
            handleUnionValueChange(Type.SEND, oldValue, this.send);
            return this;
        }

        public final S3Action.Builder getWriteToS3() {
            return writeToS3 != null ? writeToS3.toBuilder() : null;
        }

        public final void setWriteToS3(S3Action.BuilderImpl writeToS3) {
            Object oldValue = this.writeToS3;
            this.writeToS3 = writeToS3 != null ? writeToS3.build() : null;
            handleUnionValueChange(Type.WRITE_TO_S3, oldValue, this.writeToS3);
        }

        @Override
        public final Builder writeToS3(S3Action writeToS3) {
            Object oldValue = this.writeToS3;
            this.writeToS3 = writeToS3;
            handleUnionValueChange(Type.WRITE_TO_S3, oldValue, this.writeToS3);
            return this;
        }

        @Override
        public RuleAction build() {
            return new RuleAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RuleAction#type()
     */
    public enum Type {
        ADD_HEADER,

        ARCHIVE,

        DELIVER_TO_MAILBOX,

        DROP,

        RELAY,

        REPLACE_RECIPIENT,

        SEND,

        WRITE_TO_S3,

        UNKNOWN_TO_SDK_VERSION
    }
}
