/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The current status of an archive search job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchStatus implements SdkPojo, Serializable, ToCopyableBuilder<SearchStatus.Builder, SearchStatus> {
    private static final SdkField<Instant> COMPLETION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTimestamp").getter(getter(SearchStatus::completionTimestamp))
            .setter(setter(Builder::completionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTimestamp").build())
            .build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(SearchStatus::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(SearchStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> SUBMISSION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmissionTimestamp").getter(getter(SearchStatus::submissionTimestamp))
            .setter(setter(Builder::submissionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmissionTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIMESTAMP_FIELD,
            ERROR_MESSAGE_FIELD, STATE_FIELD, SUBMISSION_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant completionTimestamp;

    private final String errorMessage;

    private final String state;

    private final Instant submissionTimestamp;

    private SearchStatus(BuilderImpl builder) {
        this.completionTimestamp = builder.completionTimestamp;
        this.errorMessage = builder.errorMessage;
        this.state = builder.state;
        this.submissionTimestamp = builder.submissionTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the search completed (if finished).
     * </p>
     * 
     * @return The timestamp of when the search completed (if finished).
     */
    public final Instant completionTimestamp() {
        return completionTimestamp;
    }

    /**
     * <p>
     * An error message if the search failed.
     * </p>
     * 
     * @return An error message if the search failed.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The current state of the search job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SearchState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the search job.
     * @see SearchState
     */
    public final SearchState state() {
        return SearchState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the search job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SearchState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the search job.
     * @see SearchState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The timestamp of when the search was submitted.
     * </p>
     * 
     * @return The timestamp of when the search was submitted.
     */
    public final Instant submissionTimestamp() {
        return submissionTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submissionTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchStatus)) {
            return false;
        }
        SearchStatus other = (SearchStatus) obj;
        return Objects.equals(completionTimestamp(), other.completionTimestamp())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(submissionTimestamp(), other.submissionTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchStatus").add("CompletionTimestamp", completionTimestamp())
                .add("ErrorMessage", errorMessage()).add("State", stateAsString())
                .add("SubmissionTimestamp", submissionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompletionTimestamp":
            return Optional.ofNullable(clazz.cast(completionTimestamp()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "SubmissionTimestamp":
            return Optional.ofNullable(clazz.cast(submissionTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchStatus, T> g) {
        return obj -> g.apply((SearchStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchStatus> {
        /**
         * <p>
         * The timestamp of when the search completed (if finished).
         * </p>
         * 
         * @param completionTimestamp
         *        The timestamp of when the search completed (if finished).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTimestamp(Instant completionTimestamp);

        /**
         * <p>
         * An error message if the search failed.
         * </p>
         * 
         * @param errorMessage
         *        An error message if the search failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The current state of the search job.
         * </p>
         * 
         * @param state
         *        The current state of the search job.
         * @see SearchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the search job.
         * </p>
         * 
         * @param state
         *        The current state of the search job.
         * @see SearchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchState
         */
        Builder state(SearchState state);

        /**
         * <p>
         * The timestamp of when the search was submitted.
         * </p>
         * 
         * @param submissionTimestamp
         *        The timestamp of when the search was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submissionTimestamp(Instant submissionTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private Instant completionTimestamp;

        private String errorMessage;

        private String state;

        private Instant submissionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchStatus model) {
            completionTimestamp(model.completionTimestamp);
            errorMessage(model.errorMessage);
            state(model.state);
            submissionTimestamp(model.submissionTimestamp);
        }

        public final Instant getCompletionTimestamp() {
            return completionTimestamp;
        }

        public final void setCompletionTimestamp(Instant completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
        }

        @Override
        public final Builder completionTimestamp(Instant completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SearchState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getSubmissionTimestamp() {
            return submissionTimestamp;
        }

        public final void setSubmissionTimestamp(Instant submissionTimestamp) {
            this.submissionTimestamp = submissionTimestamp;
        }

        @Override
        public final Builder submissionTimestamp(Instant submissionTimestamp) {
            this.submissionTimestamp = submissionTimestamp;
            return this;
        }

        @Override
        public SearchStatus build() {
            return new SearchStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
